<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Mail;
use Illuminate\Support\Facades\Validator;

class BriefController extends Controller
{
  function web()
  {
    return view('website-brief');
  }

  function logo()
  {
    return view('logo-brief');
  }

  public function add_website_brief(Request $request)
  {
    $rules = [
      'name' => 'required|string|min:3|max:50',
      'email' => 'required|email',
      'business_name' => 'required|string|min:3|max:50',
      'type_website' => 'required|string',
      'business_description' => 'required|string',
      'business_industry' => 'required|string',
      'target_audience' => 'required|string',
      'number_of_pages' => 'nullable|integer',
      'competitor1' => 'required|string',
      'competitor2' => 'nullable|string',
      'competitor3' => 'nullable|string',
      'selector' => 'array',
      'domain_name' => 'nullable',
      'pages_name' => 'required|string',
    ];

    $messages = [
      'name.required' => 'The name field is required.',
      'name.string' => 'The name must be a string.',
      'name.min' => 'The name must be at least :min characters.',
      'name.max' => 'The name must not exceed :max characters.',
      'email.required' => 'The email field is required.',
      'email.email' => 'Please provide a valid email address.',
      'business_name.required' => 'The business name field is required.',
      'business_name.string' => 'The business name must be a string.',
      'business_name.min' => 'The business name must be at least :min characters.',
      'business_name.max' => 'The business name must not exceed :max characters.',
      'type_website.required' => 'Please select a type of website.',
      'type_website.string' => 'The website type must be a string.',
      'business_description.required' => 'The business description field is required.',
      'business_description.string' => 'The business description must be a string.',
      'business_industry.required' => 'Please provide the business industry.',
      'business_industry.string' => 'The business industry must be a string.',
      'target_audience.required' => 'Please provide the target audience.',
      'target_audience.string' => 'The target audience must be a string.',
      'number_of_pages.required' => 'The number of pages field is required.',
      'number_of_pages.integer' => 'The number of pages must be an integer.',
      'competitor1.required' => 'Please provide the first competitor.',
      'competitor1.string' => 'The first competitor must be a string.',
      'competitor2.string' => 'The second competitor must be a string.',
      'competitor3.string' => 'The third competitor must be a string.',
      'selector.array' => 'The selector field must be an array.',
      'domain_name.required' => 'The domain name field is required.',
      'pages_name.required' => 'The pages name field is required.',
      'pages_name.string' => 'The pages name must be a string.',
    ];

    // Create a validator instance
    $validator = Validator::make($request->all(), $rules, $messages);

    // Perform validation
    if ($validator->fails()) {
      return redirect()->back()->withErrors($validator)->withInput();
    }

    $name = $request->name;
    $email = $request->input('email');
    $businessName = $request->input('business_name');
    $webisteType = $request->input('type_website');
    $businessDesc = $request->input('business_description');
    $businessIndus = $request->input('business_industry');
    $targetAud = $request->input('target_audience');
    $pages = $request->input('number_of_pages');
    $competitorOne = $request->input('competitor1');
    $competitorTwo = $request->input('competitor2');
    $competitorThree = $request->input('competitor3');
    $domain = $request->input('domain_name');
    $description = $request->input('pages_name');


    $serviceTypes = [
        1 => "Informative (without payment integration)",
        2 => "Informative (with payment integration to sell services)",
        3 => "E-commerce (Products upload with payment Integration)",
        4 => "Web App (With Custom Dashboard)",
    ];
  
    $ServeiceHeading = $serviceTypes[$webisteType] ?? "";

    $array = array_filter([$request->already_logo, $request->revamp_logo, $request->hosting_server, $request->responsive_website]);

    $web_tags = $request->selector != null ? implode(', ', $request->selector) : "N/A";
    $webQuestions = $array != null ? implode(', ', $array) : " ";
    $webFeauthers = $request->websitefeatures != null ? implode(', ', $request->websitefeatures) : " ";


    $uploadedFiles = $request->hasFile('fileToUpload') ? 
        array_map(function ($file) {
            $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $extension = $file->getClientOriginalExtension();
            $newFilename = $filename . '_' . time() . '.' . $extension;
            $file->storeAs('public/website-brief', $newFilename);
            return $newFilename;
        }, $request->file('fileToUpload')) : 
        ["no_files.txt"];
 

        $uploadedFiles = implode(',', $uploadedFiles);
       
        $insertGetId = DB::table('web_brief')->insertGetId([
            'person_name' => $name,
            'email' => $email,
            'business_name' => $businessName,
            'website_type' => $webisteType,
            'business_description' => $businessDesc,
            'business_industry' => $businessIndus,
            'target_audience' => $targetAud,
            'no_of_pages' => $pages,
            'business_ref_1' => $competitorOne,
            'business_ref_2' => $competitorTwo,
            'business_ref_3' => $competitorThree,
            'domain' => $domain,
            'webpages_description' => $description,
            'web_questions' => $webQuestions,
            'website_feel_type' => $web_tags,
            'website_features' => $webFeauthers,
            'files' => $uploadedFiles
        ]);

        $website = DB::table('web_brief')->where('id', $insertGetId)->first();


        $attachmentHTML = $check = [];
        $filesArray = explode(',', $website->files);
        
        foreach ($filesArray as $key => $file) {
            if ($file !== "no_files.txt") {
                $check[] = "/storage/app/public/website-brief/" . $file;
                $attachmentLink = "https://sanjoselogodesign.com/storage/app/public/website-brief/" . $file;
                $attachmentHTML[] = "<p style='max-width: 596px; line-height: 1.5; overflow-wrap: break-word;'><b>Attachment " . ($key + 1) . ": </b> <a href='$attachmentLink' target='_blank'>Click Here to see the attachment</a></p>";
            }
        }
        
        $attachmentHTML = implode("\n", $attachmentHTML);



        $clinetAccount = '<tr>
        <td height="73" align="left" valign="middle">
            <p>' . $name . ' has filled the Brief For Website, the details are specified bellow</p>';
                $clinetAccount .= !empty($name) ? '<p style="padding-bottom:5px" ><strong>Full Name: </strong>' . $name . '</p>' : '';
                $clinetAccount .= !empty($email) ? '<p style="padding-bottom:5px" ><strong>Email Address: </strong>' . $email . '</p>' : '';
                $clinetAccount .= !empty($businessName) ? '<p style="padding-bottom:5px" ><strong>Business Name: </strong>' . $businessName . '</p>' : '';
                $clinetAccount .= !empty($webisteType) ? '<p style="padding-bottom:5px" ><strong>Website Type: </strong>' . $ServeiceHeading . '</p>' : '';
                $clinetAccount .= !empty($request->numServices) ? '<p style="padding-bottom:5px" ><strong>Number Of Services: </strong>' . $request->numServices . '</p>' : '';
                $clinetAccount .= !empty($request->futureImages) ? '<p style="padding-bottom:5px" ><strong>Future Images: </strong>' . $request->futureImages . '</p>' : '';

                $clinetAccount .= !empty($request->numServicesOption2) ? '<p style="padding-bottom:5px" ><strong>Number Of Services: </strong>' . $request->numServicesOption2 . '</p>' : '';
                $clinetAccount .= !empty($request->acceptOnlinePayments) ? '<p style="padding-bottom:5px" ><strong>Accept Online Payments: </strong>' . $request->acceptOnlinePayments . '</p>' : '';
                $clinetAccount .= !empty($request->futureImagesOption2) ? '<p style="padding-bottom:5px" ><strong>Future Images: </strong>' . $request->futureImagesOption2 . '</p>' : '';
                $clinetAccount .= !empty($request->platformRequired) ? '<p style="padding-bottom:5px" ><strong>Platform Required: </strong>' . $request->platformRequired . '</p>' : '';
                $clinetAccount .= !empty($request->numCategories) ? '<p style="padding-bottom:5px" ><strong>Number of Categories: </strong>' . $request->numCategories . '</p>' : '';
                $clinetAccount .= !empty($request->numProductsOption3) ? '<p style="padding-bottom:5px" ><strong>Number of Products: </strong>' . $request->numProductsOption3 . '</p>' : '';
                $clinetAccount .= !empty($request->productSource) ? '<p style="padding-bottom:5px" ><strong>Product Source: </strong>' . $request->productSource . '</p>' : '';

                $clinetAccount .= !empty($request->acceptOnlinePaymentsOption3) ? '<p style="padding-bottom:5px" ><strong>Accept Online Payments: </strong>' . $request->acceptOnlinePaymentsOption3 . '</p>' : '';
                $clinetAccount .= !empty($request->futureImagesOption3) ? '<p style="padding-bottom:5px" ><strong>Future Images: </strong>' . $request->futureImagesOption3 . '</p>' : '';
                $clinetAccount .= !empty($request->platformRequiredWeb) ? '<p style="padding-bottom:5px" ><strong>Platform Required: </strong>' . $request->platformRequiredWeb . '</p>' : '';
                $clinetAccount .= !empty($request->acceptOnlinePaymentsWebApp) ? '<p style="padding-bottom:5px" ><strong>Accept Online Payments: </strong>' . $request->acceptOnlinePaymentsWebApp . '</p>' : '';

                $clinetAccount .= !empty($businessDesc) ? '<p style="padding-bottom:5px" ><strong>Business Description: </strong>' . $businessDesc . '</p>' : '';
                $clinetAccount .= !empty($busintargetAudessDesc) ? '<p style="padding-bottom:5px" ><strong>Target Audience: </strong>' . $targetAud . '</p>' : '';
                $clinetAccount .= !empty($pages) ? '<p style="padding-bottom:5px" ><strong>Pages: </strong>' . $pages . '</p>' : '';
                $clinetAccount .= !empty($competitorOne) ? '<p style="padding-bottom:5px" ><strong>Business Refrence 1: </strong>' . $competitorOne . '</p>' : '';
                $clinetAccount .= !empty($competitorTwo) ? '<p style="padding-bottom:5px" ><strong>Business Refrence 2: </strong>' . $competitorTwo . '</p>' : '';
                $clinetAccount .= !empty($competitorThree) ? '<p style="padding-bottom:5px" ><strong>Business Refrence 3: </strong>' . $competitorThree . '</p>' : '';
                $clinetAccount .= !empty($domain) ? '<p style="padding-bottom:5px" ><strong>Domain: </strong>' . $domain . '</p>' : '';
                $clinetAccount .= !empty($description) ? '<p style="padding-bottom:5px" ><strong>Web Description: </strong>' . $description . '</p>' : '';
                $clinetAccount .= !empty($webQuestions) ? '<p style="padding-bottom:5px" ><strong>Web Questions: </strong>' . $webQuestions . '</p>' : '';
                $clinetAccount .= !empty($web_tags) ? '<p style="padding-bottom:5px" ><strong>Website Feel Type: </strong>' . $web_tags . '</p>' : '';
                $clinetAccount .= !empty($webFeauthers) ? '<p style="padding-bottom:5px" ><strong>Web Features: </strong>' . $webFeauthers . '</p>' : '';
                $clinetAccount .= $attachmentHTML.'
            </td>
        </tr>';

       
        // $recipents = ['adil.sattar122@gmail.com'];
        $recipents = [env('ADMIN_EMAIL'), env('SAMEER_EMAIL'), env('BILAL_EMAIL')];

        $data = [
            'subject' => env('APP_NAME') . ' Website Brief',
            'email' => $recipents,
            'content' => $clinetAccount

        ];

        Mail::send('includes.email', $data, function ($message) use ($data) {
            $message->to($data['email'])
                ->subject($data['subject'])->from(env('MAIL_FROM_ADDRESS'), env('APP_NAME'));
        });


        return redirect('/thankyou')->with('success', 'Your Brief has been sent, You will get contacted soon, Thank you.');
  }

  public function add_logo_brief(Request $request)
  {
    $rules = [
      'name' => 'required|string|min:3|max:50',
      'email' => 'required|email',
      'logo_name' => 'required|string|min:3|max:50',
      'industry' => 'nullable|string',
      'personal_phone' => ['required', 'regex:/^[0-9]{10}$/'],
      'business_desc' => 'required|string',
      'logo_description' => 'required|string',
      'company_slogan' => 'nullable|string',
      'competitors_ref' => 'required|string',
      'competitors_ref_two' => 'nullable|string',
      'competitors_ref_three' => 'nullable|string',
    ];


    $customMessages = [
      'personal_phone.required' => 'Please provide your personal phone number.',
      'personal_phone.regex' => 'The personal phone number must be a 10-digit number.'

    ];

    // Create a validator instance
    $validator = Validator::make($request->all(), $rules, $customMessages);

    // Perform validation
    if ($validator->fails()) {
      return redirect()->back()->withErrors($validator)->withInput();
    }

    $name = $request->input('name');
    $email = $request->input('email');
    $logoname = $request->input('logo_name');
    $competitor = $request->input('competitors_ref');
    $competitorTwo = $request->input('competitors_ref_two');
    $competitorThree = $request->input('competitors_ref_three');
    $businessDesc = $request->input('business_desc');
    $slogan = $request->input('company_slogan');
    $phone = $request->input('personal_phone');
    $companyPhone = $request->input('company_phone');
    $industry = $request->input('industry');
    $logoDesc = $request->input('logo_description');
    $logoType = $request->input('logo_type');
    $logoFonts = $request->input('logo_fonts');
    $logoColor = $request->input('logo_color');
    $primaryColor = $request->input('primary_color');
    $secondaryColor = $request->input('secondary_color');
    $lead_id = $request->input('lead_id');


    if ($request->hasFile('files')) {
      $uploadedFiles = [];

      foreach ($request->file('files') as $file) {
        // Get filename with the extension
        $filenameWithExtension = $file->getClientOriginalName();

        // Getting just the filename
        $filename = pathinfo($filenameWithExtension, PATHINFO_FILENAME);

        // Getting just the extension
        $extension = $file->getClientOriginalExtension();

        // Filename to store
        $newFilename = $filename . '_' . time() . '.' . $extension;

        $path = $file->storeAs('public/logo_brief', $newFilename);

        $uploadedFiles[] = $newFilename;
      }
    } else {
      $uploadedFiles = ["no_files.txt"];
    }
    $uploadedFiles = implode(',', $uploadedFiles);


    $insertIdGet = DB::table('logo_brief')->insertGetId([

      'person_name' => $name,

      'email' => $email,

      'logo_name' => $logoname,

      'competitor_name' => $competitor,
      'competitor_two' => $competitorTwo,
      'competitor_three' => $competitorThree,

      'company_slogan' => $slogan,

      'personal_phone' => $phone,

      'company_phone' => $companyPhone,

      'industry' => $industry,

      'logo_type' => $logoType,

      'logo_fonts' => $logoFonts,

      'logo_color' => $logoColor,

      'primary_color' => $primaryColor,

      'secondary_color' => $secondaryColor,

      'business_description' => $businessDesc,

      'logo_description' => $logoDesc,

      'files' => $uploadedFiles

    ]);
    DB::disconnect();
    return redirect('/logo-brief-email/' . $insertIdGet);
  }



  public function brief_email_logo($insertGetId)
  {


    $website = DB::table('logo_brief')->where('id', $insertGetId)->first();

    if ($website) {
      $name = $website->person_name;
      $email = $website->email;
      $logo = $website->logo_name;
      $competitor = $website->competitor_name;
      $competitorTwo = $website->competitor_two;
      $competitorThree = $website->competitor_three;
      $slogan = $website->company_slogan;
      $personalPhone = $website->personal_phone;
      $companyPhone = $website->company_phone;
      $industry = $website->industry;
      $logoType = $website->logo_type;
      $fonts = $website->logo_fonts;
      $logoColor = $website->logo_color;
      $primaryColor = $website->primary_color;
      $secondaryColor = $website->secondary_color;
      $description1 = $website->business_description;
      $description2 = $website->logo_description;
      $files = $website->files;
    }


    $attachmentHTML = [];

    $count = 1;
    $filesArray = explode(',', $files);
    foreach ($filesArray as $key => $file) {
      if ($file !== "no_files.txt") {
        $attachmentLink = "https://sanjoselogodesign.com/storage/app/public/logo_brief/" . $file;
        $attachmentHTML[] = "<p style='max-width: 596px; line-height: 1.5; overflow-wrap: break-word;'><b>Attachment $count: </b> <a href='$attachmentLink' target='_blank'>Click Here to see the attachment</a></p>";
      }
      $count++;
    }
    $attachmentHTML = implode("\n", $attachmentHTML);


    $clientAccount = '<tr>
        <td height="73" align="left" valign="middle">
            <span style="font-size:13px;color:#302b2b;font-family:Arial, Helvetica, sans-serif;">' . $name . ' has filled the Brief For Website, the details are specified below</span>
            
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Full Name: </b>' . $name . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Email Address: </b>' . $email . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Logo: </b>' . $logo . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Competitor: </b>' . $competitor . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Competitor: </b>' . $competitorTwo . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Competitor: </b>' . $competitorThree . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Slogan: </b>' . $slogan . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Personal Phone: </b>' . $personalPhone . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Company Phone: </b>' . $companyPhone . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Industry: </b>' . $industry . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Logo Type: </b>' . $logoType . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Fonts: </b>' . $fonts . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Logo Color: </b>' . $logoColor . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Primary Color: </b>' . $primaryColor . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Secondary Color</b>' . $secondaryColor . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Business Description: </b>' . $description1 . '</p>
            <p style="max-width: 596px; line-height: 1.5; overflow-wrap: break-word;"><b>Logo Description: </b>' . $description2 . '</p>
            ' . $attachmentHTML . '
        </td>
    </tr>';


    $recipents_logo = [env('ADMIN_EMAIL'), env('SAMEER_EMAIL'), env('BILAL_EMAIL')];
    $data = [

      'subject' => env('APP_NAME') . ' Logo Brief',

      'emails' => $recipents_logo,

      'content' => $clientAccount

    ];

    Mail::send('includes.email', $data, function ($message) use ($data) {

      $message->to($data['emails'])
        ->subject($data['subject'])->from(env('MAIL_FROM_ADDRESS'), env('APP_NAME'));
    });

    return redirect('/thankyou')
      ->with('success', 'Your Brief has been sent, You will get contacted soon, Thank you.');
  }
}
