<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use App\Data;
use Mail;
use Stripe\Stripe;
use Stripe\PaymentIntent;
use Stripe\Customer;
use Illuminate\Support\Facades\Hash;

class PagesController extends Controller
{
    public function Pages(Request $request, $slug)
    {


        $ip = $request->ip();
        $data = \Location::get($ip);
        $country = $data->countryCode;
        if ($country == 'IN') {
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='maintenance'");
            return view('maintenance')->with(['pagedata' => $pagedata]);
        }

        if ($slug == "logo-design") {
            $data = DB::select("SELECT * FROM logo_packages");
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='$slug'");
            return view('logo-design')->with(['data' => $data, 'pagedata' => $pagedata]);
        } else if ($slug == "website") {
            $data = DB::select("SELECT * FROM website_package");
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='$slug'");
            return view('website')->with(['data' => $data, 'pagedata' => $pagedata]);
        } else if ($slug == "animations") {

            $data = DB::select("SELECT * FROM animation_package");
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='$slug'");
            return view('animation')->with(['data' => $data, 'pagedata' => $pagedata]);
        } else if ($slug == "mobile-apps") {
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='$slug'");
            return view('mobile-apps')->with(['pagedata' => $pagedata]);
        } else if ($slug == "digital-marketing") {
            $data = DB::select("SELECT * FROM marketing_package");
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='$slug'");
            return view('digital-marketing')->with(['data' => $data, 'pagedata' => $pagedata]);
        } else if ($slug == "seo") {
            $data = DB::select("SELECT * FROM seo_package");
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='$slug'");
            return view('seo')->with(['data' => $data, 'pagedata' => $pagedata]);
        } else if ($slug == "about-us") {
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='$slug'");
            return view('about-us')->with(['pagedata' => $pagedata]);
        } else if ($slug == "blog") {
            $data = DB::select("SELECT * FROM blogs ORDER BY created_at DESC");
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='$slug'");
            return view('blogs')->with(['data' => $data, 'pagedata' => $pagedata]);
        } else if ($slug == "privacy-policy") {
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='$slug'");
            return view('privacy-policy')->with(['pagedata' => $pagedata]);
        } else if ($slug == "contact-us") {
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='$slug'");
            return view('contact')->with(['pagedata' => $pagedata]);
        } else if ($slug == "maintenance") {
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='$slug'");
            return view('maintenance')->with(['pagedata' => $pagedata]);
        } else if ($slug == "terms-condition") {
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='$slug'");
            return view('terms-and-conditions')->with(['pagedata' => $pagedata]);
        } else if ($slug == "error") {
            return view('error');
        } else if ($slug == "payment-info") {
            $logo = DB::select("SELECT * FROM logo_packages");
            $seo = DB::select("SELECT * FROM seo_package");
            $website = DB::select("SELECT * FROM website_package");
            $marketing = DB::select("SELECT * FROM marketing_package");
            $animation = DB::select("SELECT * FROM animation_package");


            $array = array(
                'logo_packages' => $logo,
                'seo_package' => $seo,
                'website_package' => $website,
                'marketing_package' => $marketing,
                'animation_package' => $animation
            );

            return view('payment-info')->with('data', $array);
        } else {
            return response(view('includes.page-not-found'), 404);
        }
    }

    public function welcome(Request $request)
    {

        $ip = $request->ip();
        $data = \Location::get($ip);
        $country = $data->countryCode;

        if ($country == 'IN') {
            $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='maintenance'");
            return view('maintenance')->with(['pagedata' => $pagedata]);
        }

        $pagedata = DB::select("SELECT * FROM pages WHERE page_name='Home Page'");
        return view('welcome')->with(['pagedata' => $pagedata]);
    }

    public function about()
    {
        return view('about-us');
    }

    public function service()
    {
        return view('service');
    }

    public function blog()
    {

        return view('blog')->with('data', $data);
    }
    public function blogdetails($slug)
    {

        return view('blog-details')->with('blogSlug', $slug);
    }

    //contact-us starts
    public function contact()
    {
        return view('contact');
    }
    public function emailcontact(Request $request)
    {

        $recaptcha_secret = env('G_CAPTCHA_SECRET_KEY');
        $recaptcha_response = $request->input('g-recaptcha-response');

        $url = 'https://www.google.com/recaptcha/api/siteverify';

        $data = array(
            'secret' => $recaptcha_secret,
            'response' => $recaptcha_response
        );

        $options = array(
            'http' => array(
                'header' => "Content-type: application/x-www-form-urlencoded\r\n",
                'method' => 'POST',
                'content' => http_build_query($data)
            )
        );



        $context = stream_context_create($options);
        $result = file_get_contents($url, false, $context);
        $response = json_decode($result, true);

        if (!$response['success']) {
            return redirect('/thankyou')->with(['error' => 'Site owner has restricted you from accessign the website']);
        }


        $name  = $request->input('name');
        $email  = $request->input('email');
        $phone  = $request->input('phone');
        $message  = $request->input('message');
        $ip = \Request::ip();

        $blockedIps = DB::table('ip_blocking')->where('is_del', 1)->get();
        $ips = [];
        foreach ($blockedIps as $blockedIp) {
            $ips[] = $blockedIp->ip;
        }

        if (in_array($ip, $ips)) {
            return redirect('maintenance');
        }
        // if ($phone == '890' || $email = "no-replyTonasymnnus@gmail.com") {
        //     return redirect('/maintenance');
        // }

        $db = DB::table('contact_us')
            ->insert(['name' => $name, 'email' => $email, 'phone' => $phone, 'message' => $message, 'ip' => $ip]);


        $clinetAccount = '<tr>
                            <td height="73" align="left" valign="middle">
                                <span style="font-size:13px;color:#302b2b;font-family:Arial, Helvetica, sans-serif;">' . $name . ' has filled the contact us page, the details are specified bellow</span>
                                <p><b>Full Name: </b>' . $name . '</p>
                                <p><b>Email Address: </b>' . $email . '</p>
                                <p><b>Phone: </b>' . $phone . '</p>
                                <p><b>Message: </b>' . $message . '</p>
                                <p><b>Client Ip Address: </b>' . $ip . '</p>
                            </td>
                        </tr>';



        $data = [
            'subject' => env('APP_NAME') . ' - Contact Us Query',
            'email' => env('ADMIN_EMAIL'),
            'content' => $clinetAccount
        ];



        Mail::send('includes.email', $data, function ($message) use ($data) {

            $message->to($data['email'])
                ->subject($data['subject'])->from(env('MAIL_USERNAME'), env('APP_NAME'));
        });
        return redirect('/thankyou')->with('success', 'Your email has been sent, You would be contacted soon, Thank you.');
    }

    //contact-us ends
    public function privacy()
    {
        return view('privacy-policy');
    }


    public function terms()
    {
        return view('terms-and-conditions');
    }
    public function securepayment()
    {
        return view('payment-secure');
    }
    //popup form
    public function packageSelect(Request $request)
    {
        if (!$this->verifyRecaptcha($request)) {
            return response()->json(['error' => 'CAPTCHA verification failed. Please try again.']);
        }

        $validator = $this->validateRequest($request);
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->getMessageBag()->toArray()
            ], 200);
        }

        $leadId = $this->createLead($request);

        $email = $request->input('email');
        if ($email) {
           
            DB::table('missed_leads')->where('email', $email)->delete();
        }

        if ($request->input('package_price') === null) {
            return response()->json(['redirect' => '/simple-lead/'.$leadId, 'success' => true]);
       
        }

        $paymentLink = time();
        DB::table('leads')->where('id', $leadId)->update(['payment_link' => $paymentLink]);

        return response()->json(['redirect' => '/complete-payment/'.$paymentLink , 'success' => true]);
 
    }

    public function saveMissedLead(Request $request){
        $this->createTableIfNotExists();

        $email = $request->input('email');

        if (!empty($request->id)) {
            DB::table('missed_leads')->where('id', $request->id)->update([
                'name' => $request->input('name'),
                'email' => $email ?? 'NULL',
                'phone' => $request->input('phone') ?? 'NULL',
                'description' => $request->input('description'),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        } else {
            // Check if the email already exists
            $existingLead = DB::table('missed_leads')->where('email', $email)->first();

            if ($existingLead) {
                return response()->json([
                    'success' => false,
                    'message' => 'Email already exists.',
                ]);
            }

            $id = DB::table('missed_leads')->insertGetId([
                'name' => $request->input('name'),
                'email' => $email ?? 'NULL',
                'phone' => $request->input('phone') ?? 'NULL',
                'description' => $request->input('description'),
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            return response()->json(['id' => $id]);
        }

        $leads = DB::table('missed_leads')->get();

        return response()->json([
            'success' => true,
            'message' => 'Lead saved successfully.',
            'leads' => $leads
        ]);
    }


    public function createTableIfNotExists()
    {
        // SQL statement to create the table if it does not exist
        DB::statement("
            CREATE TABLE IF NOT EXISTS missed_leads (
                id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
                name VARCHAR(255) NOT NULL,
                email VARCHAR(255) NOT NULL,
                phone VARCHAR(255) NOT NULL,
                description TEXT NULL,
                created_at TIMESTAMP NULL DEFAULT NULL,
                updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP
            )
        ");
    }


    private function verifyRecaptcha(Request $request)
    {
        $recaptchaSecret = env('G_CAPTCHA_SECRET_KEY');
        $recaptchaResponse = $request->input('g-recaptcha-response');
        $url = 'https://www.google.com/recaptcha/api/siteverify';

        $data = [
            'secret' => $recaptchaSecret,
            'response' => $recaptchaResponse
        ];

        $options = [
            'http' => [
                'header' => "Content-type: application/x-www-form-urlencoded\r\n",
                'method' => 'POST',
                'content' => http_build_query($data)
            ]
        ];

        $context = stream_context_create($options);
        $result = file_get_contents($url, false, $context);
        $response = json_decode($result, true);

        return $response['success'] ?? false;
    }

    private function validateRequest(Request $request)
    {
        $rules = [
            'name' => 'required',
            'email' => 'required|email',
            'description' => 'required'
        ];

        return \Validator::make($request->all(), $rules);
    }

    private function createLead(Request $request)
    {
        $leadData = [
            'customer_name' => $request->input('name'),
            'email' => $request->input('email'),
            'phone_no' => $request->input('phone'),
            'custom_package_name' => $request->input('package_name'),
            'price' => $request->input('package_price'),
            'payment_type' => 1,
            'password' => $request->input('name'),
            'refrence' => 'Direct',
            'package_id' => $request->input('package_id'),
            'description' => $request->input('description'),
            'ip' => $request->ip()
        ];

        return DB::table('leads')->insertGetId($leadData);
    }

    public function billing(Request $request)
    {
        $name  = $request->input('name');
        $email  = $request->input('email');
        $phone  = $request->input('phone');
        $package  = $request->input('package');
        $custom  = $request->input('custom');
        $price  = $request->input('price');
        $refrence  = $request->input('refrence');
        $paymenttype  = $request->input('payment_type');
        $paymentlink  = $request->input('payment_link');
        $password = $request->input('name');
        $ip = \Request::ip();

        if ($refrence == 1) {
            $refrence = "Sam";
        } else if ($refrence == 2) {
            $refrence = "Peter";
        }
        $get_lead_id = DB::table('leads')
            ->insertGetId([
                'customer_name' => $name, 'email' => $email, 'phone_no' => $phone, 'custom_package_name' => $custom, 'price' => $price,
                'payment_type' => $paymenttype, 'password' => $password, 'refrence' => $refrence, 'ip' => $ip
            ]);

        $lead_id = time();

        DB::table('leads')
            ->where('id', $get_lead_id)
            ->update(['payment_link' => $lead_id]);

        return redirect('/complete-payment/' . $lead_id);
    }
    public function securepay($leadId)
    {

        $leads = DB::table('leads')->where('payment_link', $leadId)->first();
        if (!$leads) {
            return redirect('/thankyou')->with(['error' => 'No Payment Link Found']);
        }

        // $StripeKey = env('STRIPE_SECRET', false);    
        // \Stripe\Stripe::setApiKey($StripeKey);

        // $customer = \Stripe\Customer::create([
        //    'email' => $email,
        //    'name' => $fullname
        //   ]);


        // $payment_methods = \Stripe\PaymentMethod::all([
        // 'customer' => $customer->id,
        // 'type' => 'card'
        // ]);
        // $price *= 100;
        // $currency = 'usd';


        // $payment_intent = \Stripe\PaymentIntent::create([
        //     'description' => env('APP_NAME').' - '.$customPackage,
        //     'amount' => $price, 
        //     'currency' => $currency,
        //     'payment_method_types' => ['card'],
        //      "customer" => $customer->id,
        // ]);
        // $intent = $payment_intent;

        return view('payment-secure')->with(['data' => $leads]);
    }


    public function createPaymentIntent(Request $request)
    {
        $name = $request->name;
        $email = $request->email;

        $leads = DB::table('leads')->where('id', $request->leadId)->first();

        $stripePrice = floatval($leads->price);

        DB::table('leads')
            ->where('id', $request->leadId)
            ->update([
                "customer_name" => $name,
                "email" => $email
            ]);


        Stripe::setApiKey(env('STRIPE_SECRET'));

        $customer = Customer::create([
            'name' => $name,
            'email' => $email,
        ]);


        $price = $stripePrice * 100;

        $intent = PaymentIntent::create([
            'amount' => $price,
            'currency' => 'usd',
            'payment_method_types' => ['card'],
            'setup_future_usage' => 'off_session',
            'use_stripe_sdk' => true,
            'payment_method_options' => [
                'card' => [
                    'request_three_d_secure' => 'any',
                ],
            ],
            'customer' => $customer->id,
        ]);

        return response()->json(['clientSecret' => $intent->client_secret]);
    }


    public function handle3DSecure(Request $request)
    {

        Stripe::setApiKey(env('STRIPE_SECRET'));

        $paymentIntent = PaymentIntent::retrieve($request->input('payment_intent_id'));

        // Handle 3D Secure authentication
        $paymentIntent->confirm([
            'payment_method' => $request->input('payment_method_id'),
        ]);

        return response()->json(['status' => $paymentIntent->status]);
    }
}
