<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Str;
class ControllerBlog extends Controller
{
    public function blog(){
       $data = DB::select('SELECT * FROM blogs');
     
       return view('blog')->with('data',$data);
    }

    public function viewBlog($slug){
        $data = DB::select("SELECT * FROM blogs WHERE id='$slug'");
        return view('pages.blogs')->with('data',$data);
  }

    public function editBlog(){
        return view('pages.edit-blog');
    }
    public function createBlog(Request $request){

        $blogname = $request->input('blog_name');
        $slug = Str::slug($blogname, '-');
        $seoTitle = $request->input('seo_title');
        $seoKeywords = $request->input('seo_keywords');
        $seoDescription = $request->input('seo_description');
        $postedby = $request->input('posted_by');
        $text = $request->input('blog_text');
        $longText = $request->input('blog_html');
        $brands = $request->input('brands');
        $published_date = $request->input('published_date');
        $date = date('Y-m-d', strtotime(str_replace('-', '/', $published_date)));

        if($request->hasFile('blog_image')){

          $filenameWithExtension = $request->file('blog_image')->getClientOriginalName();
     
          $filename = pathinfo($filenameWithExtension,PATHINFO_FILENAME);

          $extension = $request->file('blog_image')->getClientOriginalExtension();
      
          $blog_cover = $filename.'_'.time().'.'.$extension;
    
          $path = $request->file('blog_image')->storeAs('public/blog_images',$blog_cover);  
        }else{
          $blog_cover = $defaultImage;
        }

        if($request->hasFile('profile')){
     
          $filenameWithExtension = $request->file('profile')->getClientOriginalName();

          $filename = pathinfo($filenameWithExtension,PATHINFO_FILENAME);
      
          $extension = $request->file('profile')->getClientOriginalExtension();
        
          $profile = $filename.'_'.time().'.'.$extension;
    
          $path = $request->file('profile')->storeAs('public/blog_images',$profile);  
        }else{
          $profile = $defaultprofile;
        }

          $blog = DB::table('blogs')
          ->insert([
            'blog_name' => $blogname,
            'posted_by' => $postedby,
            'slug' => $slug,
            'blogcontent' => $text,
            'seo_description' => $seoDescription,
            'seo_keywords' => $seoKeywords,
            'blog_html' => $longText ?? '',
            'seo_title' => $seoTitle,
            'blog_cover' => $blog_cover,
            'profile' => $profile,
            "published_date" => $date
      
          ]);
          
        return redirect('/blogs')->with('success',$blogname." has been created");
    }
    
    public function updateBlog(Request $request, $slug){
      

        $data = DB::select("SELECT * FROM blogs WHERE id='$slug'");
   
        foreach ($data as $image) {
            $defaultImage =  $image->blog_cover;
            $defaultprofile = $image->profile;
        }

        
        $blogname = $request->input('blog_name');
        $blogslug = Str::slug($blogname, '-');
      
      
        $seoTitle = $request->input('seo_title');
        $longText = $request->input('blog_html');
     
        $postedby = $request->input('posted_by');
        $seoKeywords = $request->input('seo_keywords');
        $seoDescription = $request->input('seo_description');
        $text = $request->input('blog_text');
        $published_date = $request->input('published_date');
        $date = date('Y-m-d', strtotime(str_replace('-', '/', $published_date)));
     
        if($request->hasFile('blog_image')){
            //Get filename with the extension
            $filenameWithExtension = $request->file('blog_image')->getClientOriginalName();
            //getting just filename
            $filename = pathinfo($filenameWithExtension,PATHINFO_FILENAME);
            //gettign just extension
            $extension = $request->file('blog_image')->getClientOriginalExtension();
            //filename to store 
            $blog_cover = $filename.'_'.time().'.'.$extension;
      
            $path = $request->file('blog_image')->storeAs('public/blog_images',$blog_cover);  
          }else{
            $blog_cover = $defaultImage;
          }

          if($request->hasFile('profile')){
            //Get filename with the extension
            $filenameWithExtension = $request->file('profile')->getClientOriginalName();
            //getting just filename
            $filename = pathinfo($filenameWithExtension,PATHINFO_FILENAME);
            //gettign just extension
            $extension = $request->file('profile')->getClientOriginalExtension();
            //filename to store 
            $profile = $filename.'_'.time().'.'.$extension;
      
            $path = $request->file('profile')->storeAs('public/blog_images',$profile);  
          }else{
            $profile = $defaultprofile;
          }

          $blog = DB::table('blogs')
          ->where('id', $slug)
          ->update([
            'blog_name' => $blogname,
            'posted_by' => $postedby,
            'slug' => $blogslug,
            'blogcontent' => $text,
            'blog_html' => $longText ?? '',
            'seo_title' => $seoTitle,
            'seo_description' => $seoDescription,
            'seo_keywords' => $seoKeywords,
            'blog_cover' => $blog_cover,
            'profile' => $profile,
            "published_date" => $date
      
          ]);
          
          return redirect('/blogs')->with('success',$blogname." has been Updated");

        
    }

    public function deleteBlog($slug){
        $data = DB::select("SELECT * FROM blogs WHERE id='$slug'");
   
        foreach ($data as $name) {
            $blogName =  $name->blog_name;
        }
        DB::select("DELETE FROM blogs WHERE id='$slug'");
        
        return redirect('/blogs')->with('error',$blogName." has been deleted.");

    }
}
