<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
class PackageTypeController extends Controller
{
    public function index(){
        return view('package-category');
    }

    public function addpackagetype(){
        return view('add-package-category');
    }

    public function createpackagetype(Request $request){
        $name = $request->input('name');
        $brandId = $request->input('brands');
        DB::table('package_types')
        ->insert([
            'brand_id' => $brandId,
            'package_name' => $name
        ]);
        return redirect('/package-categories')->with('success', "$name has been Added to Package Category");
    }

    public function editpackagetype($categoryID){
       return view('/edit-package-category')->with('categoryID', $categoryID);
    }

    public function updatepackagetype(Request $request, $categoryID){
        $name = $request->input('name');
        $brandId = $request->input('brands');
        DB::table('package_types')->where('id', $categoryID)
        ->update([
            'brand_id' => $brandId,
            'package_name' => $name
        ]);
        return redirect('/package-categories')->with('success', "$name has been Updated");
    }
    
    public function deletepackagetype($categoryID){
        
       DB::table('package_types')->where('id', $categoryID)
        ->delete();  
        return redirect('/package-categories')->with('error', "Selected Record has been deleted from Package Category");
      
    }
}
