<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
class PackagesController extends Controller
{
    public function packages(){   
        $packageType= DB::select('SELECT * FROM packages');
        $count = DB::table('packages')->count();
        return view('packages')->with(['packageType' => $packageType, 'count' => $count ]);
    }
    
    public function packageEdit($id){
       
        $packages = DB::select("SELECT * FROM packages WHERE id = '$id'");
        return view('package-edit')->with(['packages' => $packages]);
    }

    public function packageAdd(){
        return view('package-add');
    }

    //create-package by package-id
    public function packageCreate(Request $request){
        $packageName = $request->input('package_name');
        $slogan = $request->input('package_slogan');
        $price = $request->input('price');
        $description = $request->input('description');
        $packageId = $request->input('package_id');
        $brands = $request->input('brands');
       
        if($request->hasFile('p_logo')){
            //Get filename with the extension
            $withExtension = $request->file('p_logo')->getClientOriginalName();
            //getting just filename
            $filename = pathinfo($withExtension,PATHINFO_FILENAME);
            //gettign just extension
            $extension = $request->file('p_logo')->getClientOriginalExtension();
            //filename to store 
            $plogo = $filename.'_'.time().'.'.$extension;
      
            $path = $request->file('p_logo')->storeAs('public/package_images',$plogo);  
          }else{
            $plogo = "no_logo.png";
          }

        DB::table('packages')->insert([
            'package_name' => $packageName,
            'logo' => $plogo,
            'description' => $description,
            'price' => $price,
            'package_type' => $packageId,
            'brand_id' => $brands
        ]);
        return redirect('/packages')->with('success', $packageName." has been Added Successfuly");
       
    }
    public function packageUpdate(Request $request, $packageId){
        $packageName = $request->input('package_name');
        $slogan = $request->input('package_slogan');
        $price = $request->input('price');
        $description = $request->input('description');
        $packageTypeId = $request->input('package_type');
        
        $brands = $request->input('brands');
       
        $packages = DB::table('packages')->where('id',$packageId)->get();
        $logo = "";
       
        foreach ($packages as $value) {
            $logo = $value->logo;
        }
        if($request->hasFile('p_logo')){
            //Get filename with the extension
            $withExtension = $request->file('p_logo')->getClientOriginalName();
            //getting just filename
            $filename = pathinfo($withExtension,PATHINFO_FILENAME);
            //gettign just extension
            $extension = $request->file('p_logo')->getClientOriginalExtension();
            //filename to store 
            $plogo = $filename.'_'.time().'.'.$extension;
      
            $path = $request->file('p_logo')->storeAs('public/package_images',$plogo);  
          }else{
            $plogo = $logo;
          }


        DB::table('packages')->where('id', $packageId)->update([
            'package_name' => $packageName,
            'logo' => $plogo,
            'description' => $description,
            'price' => $price,
            'package_type' => $packageTypeId,
            'brand_id' => $brands
        ]);
        
        return redirect('/packages')->with('success', $packageName." has been Updated Successfuly");
        
    }

    public function packageDelete($packageId){
        DB::table('packages')->where('id', $packageId)->delete();
        return redirect()->back()->with('error', " Selected Package has been Deleted Successfuly");
       
    }
}
