<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
class PortfolioController extends Controller
{
    public function portfolio(){
        return view('portfolio');
    }

    public function addportfolio(){
        return view('add-portfolio');
    }

    public function editportfolio($portflioId){
        return view('edit-portfolio')->with('portflioId', $portflioId);
    }
    public function createPortfolio(Request $request){
        $brand = $request->input('brand_id');
        $portfolioTypes = $request->input('portfolioTypes');
        $alt_tag = $request->input('image_alt');
 
        if($request->hasFile('thumbnail_image')){
            //Get filename with the extension
            $withExtension = $request->file('thumbnail_image')->getClientOriginalName();
            //getting just filename
            $filename = pathinfo($withExtension,PATHINFO_FILENAME);
            //gettign just extension
            $extension = $request->file('thumbnail_image')->getClientOriginalExtension();
            //filename to store 
            $thumbnailImage = $filename.'_'.time().'.'.$extension;
      
            $path = $request->file('thumbnail_image')->storeAs('public/portfolio_images',$thumbnailImage);  
          }else{
            $thumbnailImage = "no_files.jpg";
          }

          if($request->hasFile('cover_image')){
            //Get filename with the extension
            $withExtension = $request->file('cover_image')->getClientOriginalName();
            //getting just filename
            $filename = pathinfo($withExtension,PATHINFO_FILENAME);
            //gettign just extension
            $extension = $request->file('cover_image')->getClientOriginalExtension();
            //filename to store 
            $coverImage = $filename.'_'.time().'.'.$extension;
      
            $path = $request->file('cover_image')->storeAs('public/portfolio_images',$coverImage);  
          }else{
            $coverImage = "no_files.jpg";
          }
          DB::table('portfolio')->insert([
              'brand_id' => $brand,
              'portfolio_type' => $portfolioTypes,
              'thumbnail_image' => $thumbnailImage,
              'image_alt' => $alt_tag,
              'cover_image' => $coverImage 
            ]);
            return redirect('/portfolio')->with('success', 'Record has been Added');
      
    }
    public function updatePortfolio(Request $request,$portflioId){
        $brand = $request->input('brand_id');
        $portfolioTypes = $request->input('portfolioTypes');

    
        $alt_tag = $request->input('image_alt');

        $portfolioData = DB::table('portfolio')->where('id',$portflioId)->get();
        $thumbnailDefault = "";
        $coverlDefault = "";
        foreach ($portfolioData as $value) {
            $thumbnailDefault = $value->thumbnail_image;
            $coverlDefault = $value->cover_image;
        }
     
        if($request->hasFile('thumbnail_image')){
            //Get filename with the extension
            $withExtension = $request->file('thumbnail_image')->getClientOriginalName();
            //getting just filename
            $filename = pathinfo($withExtension,PATHINFO_FILENAME);
            //gettign just extension
            $extension = $request->file('thumbnail_image')->getClientOriginalExtension();
            //filename to store 
            $thumbnailImage = $filename.'_'.time().'.'.$extension;
      
            $path = $request->file('thumbnail_image')->storeAs('public/portfolio_images',$thumbnailImage);  
          }else{
            $thumbnailImage = $thumbnailDefault;
          }

          if($request->hasFile('cover_image')){
            //Get filename with the extension
            $withExtension = $request->file('cover_image')->getClientOriginalName();
            //getting just filename
            $filename = pathinfo($withExtension,PATHINFO_FILENAME);
            //gettign just extension
            $extension = $request->file('cover_image')->getClientOriginalExtension();
            //filename to store 
            $coverImage = $filename.'_'.time().'.'.$extension;
      
            $path = $request->file('cover_image')->storeAs('public/portfolio_images',$coverImage);  
          }else{
            $coverImage = $coverlDefault;
          }
      
          DB::table('portfolio')->where('id', $portflioId)->update([
              'brand_id' => $brand,
              'portfolio_type' => $portfolioTypes,
              'thumbnail_image' => $thumbnailImage,
              'image_alt' => $alt_tag,
              'cover_image' => $coverImage 
            ]);
            return redirect('/portfolio')->with('success', 'Record has been Updated');
      
    }
    public function deleteportfolio($portflioId){
        DB::table('portfolio')->where('id', $portflioId)->delete();
        return redirect('/portfolio')->with('error', 'Selected Record has been Deleted');
    }
}
