<?php



namespace App\Http\Controllers;



use Illuminate\Http\Request;

use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Str;

use DB;

class UsersController extends Controller

{

    public function users($slug){

        return view('edit-users')->with('id', $slug);

    }



    public function addUsers(){

        return view('add-users');

    }



    public function createUsers(Request $request){

        $username = $request->input('user_name');

        $email = $request->input('email');

        $phone = $request->input('phone');

        $userType = $request->input('user_type');

        $spaces_free = Str::replace(' ', '', $request->password);

        $password = Hash::make($spaces_free);


        if($request->hasFile('profile_image')){

            //Get filename with the extension

            $filenameWithExtension = $request->file('profile_image')->getClientOriginalName();

            //getting just filename

            $filename = pathinfo($filenameWithExtension,PATHINFO_FILENAME);

            //gettign just extension

            $extension = $request->file('profile_image')->getClientOriginalExtension();

            //filename to store 

            $profileImage = $filename.'_'.time().'.'.$extension;

      

            $path = $request->file('profile_image')->storeAs('public/user-profiles',$profileImage);  

          }else{

            $profileImage = 'no Image';

          }



        

          $users = DB::table('users')

          ->insert([

            'name' => $username,

            'email' => $email,

            'phone' => $phone,

            'role' => $userType,

            'password' => $password,

            'profile' => $profileImage

      

          ]);

          

        return redirect('/users')->with('success','User '.$username." has been created");

    }

    public function editUsers(Request $request, $slug){

        $username = $request->input('user_name');

        $email = $request->input('email');

        $phone = $request->input('phone');

        $userType = $request->input('user_type');

        
      
        $newPass = Hash::make($request->new_password);
        $oldPass = $request->old_pass;
     

        $data = DB::table('users')->where('id', $slug)->get();

        foreach ($data as $value) {

          $defaultProfile = $value->profile;
          $current = $value->password;

        }

      
        if($request->hasFile('profile_image')){

            //Get filename with the extension

            $filenameWithExtension = $request->file('profile_image')->getClientOriginalName();

            //getting just filename

            $filename = pathinfo($filenameWithExtension,PATHINFO_FILENAME);

            //gettign just extension

            $extension = $request->file('profile_image')->getClientOriginalExtension();

            //filename to store 

            $profileImage = $filename.'_'.time().'.'.$extension;

      

            $path = $request->file('profile_image')->storeAs('public/user-profiles',$profileImage);  

          }else{

            $profileImage = $defaultProfile;

          }

          if($oldPass == $current){
            $users = DB::table('users')->where('id', $slug)

            ->update([
  
              'name' => $username,
  
              'email' => $email,
  
              'phone' => $phone,
  
              'role' => $userType,
  
              'password' => $newPass,
  
              'profile' => $profileImage
  
        
  
            ]);
            return redirect('/users')->with('success','User '.$username." has been Updated");
          }else{
            return redirect()->back()->with('error',"Old Password is Incorrect");
          }
  

          

      

    }

    public function deleteUsers($slug){

        DB::table('users')->where('id', $slug)->delete();

        return redirect('/users')->with('error',"Selected Record has been Deleted");

    }

}

