<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Mail;
class EmployeeController extends Controller
{
    public function assign_task(Request $request){
      
        $userleadId = $request->lead_id;
        $employeeId = $request->employee_id;
      
        //getting client_id by the submitted lead id
        $clients = DB::table('client_projects')->where('payment_id',$userleadId)->get();
        if($clients->count() > 0){
            foreach ($clients as $client) {
                $client_id = $client->client_id;
            }
            
            $userData = DB::table('users')->where('id',$client_id)->get();
            if($userData->count() > 0){
                
                //using client id that we got from the $clients we are gettig the user data spited out 
                foreach ($userData as $clientData) {
                    $clientName = $clientData->name;
                    $client_email = $clientData->email;
                
                }
            }
     
        }
    

        //getting employee data throught it's id that we got from the form 
        $employees =DB::table('users')->where('id', $employeeId)->get();
        if($employees->count() > 0){
            foreach ($employees as $employee) {
                $employeeName = $employee->name;
                $employeeEmail = $employee->email;
            }

            DB::table('assigned_projects')->insert([
                'employee_id' => $employeeId,
                'client_id' => $client_id
            ]);
            DB::table('client_projects')->where('payment_id',$userleadId)->update([
                'employee_id' => $employeeId
            ]);

        }
     
     
        $html_new_customer = '<html><body>';
        $html_new_customer .='<table width="650" border="0" align="center" cellpadding="0" cellspacing="0" style="background:#ffffff;border:#f6f6f6 4px solid;">
                <tbody>
                    <tr>
                        <td align="center" valign="top">
                            <table width="650" border="0" align="center" cellpadding="0" cellspacing="0">
                                <tbody>
                                    <tr>
                                        <td align="center" valign="top" bgcolor="#131211">
                                        <table width="80" border="0" cellspacing="0" cellpadding="0">
                                            <tbody>
                                                <tr><td height="10" align="center" valign="top"></td></tr>
                                                <tr><td align="center" valign="top"><img src="'.env('APP_LOGO').'" alt="logo-white" border="0" width="298" height="86"></td></tr>
                                                <tr><td height="10" align="center" valign="top"></td></tr>
                                            </tbody>
                                        </table>
                                        </td>
                                     </tr>
                                     <tr><td height="5" align="center" valign="middle" bgcolor="#0c0830"></td></tr>
                                </tbody>
                            </table>
                        </td>
                     </tr>
                     <tr>
                        <td width="620" align="center" valign="top">
                            <table width="596" border="0" align="center" cellpadding="0" cellspacing="0" style="font:normal 13px Arial, Helvetica, sans-serif;color:#0d0d0d;padding:0px 0;" text-align: center>
                                <tbody>
                                    <tr><td height="20" align="center" valign="middle"></td></tr>
                                    <tr><td height="20" align="left" valign="middle"></td></tr>
                                    <tr><td height="73" align="left" valign="middle">
                                        <span style="font-size:13px;color:#302b2b;font-family:Arial, Helvetica, sans-serif;">Dear Admin,</span>
                                        <p> '.$clientName.' has Purchased an Order, Head to the Admin Panel and Assign him to a Sales Person. </p>
                                        <p>Here is the Email of the Client : '.$client_email.'</p>
                                        </td></tr>
                                    <tr><td height="20" align="left" valign="middle">&nbsp;</td></tr>
                                </tbody>
                            </table>
                        </td>
                     </tr>
                     <tr><td align="center" valign="middle"></td></tr>
                     <tr><td height="98" valign="middle" bgcolor="#f6f6f6">
                        <table width="596" border="0" align="center" cellpadding="0" cellspacing="0" style="font:normal 13px Arial, Helvetica, sans-serif;color:#0d0d0d;padding:0px 0;">
                            <tbody>
                                <tr><td width="574" height="73" align="left" valign="middle"><span style="font-size:13px;color:#302b2b;font-family:Arial, Helvetica, sans-serif;">Thank you<br>Customer Care Department<br>'.env('APP_NAME').'</span></td></tr>
                            </tbody>
                        </table>
                     </td>
                    </tr>
                </tbody>
            </table>';
 
        $html_new_customer .= "</body></html>";


        $data = [
            'subject' => 'Assign Project',
            'email' => env('ADMIN_EMAIL'),
            'content' => $html_new_customer
          ];


        Mail::send('includes.email', $data, function($message) use ($data) {
        $message->to($data['email'])
        ->subject($data['subject'])->from('aoffice896@gmail.com',env('APP_NAME'));
        });


        return redirect()->back()->with('success', $employeeName.' has been assigned for '.$clientName);
    
      
    }

    public function client_projects(){
        return view('employee/client-projects');
    }

    public function happy_clients(){
        return view('happy-clients');
    }

    public function happy_clients_view(){
        return view('edit-cta-bar');
    }

    public function happy_clients_edit(Request $request){
        $happyClients = $request->input('happy_clients');
        $projectsDone = $request->input('projects_done');
        $hoursWorked = $request->input('hours_worked');

        DB::table('happy_clients')->where('id', 1)->update([
            'happy_clients' => $happyClients,
            'projects_done' => $projectsDone,
            'hours_worked' => $hoursWorked
        ]);
        return redirect('/happy-clients')->with('success', "CTA has been updated");
    }

    public function happy_clients_delete($id){
        DB::table('happy_clients')->where('id', 1)->delete();
        return redirect('/happy-clients')->with('error', "CTA has been deleted");
    }

    public function view_project($id){
        return view('employee/view-project')->with('id', $id);
    }

    public function view_my_project($id){
        return view('client/view-project')->with('id', $id);
    }
   
    public function chat(Request $request){
        $message = $request->input('message');
        $sender_id = $request->input('sender_id');
        $reciver_id = $request->input('reciver_id');
        
       
        $reciver_data = DB::table('users')->where('id', $reciver_id)->get();
        foreach ($reciver_data as $reciver) {
            $reciver_name = $reciver->name;
            $reciver_email = $reciver->email;
        }

        $sender_data = DB::table('users')->where('id', $sender_id)->get();
        foreach ($sender_data as $sender) {
            $sender_name = $sender->name;
            $sender_email = $sender->email;
        }
       
        DB::table('chat_loop')->insert([
            'message' => $message,
            'sender_id' => $sender_id,
            'reciver_id' => $reciver_id
        ]);

        $html_new_customer = '<html><body>';
        $html_new_customer .='<table width="650" border="0" align="center" cellpadding="0" cellspacing="0" style="background:#ffffff;border:#f6f6f6 4px solid;">
                <tbody>
                    <tr>
                        <td align="center" valign="top">
                            <table width="650" border="0" align="center" cellpadding="0" cellspacing="0">
                                <tbody>
                                    <tr>
                                        <td align="center" valign="top" bgcolor="#131211">
                                        <table width="80" border="0" cellspacing="0" cellpadding="0">
                                            <tbody>
                                                <tr><td height="10" align="center" valign="top"></td></tr>
                                                <tr><td align="center" valign="top"><img src="'.env('APP_LOGO').'" alt="logo-white" border="0" width="298" height="86"></td></tr>
                                                <tr><td height="10" align="center" valign="top"></td></tr>
                                            </tbody>
                                        </table>
                                        </td>
                                     </tr>
                                     <tr><td height="5" align="center" valign="middle" bgcolor="#0c0830"></td></tr>
                                </tbody>
                            </table>
                        </td>
                     </tr>
                     <tr>
                        <td width="620" align="center" valign="top">
                            <table width="596" border="0" align="center" cellpadding="0" cellspacing="0" style="font:normal 13px Arial, Helvetica, sans-serif;color:#0d0d0d;padding:0px 0;" text-align: center>
                                <tbody>
                                    <tr><td height="20" align="center" valign="middle"></td></tr>
                                    <tr><td height="20" align="left" valign="middle"></td></tr>
                                    <tr>
                                        <td height="73" align="left" valign="middle">
                                            <span style="font-size:13px;color:#302b2b;font-family:Arial, Helvetica, sans-serif;">Dear '.$reciver_name.',</span>
                                            <p> '.$sender_name.' has Sent you a message on your current Order, Head to <a href="'.env('APP_URL').'">'.env('APP_URL').'</a> to reply back, <br> Thankyou. </p>
                                            <p> <br> </p>
                                            <p> Message: <strong>'.$message.'</strong> </p>
                                        </td>
                                    </tr>
                                    <tr><td height="20" align="left" valign="middle">&nbsp;</td></tr>
                                </tbody>
                            </table>
                        </td>
                     </tr>
                     <tr><td align="center" valign="middle"></td></tr>
                     <tr><td height="98" valign="middle" bgcolor="#f6f6f6">
                        <table width="596" border="0" align="center" cellpadding="0" cellspacing="0" style="font:normal 13px Arial, Helvetica, sans-serif;color:#0d0d0d;padding:0px 0;">
                            <tbody>
                                <tr><td width="574" height="73" align="left" valign="middle"><span style="font-size:13px;color:#302b2b;font-family:Arial, Helvetica, sans-serif;">Thank you<br>Customer Care Department<br>'.env('APP_NAME').'</span></td></tr>
                            </tbody>
                        </table>
                     </td>
                    </tr>
                </tbody>
            </table>';
 
        $html_new_customer .= "</body></html>";

    
        $data = [
            'subject' => 'From '.$sender_name.'',
            'email' => $reciver_email,
            'content' => $html_new_customer
          ];


        Mail::send('includes.email', $data, function($message) use ($data) {
        $message->to($data['email'])
        ->subject($data['subject'])->from('aoffice896@gmail.com',env('APP_NAME'));
        });

        return redirect()->back();
    }
    public function update_status(Request $request){
        $p_status = $request->input('p_status');
        $project_id = $request->input('project_id');
        DB::table('client_projects')->where('id', $project_id)->update([
            'project_status' => $p_status
        ]);
        
        return redirect('/client-projects')->with('success', 'Project Status has been Updated');
    }
    public function save_description(Request $request, $id){

        $description = $request->input('project_desc');
        DB::table('client_projects')->where('id', $id)->update([
            'p_description' => $description
        ]);
        return redirect()->back()->with('success', 'Description Saved');
    }

    public function save_attachments(Request $request, $id){

        $clients = DB::table('client_projects')->where('id',$id)->get();
        foreach ($clients as $client) {
            $default_file = $client->p_attachment;
        }

        if($request->hasFile('files')){
            //Get filename with the extension
            $withExtension = $request->file('files')->getClientOriginalName();
            //getting just filename
            $filename = pathinfo($withExtension,PATHINFO_FILENAME);
            //gettign just extension
            $extension = $request->file('files')->getClientOriginalExtension();
            //filename to store 
            $file = $filename.'_'.time().'.'.$extension;
      
            $path = $request->file('files')->storeAs('public/client_attachments',$file);  
          }else{
            $default_file = "no_files.jpg";
          }

        DB::table('client_projects')->where('id', $id)->update([
            'p_attachment' => $file
        ]);
        return redirect()->back()->with('success', 'Attachment Updated');
    }
    public function payment_links(){
        return view('employee/payment-links');
    }
    public function billing_payment(){
        return view('employee/billing-details');

    }

    public function getbillinglead(Request $request){
        
    
        $name  = $request->input('name');
        $email  = $request->input('email');
        $phone  = $request->input('phone');
        $package  = $request->input('package');
        $custom  = $request->input('custom');
        $price  = $request->input('price');
        $refrence  = $request->input('refrence');
        $paymenttype  = $request->input('payment_type');
        $paymentlink  = $request->input('payment_link');
        $password = $request->input('name');    
        $employeeId = $request->employee_id;
      
       
        $get_lead_id = DB::table('leads')
        ->insertGetId([
            'customer_name' => $name,
            'email' => $email,
            'phone_no' => $phone,
            'custom_package_name' => $custom,
            'price' => $price,
            'payment_type'=> $paymenttype,
            'password' => $password,
            'refrence' => $refrence
        ]);
         
        $lead_id = 'sld-'.$get_lead_id.'-'.time(); 
        DB::table('payment_links')->insert([
            'employee_id' => $employeeId,
            'name' => $name,
            'email' => $email,
            'phone' => $phone,
            'custom' => $custom,
            'price' => $price,
            'payment_type'=> $paymenttype,
            'payment_link' => $lead_id
      
        ]);
      //http://127.0.0.1:8081/secure-pay/'.$lead_id
        
        return redirect('/payment-links')->with('success', 'Payment Link has been made');
       
    }
    public function delete_payment_link($id){
            DB::table('payment_links')->where('id', $id)->delete();
            return redirect('/payment-links')->with('error', 'Selected Payment Link has been deleted.');
    }
}
