<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
class TestimonialsController extends Controller
{
    public function testimonials(){
        return view('testimonials');
    }

    public function edit_testimonials($id){
        return view('view-testimonials')->with('id', $id);
    }

    public function add_testimonials(){
        return view('add-testimonials');
    }

    public function create_testimonials(Request $request){
        $person_name = $request->input('person_name');
        $address = $request->input('address');
        $brands = $request->input('brands');
        $remarks = $request->input('remarks');
      

    
        if($request->hasFile('profile')){
            //Get filename with the extension
            $filenameWithExtension = $request->file('profile')->getClientOriginalName();
            //getting just filename
            $filename = pathinfo($filenameWithExtension,PATHINFO_FILENAME);
            //gettign just extension
            $extension = $request->file('profile')->getClientOriginalExtension();
            //filename to store 
            $profile = $filename.'_'.time().'.'.$extension;
      
            $path = $request->file('profile')->storeAs('public/testimonial_images',$profile);  
          }else{
            $profile = "default-image.jpg";
          }

        DB::table('testimonials')->insert([
            'person_name' => $person_name,
            'address' => $address,
            'brand_id' => $brands,
            'remarks' => $remarks,
            'profile' => $profile
        ]);
      return redirect('/testimonials')->with('success', 'Testimonial has been added successfuly');
    }

    public function update_testimonials(Request $request, $id){
        $person_name = $request->input('person_name');
        $address = $request->input('address');
        $brands = $request->input('brands');
        $remarks = $request->input('remarks');

        $testimonials = DB::select("SELECT * FROM testimonials WHERE id='$id'");
   
        foreach ($testimonials as $testimonial) {
            $defaultprofile = $testimonial->profile;
        }
        if($request->hasFile('profile')){
            //Get filename with the extension
            $filenameWithExtension = $request->file('profile')->getClientOriginalName();
            //getting just filename
            $filename = pathinfo($filenameWithExtension,PATHINFO_FILENAME);
            //gettign just extension
            $extension = $request->file('profile')->getClientOriginalExtension();
            //filename to store 
            $profile = $filename.'_'.time().'.'.$extension;
      
            $path = $request->file('profile')->storeAs('public/testimonial_images',$profile);  
          }else{
            $profile = $defaultprofile;
          }
        DB::table('testimonials')->where('id', $id)->update([
            'person_name' => $person_name,
            'address' => $address,
            'brand_id' => $brands,
            'remarks' => $remarks,
            'profile' => $profile
        ]);
      return redirect('/testimonials')->with('success', 'Testimonial has been updated successfuly');
    }

    public function delete_testimonials($id){
        DB::table('testimonials')->where('id', $id)->delete();
        return redirect('/testimonials')->with('error', 'Testimonial has been deleted successfuly');
    }
}
