<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title> Login | <?php echo env('APP_NAME') ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    {{-- Head Links --}}
    @include('includes.head')
</head>
<style>
    .bg-login-overlay,.bg-login{
        background: #4e5087 !important
    }
    .badge-primary {
    color: #fff;
    border: 0px !important;
    background: #4e5087 !important
}
</style>

<body style="background-image: url(<?php echo env('APP_URL') ?>images/login_banner.png) !important;background: #463c56;;background-blend-mode: overlay;">

    <div class="home-btn d-none d-sm-block">

        <a href="/" class="text-white"><i class="fas fa-home h2 text-white"></i></a>

    </div>

    <div class="account-pages my-5 pt-sm-5">

        <div class="container">

            <div class="row justify-content-center">

                <div class="col-md-8 col-lg-6 col-xl-5">

                    <div class="card overflow-hidden">

                        <div class="bg-login text-center" style="background-image: url({{env('APP_URL')}}images/login_banner.png) !important;">

                            <div class="bg-login-overlay" ></div>

                            <div class="position-relative">

                                <h5 class="text-white font-size-20">Welcome !</h5>

                                <p class="text-white-50 mb-0">Sign in to continue to <strong><?php echo env('APP_NAME');?></strong></p>

                                <a href="/" class="logo logo-admin mt-4">

                                    <img src="<?php echo env('APP_LOGO_SM');?>" alt="" height="30">

                                </a>

                            </div>

                        </div>

                        <div class="card-body pt-5">

                            <div class="p-2">

                                <form method="POST" action="{{ route('login') }}">

                                    @csrf

            

                                    <div class="form-group row">

                                    

            

                                        <div class="col-md-12">

                                            <label for="username">{{ __('E-Mail Address') }}</label>

                                            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>

            

                                            @error('email')

                                                <span class="invalid-feedback" role="alert">

                                                    <strong>{{ $message }}</strong>

                                                </span>

                                            @enderror

                                        </div>

                                    </div>

            

                                    <div class="form-group row">

                                        <div class="col-md-12">

                                            <label for="userpassword">{{ __('Password') }}</label>

                                            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password">

            

                                            @error('password')

                                                <span class="invalid-feedback" role="alert">

                                                    <strong>{{ $message }}</strong>

                                                </span>

                                            @enderror

                                        </div>

                                    </div>

            

                                    <div class="custom-control custom-checkbox">

                                        <input type="checkbox" class="custom-control-input" name="remember" id="customControlInline" {{ old('remember') ? 'checked' : '' }}>

                                        <label class="custom-control-label" for="customControlInline"> {{ __('Remember Me') }}</label>

                                    </div>

            

                                    <div class="mt-3">

                                            <button type="submit" class="btn badge-primary col-md-12">

                                                {{ __('Login') }}

                                            </button>

                                    </div>

            

                                    @if (Route::has('password.request'))

                                    <div class="mt-4 text-center">

                                      

                                        <a  class="text-muted" href="{{ route('password.request') }}"><i class="mdi mdi-lock mr-1"></i> Forgot your password?</a>

                             

                                    </div>

                                       

                                    @endif

                                        </div>

                                    </div>

                                </form>

                            </div>



                        </div>

                    </div>

                    <div class="mt-5 text-center text-white">

                        {{-- <p>Don't have an account ? <a href="pages-register.html" class="font-weight-medium text-primary"> Signup now </a> </p> --}}

                        <p>© {{date('Y')}} <strong><?php echo env('APP_NAME'); ?></strong></p>

                    </div>



                </div>

            </div>

        </div>

    </div>



    {{-- Scripts Links --}}

    @include('includes.scripts')



</body>



</html>