@extends('layouts.app') @section('content')
    <div class="page-content">



        @if (session('success'))
            <div class="alert alert alert-primary">

                {{ session('success') }}

            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger">

                {{ session('error') }}

            </div>
        @endif
        
        
        @if (Auth::user()->role == 1)
            <a href="/blog-create">

                <button class="btn p-2  badge-primary border-0" title="create">



                    <i style="margin-right:05px;"><strong>Add Blogs</strong></i>

                </button>

            </a>
        @endif


        <div class="card p-3 mt-3 ">

            <div class="row">

                <div class="col-sm-12">

                    <table id="datatable-buttons"
                        class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed"
                        style="border-collapse: collapse; border-spacing: 0px; width: 100%;" role="grid"
                        aria-describedby="datatable-buttons_info">

                        <thead>

                            <tr role="row">

                                <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons" rowspan="1"
                                    colspan="1" style="width: 108px;" aria-sort="ascending"
                                    aria-label="Name: activate to sort column descending">Serial No</th>

                                <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons" rowspan="1"
                                    colspan="1" style="width: 108px;" aria-sort="ascending"
                                    aria-label="Name: activate to sort column descending">Publisher Image</th>

                                <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons" rowspan="1"
                                    colspan="1" style="width: 108px;" aria-sort="ascending"
                                    aria-label="Name: activate to sort column descending">Blog Name</th>

                                <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons" rowspan="1"
                                    colspan="1" style="width: 108px;" aria-sort="ascending"
                                    aria-label="Name: activate to sort column descending">Blog Image</th>

                                <th class="sorting" tabindex="0" aria-controls="datatable-buttons" rowspan="1"
                                    colspan="1" style="width: 172px;"
                                    aria-label="Position: activate to sort column ascending">Posted By</th>

                                <th class="sorting" tabindex="0" aria-controls="datatable-buttons" rowspan="1"
                                    colspan="1" style="width: 76px;"
                                    aria-label="Office: activate to sort column ascending">Actions</th>

                        </thead>

                        <tbody>

                            @foreach ($data as $item)
                                <tr role="row" class="odd">

                                    <td tabindex="0" class="sorting_1">{{ $loop->iteration }}</td>

                                    <td tabindex="0" class="sorting_1">

                                        <a class="image-popup-no-margins" href="<?php echo env('SYMMLINK') . 'blog_images/' . $item->profile; ?>">

                                            <img class="rounded-circle header-profile-user" style="object-fit: cover"
                                                alt="" src="<?php echo env('SYMMLINK') . 'blog_images/' . $item->profile; ?>" width="75">

                                        </a>

                                    </td>

                                    <td tabindex="0" class="sorting_1">{{ $item->blog_name }}</td>

                                    <td tabindex="0" class="sorting_1">

                                        <a class="image-popup-no-margins" href="<?php echo env('SYMMLINK') . 'blog_images/' . $item->blog_cover; ?>">

                                            <img class="img-fluid rounded" alt="" src="<?php echo env('SYMMLINK') . 'blog_images/' . $item->blog_cover; ?>"
                                                width="75">

                                        </a>

                                    </td>

                                    <td>{{ $item->posted_by }}</td>



                                    <td>

                                        <div class="btn-group" role="group" aria-label="Basic example">

                                            <a href="/blogs/{{ $item->id }}"><span
                                                    class="badge p-2 badge-primary  border-0 mr-2"><i class="bx bx-edit-alt"
                                                        style="font-size: medium"></i></span></a>
                                            @if (Auth::user()->role == 1)
                                                <a href="/delete-blog/{{ $item->id }}"><span
                                                        class="badge p-2 badge-danger  border-0 mr-2"><i
                                                            class="bx bxs-trash" style="font-size: medium"></i></span></a>
                                            @endif
                                        </div>

                                    </td>





                                </tr>
                            @endforeach

                        </tbody>

                    </table>

                </div>

            </div>

        </div>

    </div>
@endsection
