@extends('layouts.app') 
@section('content')
<style>
   .top-left {
   position: absolute;
   top: 0px;
   left: 12px;
   }
   .top-left-text {
   position: absolute;
   top: 9px;
   left: 21px;
   }
   h5{
   font-size: inherit;
   font-weight: bold;
   }
   .upload-btn-wrapper {
   position: relative;
   overflow: hidden;
   display: inline-block;
   }
   .upload-btn-wrapper input[type=file] {
   font-size: 100px;
   position: absolute;
   left: 0;
   top: 0;
   opacity: 0;
   }
   .profile-pic {
   width: 200px;
   max-height: 200px;
   display: inline-block;
   }
   .file-upload {
   display: none;
   }
   .circle {
   border-radius: 100% !important;
   overflow: hidden;
   width: 128px;
   height: 128px;
   border: 2px solid rgba(255, 255, 255, 0.2);
   position: absolute;
   top: 30px;
   }
   img {
   max-width: 100%;
   height: auto;
   }
   .p-image {
   position: absolute;
   top: 124px;
   right: 68px;
   transition: all .3s cubic-bezier(.175, .885, .32, 1.275);
   color: #0000009c;
   }
   .p-image:hover {
   transition: all .3s cubic-bezier(.175, .885, .32, 1.275);
   }
   .upload-button {
   font-size: 1.7em !important;
   }
   .upload-button:hover {
   transition: all .3s cubic-bezier(.175, .885, .32, 1.275);
   color: #000;
   }
</style>
@if (session('success'))
<div class="alert alert alert-primary">
   {{session('success')}}
</div>
@endif @if (session('error'))
<div class="alert alert-danger">
   {{session('error')}}
</div>
@endif
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
   $(document).ready(function(){
   
       $('#checkbox').on('change', function(){
   
           $('#old_pass').attr('type',$('#checkbox').prop('checked')==true?"text":"password"); 
   
       });
   
       $('#checkbox1').on('change', function(){
   
           $('#new_pass').attr('type',$('#checkbox1').prop('checked')==true?"text":"password"); 
   
       });
   
   });
   
</script>
<div class="container" >
   <form method="post" action="/change-user-settings/{{Auth::user()->id}}" enctype="multipart/form-data">
      @csrf
      <div class="row">
         <div class="col-md-2 col-12">
            <div class="pt-5">
               <div class="row">
                  <div class="small-12 medium-2 large-2 columns">
                     <div class="img">
                        <img class="profile-pic rounded-circle" style="padding: 10px;border: 3px dashed #2f4395;height: 7.5rem !important;width: 7.5rem;!important" src="{{env('SYMMLINK')}}user-profiles/{{Auth::user()->profile}}">
                     </div>
                     <div class="p-image">
                        <i class="fa fa-camera upload-button" style="color: #2f4395;"></i>
                        <input class="file-upload" type="file" name="files" accept="image/*">
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="pt-5" style="margin-bottom:7rem!important">
         </div>
      </div>
      <div class="form-group mt-3">
         {{-- <label>Name </label> --}}
         <input type="text" name="name" placeholder="Name" value="{{Auth::user()->name}}" class="form-control col-md-12 " id="">
      </div>
      <div class="form-group mt-3">
         {{-- <label>Phone Number </label> --}}
         <input type="number" name="phone" placeholder="Phone No" value="{{Auth::user()->phone}}" class="form-control" id="">
      </div>
      <div class="form-group mt-3">
         {{-- <label>E-Mail Address </label> --}}
         <input type="email" name="email" placeholder="Email Address" value="{{Auth::user()->email}}" class="form-control" id="">
      </div>
      <a href="#" data-toggle="modal" data-target=".bs-example-modal-center"><label for="">Change Password</label></a>
      <div class="mt-3">
         <input type="submit" value="Update Settings" class="btn btn-outline-primary">
      </div>
   </form>
</div>
<div class="col-sm-6 col-md-4 col-xl-3">
   <div class="modal fade bs-example-modal-center" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered">
         <div class="modal-content">
            <div class="modal-header">
               <h5 class="modal-title mt-0">Change Password</h5>
               <button type="button" class="close" data-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">×</span>
               </button>
            </div>
            <div class="modal-body">
               <form action="/change-password/{{Auth::user()->id}}" id="pass_change" method="POST" enctype="multipart/form-data">
                  @csrf
                  <div class="form-group mt-3">
                     <div class="input-group" id="show_hide_password">
                         <input class="form-control" placeholder="Old Password" type="password" name="new_pass" required>
                             <div class="input-group-addon bg-light p-2">
                             <a href=""><i class="fa fa-eye-slash mt-1" aria-hidden="true"></i></a>
                         </div>
                     </div>
                 </div>

                 <div class="form-group mt-3">
                 <div class="input-group" id="show_hide_password_b">
                      <input class="form-control" placeholder="New Password" type="password" name="old_pass" required>
                          <div class="input-group-addon bg-light p-2">
                          <a href=""><i class="fa fa-eye-slash mt-1" aria-hidden="true"></i></a>
                      </div>
                  </div>
              </div>
                  
               
                  <div class="msg"></div>
                  <div class="mt-3">
                     <input type="submit" id="pass_btn" value="Change Password" class="btn badge-primary">
                  </div>
               </form>
            </div>
         </div>
         <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
   </div>
   <!-- /.modal -->
</div>
<script>
   $(document).ready(function() {
      
      $("#show_hide_password a").on('click', function(event) {
        event.preventDefault();
        if($('#show_hide_password input').attr("type") == "text"){
            $('#show_hide_password input').attr('type', 'password');
            $('#show_hide_password i').addClass( "fa-eye-slash" );
            $('#show_hide_password i').removeClass( "fa-eye" );
        }else if($('#show_hide_password input').attr("type") == "password"){
            $('#show_hide_password input').attr('type', 'text');
            $('#show_hide_password i').removeClass( "fa-eye-slash" );
            $('#show_hide_password i').addClass( "fa-eye" );
        }

        
    });
    $("#show_hide_password_b a").on('click', function(event) {
        event.preventDefault();
        if($('#show_hide_password_b input').attr("type") == "text"){
            $('#show_hide_password_b input').attr('type', 'password');
            $('#show_hide_password_b i').addClass( "fa-eye-slash" );
            $('#show_hide_password_b i').removeClass( "fa-eye" );
        }else if($('#show_hide_password_b input').attr("type") == "password"){
            $('#show_hide_password_b input').attr('type', 'text');
            $('#show_hide_password_b i').removeClass( "fa-eye-slash" );
            $('#show_hide_password_b i').addClass( "fa-eye" );
        }
      });
   var readURL = function(input) {
      if (input.files && input.files[0]) {
         var reader = new FileReader();
   
         reader.onload = function (e) {
               $('.profile-pic').attr('src', e.target.result);
         }
   
         reader.readAsDataURL(input.files[0]);
      }
   }
   
   
   $(".file-upload").on('change', function(){
    readURL(this);
   });
   
   $(".upload-button").on('click', function() {
      $(".file-upload").click();
   });
   });

   
</script>
@endsection<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
