@extends('layouts.app') @section('content')

<div class="page-content"> 
    @if (session('success'))
	<div class="alert alert alert-primary"> {{session('success')}} </div> 
    @endif 
    @if (session('error'))
	<div class="alert alert-danger"> {{session('error')}} </div> 
    @endif
    <div class="row mt-3 ">
        <div class="col-md-6">
            <div class="card p-4" style="height: 253px;">
                <form action="/block-client-ip" method="post"> 
                    @csrf
                    <div class="form-data">
                        <h3 class="pb-4">Blocking Client IP's </h3>
                        <input type="text" name="client_ip" class="form-control" placeholder="Client IP Address" id="">
                        <button type="submit" class="btn mt-3 badge-primary">Block Client IP</button>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card p-4">
                <form action="/block-client-email" method="post"> 
                    @csrf
                    <div class="form-data ">
                        <h3 class="pb-4">Blocking Client  </h3>
                        <input type="text" name="client_ip" class="form-control" placeholder="Client Name/Email or IP" id="">

                        <select name="db_column" class="form-control mt-3">
                            <option value="name">Name</option>
                            <option value="email">Email Address</option>
                            <option value="phone_number">Phone Number</option>
                        </select>
                        <button type="submit" class="btn mt-3 badge-primary">Block Client Email</button>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card p-4">
                <table id="datatable-buttons-custom" class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed" style="border-collapse: collapse; border-spacing: 0px; width: 100%;" role="grid" aria-describedby="datatable-buttons_info">
                    <thead>
                        <tr role="row">
                            <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons-custom" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending">Serial No</th>
                            <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons-custom" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending">Blocked IP Addresses</th>
                            <th class="sorting" tabindex="0" aria-controls="datatable-buttons-custom" rowspan="1" colspan="1" style="width: 76px;" aria-label="Office: activate to sort column ascending">Actions</th>
                    </thead>
                    <tbody>
                        <?php $blocked_ips = DB::table('ip_blocking')->where('is_del', 1)->get(); ?>
                       

                        @if ($blocked_ips->count() > 0)
                            @foreach ($blocked_ips as $blocked_ip)
                            <tr role="row" class="odd">
                                <td tabindex="0" class="sorting_1">{{$loop->iteration}}</td>
                                <td tabindex="0" class="sorting_1">{{$blocked_ip->ip}}</td> 
                                <td>
                                    <div class="btn-group" role="group" aria-label="Basic example">    
                                        <a href="/unlock-client-ip/{{$blocked_ip->id}}">
                                            <span class="badge p-2 badge-danger  border-0 mr-2">
                                                <i class="bx bxs-lock-open" style="font-size: medium"></i>
                                            </span>
                                        </a> 
                                    </div>
                                </td>
                                
                            </tr>
                            @endforeach
                        @endif


                        
                    </tbody>
                </table>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card p-4">
                <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed" style="border-collapse: collapse; border-spacing: 0px; width: 100%;" role="grid" aria-describedby="datatable-buttons_info">
                    <thead>
                        <tr role="row">
                            <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending">Serial No</th>
                            <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending">Names</th>
                            <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending">Emails</th>
                            <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending">Numbers</th>
                            <th class="sorting" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" style="width: 76px;" aria-label="Office: activate to sort column ascending">Actions</th>
                    </thead>
                    <tbody>
                        
                        <?php $blocked_emails = DB::table('email_blocking')->where('is_del', 1)->get(); ?>



                        @if ($blocked_emails->count() > 0)
                            @foreach ($blocked_emails as $blocked_email)
                            <?php 
                                $name = ($blocked_email->name == "") ? "-" : $blocked_email->name ;
                                $email = ($blocked_email->email == "") ? "-" : $blocked_email->email ;
                                $phone = ($blocked_email->phone == "") ? "-" : $blocked_email->phone ;
                            ?>
                            <tr role="row" class="odd">
                                <td tabindex="0" class="sorting_1">{{$loop->iteration}}</td>
                                <td tabindex="0" class="sorting_1">{{$name}}</td>
                                <td tabindex="0" class="sorting_1">{{$email}}</td>
                                <td tabindex="0" class="sorting_1">{{$phone}}</td>
                                <td>
                                    <div class="btn-group" role="group" aria-label="Basic example">    
                                        <a href="/unlock-client-email/{{$blocked_email->id}}">
                                            <span class="badge p-2 badge-danger  border-0 mr-2">
                                                <i class="bx bxs-lock-open" style="font-size: medium"></i>
                                            </span>
                                        </a> 
                                    </div>
                                </td>
                                
                            </tr>
                            @endforeach
                        @endif
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>

	
</div> 
@endsection