<!doctype html>
<html lang="en">
   <head>
      <meta charset="utf-8" />
      <title>Dashboard | {{ env('APP_NAME') }}</title>
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
      <meta content="Themesbrand" name="author" />
      <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
      {{-- head Links --}}
      @include('includes.head')
      <!-- CSRF Token -->
      <meta name="csrf-token" content="{{ csrf_token() }}">
      <style>
         .boxes{
         padding-bottom: 20px;
         }
         ::-webkit-scrollbar {
         -webkit-appearance: none;
         }
         .card {
         width: 99%; 
         }
         .avatar-md {
         padding: 7%;
         }
         ::-webkit-scrollbar {
         width: 5px;
         background: transparent;
         }
         ::-webkit-scrollbar-thumb {
         background: transparent;
         height: 140px;
         border-radius: 4px;
         }
         body[data-layout=detached] #layout-wrapper::before {
         background: #5c5b8d !important;
         }
         .bx {
         font-family: boxicons !important;
         font-weight: 100;
         font-style: normal;
         font-variant: normal;
         line-height: 1;
         display: inline-block;
         text-transform: none;
         speak: none;
         -webkit-font-smoothing: antialiased;
         -moz-osx-font-smoothing: grayscale;
         font-size: initial;
         }
         body {
         background: #f3f5fa;
         }
         .noti-icon .badge {
         position: absolute;
         left: 26px;
         top: 12px;
         }
         .bg-primary {
         background-color: linear-gradient(45deg, #4e5087, #585a879c) !important;
         }
         .badge-primary {
         border: 0px !important;
         color: #fff;
         background: linear-gradient(45deg, #4e5087, #585a879c) !important;
         }
         .bg-soft-primary {
         background: linear-gradient(90deg, #898bad9c 0%, #898bad9c 90%) !important;
         }
         .btn-primary {
         color: #fff;
         background: linear-gradient(90deg, rgba(255, 120, 16, 1) 0%, rgba(255, 94, 44, 1) 90%) !important;
         border-color: linear-gradient(90deg, rgba(255, 120, 16, 1) 0%, rgba(255, 94, 44, 1) 90%) !important;
         }
         .badge-danger {
         color: #fff;
         background: linear-gradient(90deg, #ff7810 0%, #ff5e2c 90%) !important;
         }
         .btn-primary:hover {
         color: #fff;
         background: linear-gradient(90deg, rgba(255, 120, 16, 1) 0%, rgba(255, 94, 44, 1) 90%) !important;
         border-color: linear-gradient(90deg, rgba(255, 120, 16, 1) 0%, rgba(255, 94, 44, 1) 90%) !important;
         }
         .badge-soft-primary {
         color: #ffffff;
         background: linear-gradient(90deg, #585a879c 0%, #585a879c 90%) !important;
         }
         small {
         font-size: 90%;
         line-height: initial;
         }
         .text-primary {
         color: #4e5087 !important;
         }
         img.rocket-img {
         position: absolute;
         max-width: 317px;
         }
         @media(max-width: 1645px){
         .vertical-menu.mm-active {
         display: none;
         }
         }
         @media (max-width: 1400px){ 
         body[data-topbar=colored] #page-topbar {
         background: linear-gradient(to right,#494874,#333258);
         }
         .popupbox {
         -webkit-box-flex: 0;
         -ms-flex: 50%;
         flex: 0 0 30%;
         max-width: 50%;
         }
         .info-box{
         -ms-flex: 100%;
         flex: 100%;
         max-width: 100%;
         }
         .boxes {
         max-width: 100%;
         max-height: 100%;
         }
         .boxlast{
         max-height: 100%;
         max-width: 100%;
         }
         .rocket-img{
         position: absolute;
         max-width: 350px;
         }
         .profile-section img {
         width: 100%;
         object-fit: cover;
         }
         .info-section {
         max-width: 60%;
         font-size: 100%;
         margin: 0px;
         }
         .avatar-md {
         height: 50px;
         max-width: 50px;
         }
         }
         @media(max-width: 992px){
         .profile-section {
         max-width: 40%;
         }
         .info-section {
         max-width: 60%;
         }
         .p-2 {
         padding: 0px !important;
         }
         .profile-section img {
         width: 100%;
         object-fit: cover;
         }
         .avatar-md {
         height: 50px;
         max-width: 50px;
         }
         .info-section {
         max-width: 60%;
         font-size: 100%;
         margin: 0px;
         }
         .box-heading{
         margin-top:19px;
         }
         }
         @media (max-width: 900px){   
         .popupbox {
         flex: 0 0 100%;
         max-width: 100%;
         }
         .rocket-img{
         position: absolute;
         max-width: 350px;
         }
         .boxes {
         max-width: 100%;
         max-height: 100%;
         }
         .boxlast{
         max-height: 100%;
         max-width: 100%;
         }
         .profile-section img {
         width: 100%;
         object-fit: cover;
         }
         .info-section {
         max-width: 60%;
         font-size: 66%;
         margin: 0px;
         }
         .box-heading{
         margin-top:22px;
         }
         }
         @media  (min-width: 550px) and (max-width: 899px)  {
         .popupbox {
         flex: 0 0 45%;
         max-width: 100%;
         }
         }
      </style>
   </head>
   <body data-layout="detached" data-topbar="colored">
      @guest
      @if (Route::has('login'))
      <li class="nav-item">
         <a class="nav-link" href="{{ route('login') }}">{{ __('Login') }}</a>
      </li>
      @endif
      @if (Route::has('register'))
      <li class="nav-item">
         <a class="nav-link" href="{{ route('register') }}">{{ __('Register') }}</a>
      </li>
      @endif
      @else
      <div class="container-fluid">
      <!-- Begin page -->
      <div id="layout-wrapper">
         <header id="page-topbar">
            <div class="navbar-header">
               <div class="container-fluid">
                  <div class="float-right">
                     <div class="dropdown d-none d-lg-inline-block ml-1">
                        <button type="button" class="btn header-item noti-icon waves-effect"
                           data-toggle="fullscreen">
                        <i class="mdi mdi-fullscreen"></i>
                        </button>
                     </div>
                     <div class="dropdown d-inline-block">
                        <button type="button" class="btn header-item waves-effect"
                           id="page-header-user-dropdown" data-toggle="dropdown" aria-haspopup="true"
                           aria-expanded="false">
                        <img class="rounded-circle header-profile-user" src="{{ env('SYMMLINK') }}user-profiles/{{ Auth::user()->profile }}" alt="Header Avatar">
                        <span class="d-none d-xl-inline-block ml-1"> {{ Auth::user()->name }}</span>
                        <i class="mdi mdi-chevron-down d-none d-xl-inline-block"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-right">
                           <!-- item-->
                           <a class="dropdown-item" href="/user-profile"><i
                              class="bx bx-user font-size-16 align-middle mr-1"></i> Profile</a>
                           <div class="dropdown-divider"></div>
                           <a class="dropdown-item text-danger" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                           <i class="bx bx-power-off font-size-16 align-middle mr-1 text-danger"></i> Logout</a>
                           <form id="logout-form" action="{{ route('logout') }} " method="POST" class="d-none">
                              @csrf
                           </form>
                        </div>
                     </div>
                  </div>
                  <div>
                     <!-- LOGO -->
                     <div class="navbar-brand-box">
                        <a href="index.html" class="logo logo-dark">
                        <span class="logo-sm">
                        <img src="../images/logo-sm.png" alt="" height="20">
                        </span>
                        <span class="logo-lg">
                        <img src="../images/logo-dark.png" alt="" height="17">
                        </span>
                        </a>
                        <a href="/" class="logo logo-light">
                        <span class="logo-sm">
                        <img src="../images/logo-sm.png" alt="" height="20">
                        </span>
                        <span class="logo-lg">
                        <img src="<?php echo env('APP_URL') . '' . env('APP_LOGO'); ?>" class="img-fluid" alt=""
                           style="height: initial;">
                        </span>
                        </a>
                     </div>
                     <button type="button"
                        class="btn btn-sm px-3 font-size-16 header-item toggle-btn waves-effect"
                        id="vertical-menu-btn">
                     <i class="fa fa-fw fa-bars"></i>
                     </button>
                     <!-- App Search-->
                  </div>
               </div>
            </div>
         </header>
         <!-- ========== Left Sidebar Start ========== -->
         <div class="vertical-menu">
            <div class="h-100">
               <div class="user-wid text-center py-4">
                  <div class="user-img">
                     <img src="{{ env('SYMMLINK') }}user-profiles/{{ Auth::user()->profile }}"
                        alt="{{ Auth::user()->name }}" style="object-fit: cover"
                        class="avatar-md mx-auto rounded-circle">
                  </div>
                  <div class="mt-3">
                     <a href="#"
                        class="text-dark font-weight-medium font-size-16">{{ Auth::user()->name }}</a>
                     <?php
                        if (Auth::user()->role == 1) {
                        
                            $designation = 'Admin';
                        
                        } elseif (Auth::user()->role == 2) {
                        
                            $designation = 'Employee';
                        
                        } elseif (Auth::user()->role == 3) {
                        
                            $designation = 'Client';
                        
                        }elseif (Auth::user()->role == 4) {
                        
                            $designation = 'Marketing Agent';
                        
                        } else {
                        
                            $designation = '';
                        
                        }
                        
                        
                        
                        ?>
                     <p class="text-body mt-1 mb-0 font-size-13">{{ $designation }}</p>
                  </div>
               </div>
               <!--- Sidemenu -->
               @if (Auth::user()->role == 4)
               <div id="sidebar-menu">
                  <ul class="metismenu list-unstyled" id="side-menu">
                     <li>
                        <a href="/" class="waves-effect">
                        <i class="mdi mdi-airplay"></i>
                        <span>Dashboard</span>
                        </a>
                     </li>
                     <li class="">
                        <a href="/pages" class=" waves-effect">
                        <img src="../images/custom_icons/page.png" height="20" width="20" alt="">
                        <span>Pages</span>
                        </a>
                     </li>

                     <li>
                        <a href="/blogs" class=" waves-effect">
                        <img src="../images/custom_icons/blog.png" height="20" width="20"
                        alt="">
                        <span>Blogs</span>
                        </a>
                    </li>
                  </ul>
               </div>
               @endif
               @if (Auth::user()->role == 3)
                <div id="sidebar-menu">
                    <!-- Left Menu Start -->
                    <ul class="metismenu list-unstyled" id="side-menu">
                        <li style="display: none">
                            <a href="/user-profile" class="waves-effect">
                            <span><img
                            src="{{ env('SYMMLINK') }}user-profiles/{{ Auth::user()->profile }}"
                            alt="Adil Sahito" width="25px" height="25px"
                            style="object-fit: cover" class="rounded-circle"></span>
                            <span>Your Profile</span>
                            </a>
                        </li>
                        <li class="menu-title">Menu</li>
                        <li>
                            <a href="/" class="waves-effect">
                            <i class="mdi mdi-airplay"></i>
                            <span>Dashboard</span>
                            </a>
                        </li>
                        <li>
                            <a href="/projects" class="waves-effect">
                            <i class="mdi mdi-airplay"></i>
                            <span>Projects</span>
                            </a>
                        </li>
                        </li>
                    </ul>
                </div>
               @endif

               @if (Auth::user()->role == 2)
                <div id="sidebar-menu">
                    <!-- Left Menu Start -->
                    <ul class="metismenu list-unstyled" id="side-menu">
                        <li style="display: none">
                            <a href="/user-profile" class="waves-effect">
                            <span><img
                            src="{{ env('SYMMLINK') }}user-profiles/{{ Auth::user()->profile }}"
                            alt="Adil Sahito" width="25px" height="25px"
                            style="object-fit: cover" class="rounded-circle"></span>
                            <span>Your Profile</span>
                            </a>
                        </li>
                        <li class="menu-title">Menu</li>
                        <li>
                            <a href="/" class="waves-effect">
                            <i class="mdi mdi-airplay"></i>
                            <span>Dashboard</span>
                            </a>
                        </li>
                        <li>
                            <a href="/client-projects" class="waves-effect">
                            <i class="mdi mdi-airplay"></i>
                            <span>Client Projects</span>
                            </a>
                        </li>
                        </li>
                    </ul>
                </div>
               @endif

               @if (Auth::user()->role == 1)
                <div id="sidebar-menu">
                    <!-- Left Menu Start -->
                    <ul class="metismenu list-unstyled" id="side-menu">
                        <li style="display: none">
                            <a href="/user-profile" class="waves-effect">
                            <span><img
                            src="{{ env('SYMMLINK') }}user-profiles/{{ Auth::user()->profile }}"
                            alt="Adil Sahito" width="25px" height="25px"
                            style="object-fit: cover" class="rounded-circle"></span>
                            <span>Your Profile</span>
                            </a>
                        </li>
                        <li class="menu-title">Menu</li>
                        <li>
                            <a href="/" class="waves-effect">
                            <i class="mdi mdi-airplay"></i>
                            <span>Dashboard</span>
                            </a>
                        </li>
                        <li class="menu-title">CRM features</li>
                        <li>
                            <a href="/success-payments" class=" waves-effect">
                            <img src="../images/custom_icons/lead-generation.png" height="20"
                            width="20" alt="">
                            <span>Payments</span>
                            </a>
                        </li>
                        <li>
                            <a href="/users">
                            <img src="../images/custom_icons/user.png" height="20" width="20"
                            alt="">
                            <span>Users</span>
                            </a>
                        </li>
                        <li>
                            <a href="/blogs" class=" waves-effect">
                            <img src="../images/custom_icons/blog.png" height="20" width="20"
                            alt="">
                            <span>Blogs</span>
                            </a>
                        </li>
                        <li>
                            <a href="/happy-clients" class="waves-effect">
                            <img src="../images/custom_icons/happy-face.png" height="20"
                            width="20" alt="">
                            <span>Happy Clients</span>
                            </a>
                        </li>
                        <li>
                            <a href="javascript: void(0);" class="has-arrow waves-effect">
                            <img src="../images/custom_icons/subscription.png" height="20"
                            width="20" alt="">
                            <span>Packages</span>
                            </a>
                            <ul class="sub-menu" aria-expanded="false">
                            <li><a href="/packages">Packages </a></li>
                            <li><a href="/package-categories">Package Categories</a></li>
                            </ul>
                        </li>
                        <li>
                            <a href="javascript: void(0);" class="has-arrow waves-effect">
                            <img src="../images/custom_icons/portfolio.png" height="20" width="20"
                            alt="">
                            <span>Portfolio</span>
                            </a>
                            <ul class="sub-menu" aria-expanded="false">
                            <li><a href="/portfolio">Portfolio </a></li>
                            <li><a href="/portfolio-categories">Portfolio Categories</a></li>
                            </ul>
                        </li>
                        <li>
                            <a href="/brand-info" class=" waves-effect">
                            <img src="../images/custom_icons/brand-image.png" height="20"
                            width="20" alt="">
                            <span>Brand Info</span>
                            </a>
                        </li>
                        <li>
                            <a href="/services" class=" waves-effect">
                            <img src="../images/custom_icons/services.png" height="20" width="20"
                            alt="">
                            <span>Services</span>
                            </a>
                        </li>
                        <li>
                            <a href="/testimonials" class=" waves-effect">
                            <img src="../images/custom_icons/services.png" height="20" width="20"
                            alt="">
                            <span>Testimonials</span>
                            </a>
                        </li>
                        <li class="">
                            <a href="/contact-us" class=" waves-effect">
                            <img src="../images/custom_icons/contact.png" height="20" width="20"
                            alt="">
                            <span>Queries</span>
                            </a>
                        </li>
                        <li class="">
                            <a href="/pages" class=" waves-effect">
                            <img src="../images/custom_icons/page.png" height="20" width="20"
                            alt="">
                            <span>Pages</span>
                            </a>
                        </li>
                        <li class="">
                            <a href="/block-users" class=" waves-effect">
                            <img src="../images/custom_icons/page.png" height="20" width="20"
                            alt="">
                            <span>Block Users</span>
                            </a>
                        </li>
                    </ul>
                </div>
               @endif
               <!-- Sidebar -->
            </div>
         </div>
         <!-- Left Sidebar End -->
         <!-- ============================================================== -->
         <!-- Start right Content here -->
         <!-- ============================================================== -->
         <div class="main-content">
            <div class="page-content">
               <!-- start page title -->
               <div class="row">
                  <div class="col-12">
                     <div class="page-title-box d-flex align-items-center justify-content-between">
                        <h4 class="page-title mb-0 font-size-18">
                           <?php
                              if (Request::segment(1) == null) {
                              
                                  echo 'Dashboard';
                              
                              } else {
                              
                                  echo str_replace('-', ' ', Request::segment(1));
                              
                              }
                              
                              ?>
                        </h4>
                        <div class="page-title-right">
                           <ol class="breadcrumb m-0">
                              <li class="breadcrumb-item text-white active">Welcome to <strong><a
                                 href="/"
                                 class="text-white">{{ env('APP_NAME') }}</a></strong></li>
                           </ol>
                        </div>
                     </div>
                  </div>
               </div>
               {{-- Page Content Starts --}}
               <div class="container-fluid ">
                  @yield('content')
               </div>
               <!-- End Page-content -->
               <footer class="footer">
                  <div class="container-fluid">
                     <div class="row">
                        <div class="col-sm-6">
                           <script>
                              document.write(new Date().getFullYear())
                              
                           </script> © {{ env('APP_NAME') }}.
                        </div>
                        <div class="col-sm-6">
                           <div class="text-sm-right d-none d-sm-block">
                              Design & Develop by MSB Solutions
                           </div>
                        </div>
                     </div>
                  </div>
               </footer>
            </div>
            <!-- end main content-->
         </div>
         <!-- END layout-wrapper -->
      </div>
      <!-- end container-fluid -->
      <!-- Right Sidebar -->
      <div class="right-bar">
         <div data-simplebar class="h-100">
            <div class="rightbar-title px-3 py-4">
               <a href="javascript:void(0);" class="right-bar-toggle float-right">
               <i class="mdi mdi-close noti-icon"></i>
               </a>
               <h5 class="m-0">Settings</h5>
            </div>
            <!-- Settings -->
            <hr class="mt-0" />
            <h6 class="text-center mb-0">Choose Layouts</h6>
            <div class="p-4">
               <div class="mb-2">
                  <img src="../images/layouts/layout-1.jpg" class="img-fluid img-thumbnail" alt="">
               </div>
               <div class="custom-control custom-switch mb-3">
                  <input type="checkbox" class="custom-control-input theme-choice" id="light-mode-switch" checked />
                  <label class="custom-control-label" for="light-mode-switch">Light Mode</label>
               </div>
               <div class="mb-2">
                  <img src="../images/layouts/layout-2.jpg" class="img-fluid img-thumbnail" alt="">
               </div>
               <div class="custom-control custom-switch mb-3">
                  <input type="checkbox" class="custom-control-input theme-choice" id="dark-mode-switch" data-bsStyle="../../css/bootstrap-dark.min.css"
                     data-appStyle="../../css/app-dark.min.css" />
                  <label class="custom-control-label" for="dark-mode-switch">Dark Mode</label>
               </div>
               <div class="mb-2">
                  <img src="../images/layouts/layout-3.jpg" class="img-fluid img-thumbnail" alt="">
               </div>
               <div class="custom-control custom-switch mb-5">
                  <input type="checkbox" class="custom-control-input theme-choice" id="rtl-mode-switch" data-appStyle="css/app-rtl.min.css" />
                  <label class="custom-control-label" for="rtl-mode-switch">RTL Mode</label>
               </div>
            </div>
            @endguest
         </div>
         <!-- end slimscroll-menu-->
      </div>
      <div class="rightbar-overlay"></div>
      @include('includes.scripts')
      <script src="js/app.js"></script>
   </body>
</html>