@extends('layouts.app') @section('content')

<div class="page-content">

    @if (session('success'))
    <div class="alert alert alert-primary">
        {{session('success')}} 
    </div>
@endif

@if (session('error'))
    <div class="alert alert-danger">
        {{session('error')}} 
    </div>
@endif
 <div class="card p-3 mt-3 mb-3">
    <div class="row">
        <div class="col-sm-12">
            <h3>Pages Module</h3>
            <table
                id="datatable-buttons"
                class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed"
                style="border-collapse: collapse; border-spacing: 0px; width: 100%;"
                role="grid"
                aria-describedby="datatable-buttons_info"
            >
                <thead>
                    <tr role="row">

                        <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" style="width: 108px;" aria-sort="ascending" aria-label="Name: activate to sort column descending">Page Name</th>
                        <th class="sorting" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" style="width: 172px;" aria-label="Position: activate to sort column ascending">Brand Name</th>
                        <th class="sorting" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" style="width: 76px;" aria-label="Office: activate to sort column ascending">Page Type</th>
                        <th class="sorting" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" style="width: 76px;" aria-label="Office: activate to sort column ascending">Actions</th>

                </thead>

                <tbody>
                    
                    @foreach ($data as $item)
                    
                        @if ($item->brand_id == 1)
                            <?php $item->brand_id = "Sanjose Brand"?>
                       
                        @endif

                        @if ($item->paage_type == 1)
                            <?php $item->page_type = "Service Page"?>
                        @else
                            <?php $item->page_type = "Inner Page" ?>
                        @endif

                        <tr role="row" class="odd">
                            <td >{{$loop->iteration}}</td>
                            <td tabindex="0" class="sorting_1">{{$item->page_name}}</td>
                            <td>{{$item->brand_id}}</td>
                            <td>{{$item->page_type}}</td>
                            @if (Auth::user()->role == 1)
                            <td>
                                <div class="btn-group" role="group" aria-label="Basic example">
                                    <a href="/pages/{{$item->id}}"><span class="badge p-2 badge-primary  border-0 mr-2"><i class="bx bx-edit-alt" style="font-size: medium"></i></span></a>
                                    <a href="/leads/{{$item->id}}"><span  class="badge p-2 badge-danger  border-0"><i class="bx bxs-trash" style="font-size: medium"></i></i></span></a>
                                </div>
                            </td>
                            @endif
                            @if (Auth::user()->role == 2)
                                <td>
                                    <a href="/pages/{{$item->id}}"> <button class="btn btn-primary" title="view"><span class="dripicons-preview " style="font-size: medium"></span></button></a>
                                </td>
                            @endif
                            
                        </tr>    
                    @endforeach
                    
                  
                </tbody>
            </table>
        </div>
    </div>
</div>
</div>
@endsection
