@extends('layouts.app')

@section('content')
<style>
    .img-fluid {
        max-width: 100%;
        height: 50px;
    }
</style>

<div class="page-content">
    @php
        if (!Auth::user()->role == 1) {        
            $disabled = "disabled";
            $display = "display:none";
        }
    @endphp

    @if (session('success'))
        <div class="alert alert-primary">
            {{ session('success') }}
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif

    @foreach ($data as $item)
    <div class="card p-3 mt-3 mb-3">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <h3 class="mt-3 mb-3">{{ $item->blog_name }}</h3>
                    <form action="/update-blog/{{ $item->id }}" class="form" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="">Blog Name</label>
                                <input class="form-control" type="text" placeholder="Page Name" name="blog_name" value="{{ $item->blog_name }}" />
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="">Blog Image</label>
                                <input class="form-control" type="file" name="blog_image" value="{{ $item->blog_cover }}" />
                                <img src="../storage/blog_images/{{ $item->blog_cover }}" class="img-fluid" alt="">
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="">Profile Image</label>
                                <input class="form-control" type="file" name="profile" value="{{ $item->profile }}" />
                                <img src="../storage/blog_images/{{ $item->profile }}" class="img-fluid" alt="">
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="">Posted By</label>
                                <input class="form-control" type="text" placeholder="Posted By" value="{{ $item->posted_by }}" name="posted_by" />
                            </div>

                            <input type="hidden" name="brands" value="2">

                            <div class="col-md-4 mb-3">
                                <label for="">SEO Title</label>
                                <input class="form-control" type="text" placeholder="SEO Title" value="{{ $item->seo_title }}" name="seo_title" />
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="">SEO Description</label>
                                <input class="form-control" type="text" placeholder="SEO Description" value="{{ $item->seo_description }}" name="seo_description" />
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="">SEO Keywords</label>
                                <input class="form-control" type="text" placeholder="SEO Keywords" value="{{ $item->seo_keywords }}" name="seo_keywords" />
                            </div>

                            <div class="col-md-4 mb-3">
                                <label>Published Date</label>
                                <div class="input-group">
                                    <input type="text" name="published_date" class="form-control" value="{{ $item->published_date }}" placeholder="mm/dd/yyyy" data-provide="datepicker" data-date-autoclose="true">
                                    <div class="input-group-append">
                                        <span class="input-group-text"><i class="mdi mdi-calendar"></i></span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12 mb-3">
                                <label for="">Blog Text (Short)</label>
                                <textarea type="text" class="form-control" id="Intrests_text" name="blog_text" placeholder="Blog Text">{{ $item->blogcontent }}</textarea>
                                <script>
                                    CKEDITOR.replace('Intrests_text');
                                </script>
                            </div>
                            
                            
                            <div class="col-md-12 mb-3">
                                <label for="">Blog Text (Long)</label>
                                <textarea type="text" class="form-control" id="blog_html" name="blog_html" placeholder="Blog Text (Long)">{{ $item->blog_html }}</textarea>
                                <script>
                                    CKEDITOR.replace('blog_html');
                                </script>
                            </div>

                            <input type="hidden" name="brandId" value="1">

                            <div class="col-md-4 mb-3">
                                <input class="btn badge-primary" type="submit" value="Update" />
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    @endforeach
</div>
@endsection
