@extends('layouts.app') @section('content')

<div class="page-content">
   
    @if (session('success'))
    <div class="alert alert alert-primary">
        {{session('success')}} 
    </div>
@endif

@if (session('error'))
    <div class="alert alert-danger">
        {{session('error')}} 
    </div>
@endif
 <div class="card p-3 mb-3">
    <div class="row">
        <div class="col-sm-12">
     
            <table
                id="datatable-buttons"
                class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed"
                style="border-collapse: collapse; border-spacing: 0px; width: 100%;"
                role="grid"
                aria-describedby="datatable-buttons_info"
            >
                <thead>
                    <tr role="row">
                        <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" style="width: 10%;" aria-label="Serial No: activate to sort column descending" aria-sort="ascending">Serial No</th>
                        <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" style="width: 10%;" aria-label="Serial No: activate to sort column descending" aria-sort="ascending">Profile Image</th>
                        <th class="sorting_asc" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" style="width: 20%;" aria-sort="ascending" aria-label="Name: activate to sort column descending">Brand Name</th>
                        <th class="sorting" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" style="width: 20%;" aria-label="Position: activate to sort column ascending">Person Name</th>
                        {{-- <th class="sorting" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" style="width: 30%;" aria-label="Position: activate to sort column ascending">Remarks</th> --}}
                        <th class="sorting" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" style="width: 10%;" aria-label="Position: activate to sort column ascending">Address</th>
                        <th class="sorting" tabindex="0" aria-controls="datatable-buttons" rowspan="1" colspan="1" style="width: 10%;" aria-label="Office: activate to sort column ascending">Actions</th>
                </thead>

                <tbody>
                    @if (Auth::user()->role == 1)
                    <a href="/add-testimonials"  >
                        <button class="btn p-2  badge-primary border-0" title="create">
                            
                            <i style="margin-right:05px;"><strong>Add Testimonials</strong></i>
                        </button>
                    </a>
                    @endif
                    <?php $testimonials = DB::table('testimonials')->get(); ?>
                    @foreach ($testimonials as $testimonial)
                        <?php
                            $brands = DB::table('brands')->where('id',$testimonial->brand_id)->get();
                            $brandName = " ";
                            foreach ($brands as $brand) {
                                    $brandName = $brand->name;
                                
                            }
            
                        ?>
                      
                        <tr role="row" class="odd">
                            <td>{{$loop->iteration}}</td>
                            <td tabindex="0" class="sorting_1"><img src="<?php echo env('SYMMLINK').'testimonial_images/'.$testimonial->profile;?>" class="rounded-circle header-profile-user" alt=""></td>
                            <td tabindex="0" class="sorting_1">{{$brandName}}</td>
                            <td>{{$testimonial->person_name}}</td>
                            {{-- <td>{{$testimonial->remarks}}</td> --}}
                            <td>{{$testimonial->address}}</td>
                            @if (Auth::user()->role == 1)
                            <td>
                                <div class="btn-group" role="group" aria-label="Basic example">
                                    <a href="/edit-testimonials/{{$testimonial->id}}"><span class="badge p-2 badge-primary  border border-dark mr-2">  <i class="bx bx-edit-alt" style="font-size: medium"></i></span></a>
                                    <a href="/delete-testimonials/{{$testimonial->id}}"><span  class="badge p-2 badge-danger  border-0"><i class="bx bxs-trash" style="font-size: medium"></i></span></a>
                                </div>
                            </td>
                            @endif
                           
                        </tr>    
                    @endforeach
                    
                  
                </tbody>
            </table>
        </div>
    </div>
</div>
</div>
@endsection
