<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PagesController;
use App\Http\Controllers\LeadController;
use App\Http\Controllers\TestimonialsController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\ClientPagesController;



Route::get('/', function () {
    return view('auth.login');
});
Route::get('/home', function () {
    return view('home');
});

Route::get('/index', 'App\Http\Controllers\AuthenticationController@index');


Auth::routes();
 
Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/leads', 'App\Http\Controllers\PagesController@leads');
Route::get('/leads/{slug}', 'App\Http\Controllers\PagesController@leadsdelete');

Route::post('/get-lead/{clientId}',[LeadController::class, 'secure_pay']); 

//contact-us
Route::get('/contact-us','App\Http\Controllers\PagesController@contact');
Route::get('/contact-us/{slug}', 'App\Http\Controllers\PagesController@contactdelete');
Route::get('/view-contact-detail/{slug}', 'App\Http\Controllers\PagesController@view_contact');
Route::post('/get-aquote', 'App\Http\Controllers\ContactController@get_aquote');


//employee routes
Route::post('/assign-task', 'App\Http\Controllers\EmployeeController@assign_task');
Route::get('/client-projects', 'App\Http\Controllers\EmployeeController@client_projects');
Route::get('/happy-clients', 'App\Http\Controllers\EmployeeController@happy_clients');
Route::get('/cta-bar/{id}', 'App\Http\Controllers\EmployeeController@happy_clients_view');
Route::post('/edit-cta-bar', 'App\Http\Controllers\EmployeeController@happy_clients_edit');
Route::get('/delete-cta-bar/{id}', 'App\Http\Controllers\EmployeeController@happy_clients_delete');
Route::get('/view-project/{id}', 'App\Http\Controllers\EmployeeController@view_project');
Route::post('/save-description/{id}', 'App\Http\Controllers\EmployeeController@save_description');
Route::post('/save-attachments/{id}', 'App\Http\Controllers\EmployeeController@save_attachments');

Route::get('/payment-links', [EmployeeController::class, 'payment_links']);
Route::get('/billing-payment', [EmployeeController::class, 'billing_payment']);
Route::post('/get-billing-details',[EmployeeController::class, 'getbillinglead']); 
Route::get('/delete-payment-link/{id}', [EmployeeController::class, 'delete_payment_link']);



//pages
Route::get('/pages-create', 'App\Http\Controllers\PagesModule@pages');
Route::post('/create-page', 'App\Http\Controllers\PagesModule@pagesCreate');
Route::post('/update-page/{slug}', 'App\Http\Controllers\PagesModule@pageUpdate');
Route::get('/pages', 'App\Http\Controllers\PagesModule@pagesModule');
Route::get('/pages/{slug}', 'App\Http\Controllers\PagesModule@pagesView');
Route::get('/page-delete/{slug}', 'App\Http\Controllers\PagesModule@pageDelete');
Route::get('/users', 'App\Http\Controllers\PagesController@users');
//blogs
Route::get('/blogs', 'App\Http\Controllers\ControllerBlog@blog');
Route::get('/blogs/{slug}', 'App\Http\Controllers\ControllerBlog@viewBlog');
Route::get('/blog-create', 'App\Http\Controllers\ControllerBlog@editBlog');
Route::post('/add-blog', 'App\Http\Controllers\ControllerBlog@createBlog');
Route::post('/update-blog/{slug}', 'App\Http\Controllers\ControllerBlog@updateBlog');
Route::get('/delete-blog/{slug}', 'App\Http\Controllers\ControllerBlog@deleteBlog');

//Brand-info
Route::get('/brand-info', 'App\Http\Controllers\PagesController@brandInfo');
Route::get('/view-brand-info/{slug}', 'App\Http\Controllers\BrandInfo@viewBrandInfo');
Route::get('/add-brand-info', 'App\Http\Controllers\BrandInfo@addBrandInfo');
Route::post('/create-brand-info', 'App\Http\Controllers\BrandInfo@createBrandInfo');
Route::post('/update-brand-info/{slug}', 'App\Http\Controllers\BrandInfo@updateBrandInfo');
Route::get('/delete-brand-info/{slug}', 'App\Http\Controllers\BrandInfo@deleteBrandInfo');

//services
Route::get('/services', 'App\Http\Controllers\PagesController@services');
Route::get('/view-services/{slug}', 'App\Http\Controllers\Services@viewServices');
Route::get('/add-services', 'App\Http\Controllers\Services@addServices');
Route::post('/create-services', 'App\Http\Controllers\Services@createServices');
Route::post('/update-services/{slug}', 'App\Http\Controllers\Services@updateServices');
Route::get('/delete-services/{slug}', 'App\Http\Controllers\Services@deleteServices');

//packages
Route::get('/packages', 'App\Http\Controllers\PackagesController@packages');
Route::get('/edit-package/{slug}', 'App\Http\Controllers\PackagesController@packageEdit');
Route::get('/add-package', 'App\Http\Controllers\PackagesController@packageAdd');
Route::post('/create-package', 'App\Http\Controllers\PackagesController@packageCreate');
Route::post('/update-package-info/{slug}', 'App\Http\Controllers\PackagesController@packageUpdate');
Route::get('/delete-package/{slug}', 'App\Http\Controllers\PackagesController@packageDelete');

//users
Route::get('/view-user/{slug}', 'App\Http\Controllers\UsersController@users');
Route::get('/add-user', 'App\Http\Controllers\UsersController@addUsers');
Route::post('/create-user', 'App\Http\Controllers\UsersController@createUsers');
Route::post('/edit-users/{slug}', 'App\Http\Controllers\UsersController@editUsers');
Route::get('/delete-user/{slug}', 'App\Http\Controllers\UsersController@deleteUsers');

//brief-form

Route::get('/logo-brief/{slug}', 'App\Http\Controllers\PagesController@viewlogobrief');
Route::get('/edit-brief/{slug}', 'App\Http\Controllers\BriefController@editlogobrief');
Route::post('/logo-brief-update/{formId}', 'App\Http\Controllers\BriefController@logo_brief_update');


Route::get('/edit-website-brief/{slug}', 'App\Http\Controllers\BriefController@editwebbrief');
Route::post('/update-website-brief/{slug}', 'App\Http\Controllers\BriefController@update_web_brief');

Route::get('/website-brief-form/{slug}', 'App\Http\Controllers\BriefController@view_website_brief');
Route::post('/website-brief', 'App\Http\Controllers\PagesController@websitebrief');
Route::post('/logo-brief', 'App\Http\Controllers\PagesController@logobrief');
Route::get('/logo-brief-mail/{slug}', 'App\Http\Controllers\PagesController@logobriefmail');

//Package Type Crud

Route::get('/package-categories', 'App\Http\Controllers\PackageTypeController@index');
Route::get('/add-package-category', 'App\Http\Controllers\PackageTypeController@addpackagetype');
Route::post('/create-package-category', 'App\Http\Controllers\PackageTypeController@createpackagetype');
Route::get('/edit-package-categories/{slug}', 'App\Http\Controllers\PackageTypeController@editpackagetype');
Route::get('/delete-package-categories/{slug}', 'App\Http\Controllers\PackageTypeController@deletepackagetype');
Route::post('/update-package-category/{slug}', 'App\Http\Controllers\PackageTypeController@updatepackagetype');

//Portfolio 
Route::get('/portfolio', 'App\Http\Controllers\PortfolioController@portfolio');
Route::get('/add-portfolio', 'App\Http\Controllers\PortfolioController@addportfolio');
Route::get('/edit-portfolio/{slug}', 'App\Http\Controllers\PortfolioController@editportfolio');
Route::post('/create-portfolio', 'App\Http\Controllers\PortfolioController@createPortfolio');
Route::post('/update-portfolio/{slug}', 'App\Http\Controllers\PortfolioController@updatePortfolio');
Route::get('/delete-portfolio/{slug}', 'App\Http\Controllers\PortfolioController@deleteportfolio');

//Portfolio-Types
Route::get('/portfolio-categories', 'App\Http\Controllers\PortfolioTypesController@portfoliotypes');
Route::get('/add-portfolio-category', 'App\Http\Controllers\PortfolioTypesController@addportfolioCat');
Route::get('/edit-portfolio-category/{slug}', 'App\Http\Controllers\PortfolioTypesController@editportfolioCat');

Route::post('/create-portfolio-category', 'App\Http\Controllers\PortfolioTypesController@createPortfolioCat');
Route::post('/update-portfolio-category/{slug}', 'App\Http\Controllers\PortfolioTypesController@updatePortfolioCat');
Route::get('/delete-portfolio-category/{slug}', 'App\Http\Controllers\PortfolioTypesController@deleteportfolioCat');

//testimonials
Route::get('/testimonials', [TestimonialsController::class, 'testimonials']);
Route::get('/add-testimonials', 'App\Http\Controllers\TestimonialsController@add_testimonials');
Route::get('/edit-testimonials/{id}', 'App\Http\Controllers\TestimonialsController@edit_testimonials');
Route::post('create-testimonials', 'App\Http\Controllers\TestimonialsController@create_testimonials');
Route::post('/update-testimonials/{id}', 'App\Http\Controllers\TestimonialsController@update_testimonials');
Route::get('/delete-testimonials/{id}', 'App\Http\Controllers\TestimonialsController@delete_testimonials');



//Client Routes
Route::get('/projects', 'App\Http\Controllers\ClientPagesController@projects');
Route::get('/user-profile', 'App\Http\Controllers\ClientPagesController@user');
Route::post('/change-user-settings/{userId}', 'App\Http\Controllers\ClientPagesController@user_setting');
Route::get('/delete-profile/{userId}', 'App\Http\Controllers\ClientPagesController@delete_profile');
Route::get('/view-my-project/{id}', 'App\Http\Controllers\EmployeeController@view_my_project');
Route::post('/update-project', 'App\Http\Controllers\EmployeeController@update_status');

Route::get('/block-users',[ClientPagesController::class, 'block_clients']);
Route::get('/unlock-client-ip/{id}',[ClientPagesController::class, 'un_block_client_ip']);
Route::post('/block-client-ip',[ClientPagesController::class, 'block_client_ip']);

Route::post('/block-client-email',[ClientPagesController::class, 'block_client_email']);
Route::get('/unlock-client-email/{id}',[ClientPagesController::class, 'un_block_client_email']);

Route::post('/change-password/{id}', 'App\Http\Controllers\ClientPagesController@change_pass');
Route::post('/chat', 'App\Http\Controllers\EmployeeController@chat');



