<!DOCTYPE html>
<html lang="en-US">
<head>
  @foreach ($pagedata as $page)
   
  @endforeach
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>{{$page->seo_title}}</title>
  <meta name="description" content="{{$page->description}}"> 
  <meta name="googlebot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1"> 
  <meta name="bingbot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1">
  <meta name="keywords" content="{{$page->seo_keywords}}">
  <link rel="canonical" href="{{$page->seo_url}}">
  <meta property="og:locale" content="en_US" />
  <meta property="og:type" content="website" />
  <meta property="og:title" content="{{$page->seo_title}}" />
  <meta property="og:description" content="{{$page->seo_keywords}}" />
  <meta property="og:url" content="{{$page->seo_url}}" />
  <meta property="og:site_name" content="<?php echo env('APP_NAME')?>" />
  <meta property="og:publish_date" name="publish_date" content="{{ date("F j, Y, g:i a", strtotime($page->seo_published_date)) }}" >
  <meta property="og:image" content="{{$page->seo_image}}" />
  <meta property="og:image:width" content="300" />
  <meta property="og:image:height" content="300" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="{{$page->seo_title}}" />
  <meta name="twitter:description" content="{{$page->seo_keywords}}" />
  <meta property="twitter:url" content="{{$page->seo_url}}" />
  <meta name="twitter:image" content="seo_image" />
  <meta name="twitter:creator" content="@<?php echo env('APP_NAME')?>" />
  <meta name="twitter:site" content="@<?php echo env('APP_NAME')?>" />
  <meta name="twitter:label1" content="Written by">
  <meta name="twitter:data1" content="<?php echo env('APP_NAME')?>">
  <meta name="twitter:label2" content="Est. reading time">
  <meta name="twitter:data2" content="4 minutes">
@include('includes.style')

</head>

<body>

<!-- page wrapper start -->

<div class="page-wrapper">

<!-- preloader start -->

<div id="ht-preloader">
  <div class="loader clear-loader">
    <div class="loader-text">Loading</div>
    <div class="loader-dots"> <span></span>
      <span></span>
      <span></span>
      <span></span>
    </div>
  </div>
</div>

<!-- preloader end -->

@include('includes.header')


<!--page title start-->

<section class="page-title overflow-hidden text-center light-bg bg-contain animatedBackground" data-bg-img="images/pattern/05.png">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-md-12">
        <h1 class="title">{{$page->page_name}}</h1>
        {!!$page->page_section!!}
      </div>
    </div>
  </div>
  <div class="page-title-pattern"><img class="img-fluid" src="images/bg/06.png" alt=""></div>
</section>

<!--page title end-->


<!--body content start-->

<div class="page-content">

<!--contact start-->

<section class="contact-1" data-bg-img="images/pattern/02.png">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-6 col-md-7">
        <div class="section-title mb-2">
          <h6 >Get In Touch</h6>
          <h2 class="title">{{$page->page_name}}</h2> 
        </div>
        <div class="contact-main">
          
       
            <form action="/contact-us" method="post" class="row g-4 needs-validation">
            @csrf  
           
            <div class="messages"></div>
            <div class="col-md-6">
              <input id="form_name" type="text" name="name" class="form-control" placeholder="Name" required>
              <div class="invalid-feedback">Name is required.</div>
            </div>
            <div class="col-md-6">
              <input id="form_email" type="email" name="email" class="form-control" placeholder="Email" required>
              <div class="invalid-feedback">Valid email is required.</div>
            </div>
            <div class="col-md-12">
              <input id="form_phone" type="tel" name="phone" class="form-control" placeholder="Phone" required>
              <div class="invalid-feedback">Phone is required</div>
            </div>
            <div class="col-md-12">
              <textarea id="form_message" name="message" class="form-control" placeholder="Message" rows="3" required></textarea>
              <div class="invalid-feedback">Please,leave us a message.</div>
            </div>
            <div class="g-recaptcha mt-2 mb-3" data-sitekey="{{env('G_CAPTCHA_SITE_KEY')}}"></div>
            <p style="margin-top: 0;"> @if (count($errors) > 0)
                @foreach ($errors->all() as $error)
                    <div class="text-danger pb-2 pt-2" >
                        {{$error}}
                    </div>
                @endforeach
                @endif
        
                @if (session('success'))
                        {{session('success')}} 
                @endif
        
                @if (session('error'))
                    <div class="text-danger">
                        {{session('error')}} 
                    </div>
                @endif</p>
            <div class="col-md-12 mobile-mt-0">
              <button class="btn btn-theme col-md-5">Send Message</button>
            </div>
          </form>
        </div>  
      </div>
      <div class="col-lg-5 col-md-5 ms-auto mt-5 mt-md-0">
        <ul class="contact-info list-unstyled">
          <li class="mb-4"><i class="flaticon-location"></i><span>Address:</span>
            <p>14A S 1st St, San Jose, CA 95113, USA</p>
          </li>
          <li class="mb-4"><i class="flaticon-email"></i><span>Email</span><a href="mailto:info@sanjoselogodesign.com"> info@sanjoselogodesign.com</a>
          </li>
          <li class="mb-4"><i class="flaticon-call"></i><span>Phone:</span><a href="tel:+1 (214) 449-1305">(214) 449-1305</a>
          </li>
          
        </ul>
      </div>
    </div>
  </div>
</section>

<!--contact end-->

<section class="overflow-hidden p-0">
  <div class="container-fluid p-0">
    <div class="row align-items-center">
      <div class="col-md-12">
        <div class="map iframe-h-2">
       
          <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3172.280566074967!2d-121.8901787!3d37.3358659!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x808fccbccb89d163%3A0x8e4b8ff540519077!2s14A%20S%201st%20St%2C%20San%20Jose%2C%20CA%2095113%2C%20USA!5e0!3m2!1sen!2s!4v1679434181517!5m2!1sen!2s" allowfullscreen=""></iframe>
            
        </div>
      </div>
    </div>
  </div>
</section>

</div>

<!--body content end--> 

@include('includes/counter');
@include('includes/clientlogosection');
@include('includes/testimonialsection');
@include('includes/blogsection');
@include('includes/footer');

</div>

<!-- page wrapper end -->


<!--back-to-top start-->

<div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-upload"></i></a></div>

<!--back-to-top end-->

 
@include('includes/scripts');


</body>



</html>