<!DOCTYPE html>
<html lang="en">
   <head>
      <title>Receipt</title>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
      <link rel="icon" href="https://sanjoselogodesign.com/images/favicon.png" type="image/png">
   </head>
   <style>
       .text-custom{
           color:rgba(255,94,44,1);
       }
       .bg-theme{
           background:linear-gradient(90deg, rgba(255,120,16,1) 0%, rgba(255,94,44,1) 90%);
       }
      #invoice{
      padding: 30px;
      position: relative;
      background:black;
      min-height: 680px;
      padding: 15px;
      overflow-x: hidden !important;
      }
      .col.invoice-to .email a {
      color: #fff;
      }
      .address {
      color: #fff;
      }
      .invoice header {
      padding: 10px 0;
      margin-bottom: 20px;
      border-bottom: 1px solid rgba(255,94,44,1);
      }
      .invoice .company-details {
      text-align: right;
      color: #fff;
      }
      .invoice .company-details .name {
      margin-top: 0;
      margin-bottom: 0
      }
      .invoice .contacts {
      margin-bottom: 20px
      }
      .invoice .invoice-to {
      text-align: left;
      color:#fff;
      }
      .invoice .invoice-to .to {
      margin-top: 0;
      margin-bottom: 0
      }
      .invoice .invoice-details {
      text-align: right
      }
      .invoice .invoice-details .invoice-id {
      margin-top: 0;
      color: #0c0830
      }
      .invoice main {
      padding-bottom: 50px
      }
      .invoice main .thanks {
      margin-top: -100px;
      font-size: 2em;
      margin-bottom: 50px
      }
      .invoice main .notices {
      padding-left: 6px;
      border-left: 6px solid #0c0830;
      }
      .invoice main .notices .notice {
      font-size: 1.2em
      }
      .invoice table {
      width: 100%;
      border-collapse: collapse;
      border-spacing: 0;
      margin-bottom: 20px
      }
      .invoice table td,.invoice table th {
      padding: 15px;
      background: transparent;
      border: 2px solid rgba(255,94,44,1);
      color: #fff;
      }
      .invoice table th {
      white-space: nowrap;
      font-weight: 400;
      font-size: 16px
      }
      .invoice table td h3 {
      margin: 0;
      font-weight: 500;
      color: #fff;
      font-size: 1.2em
      }
      .invoice table .qty,.invoice table .total,.invoice table .unit {
      text-align: right;
      font-size: 1.2em
      }
      .invoice table .no {
      color: #fff;
      font-size: 1.6em;
      }
      .invoice table .unit {
      color: #fff;
      }
      .invoice table .total {
      background: #0c0830;
      color: #fff
      }
      .invoice table tbody tr:last-child td {
      /* border: none*/
      }
      .invoice table tfoot td {
      background: 0 0;
      /*border-bottom: none;*/
      white-space: nowrap;
      text-align: right;
      padding: 10px 20px;
      font-size: 1.2em;
      border-top: 1px solid #aaa
      }
      .invoice table tfoot tr:first-child td {
      /*border-top: none*/
      }
      .invoice table tfoot tr:last-child td {
      color: #fff;
      font-size: 1.4em;
      border-top: 1px solid #0c0830
      }
      .invoice table tfoot tr td:first-child {
      /* border: none*/
      }
      .invoice footer {
      width: 100%;
      text-align: center;
      color: #777;
      border-top: 1px solid #aaa;
      padding: 8px 0
      }
      .img-width {
      width: 40%;
      }
      button#printInvoice {
      background-color: #;
      border-radius: 5px;
      color: white;
      padding: 15px 40px;
      text-decoration: none;
      font-size: 14px;
      font-weight: 400;
      text-transform: uppercase;
      letter-spacing: 1px;
      display: inline-block;
      -webkit-transition-duration: 0.4s;
      transition-duration: 0.4s;
      }
      button#printInvoice:hover
      {
      color: #fff;
      transition: all 0.9s ease;
      transform: scale(0.9);
      box-shadow: inset 0px 0px 5px 5px #fff;
      }
      .custom-text {
      color: #fff;
      }
      @media print {
      .invoice {
      font-size: 11px!important;
      overflow: hidden!important
      }
      .invoice footer {
      position: absolute;
      bottom: 10px;
      page-break-after: always
      }
      .invoice>div:last-child {
      page-break-before: always
      }
      }
      .btn-primary {
      border-color: none !important; 
      }
      .termscondition {
      width: 50%; float: left; color: #fff; margin-top: 30px;
      }
      .termscondition  a {
      color: #fff;
      }
   </style>
   <body class="bd">
      @foreach ($data as $item)
      @endforeach
      @foreach ($genralInfo as $brand)

      @endforeach

      @foreach ($dataone as $item1)
      @endforeach
      <div class="container">
         <div class="row">
            <div class="col-sm-12 col-md-12 col-lg-1">&nbsp;</div>
            <div class="col-sm-12 col-md-12 col-lg-10">
               <div class="mb-5"></div>
               <div id="invoice" class="rounded">
                  <div class="invoice overflow-auto p-5">
                     <div style="min-width: 600px">
                        <header>
                           <div class="row">
                              <div class="col" >
                                 <a target="_blank" href="/">
                                 <img src="https://sanjoselogodesign.com/images/white-logo.png" class="img-fluid img-width" data-holder-rendered="true" />
                                 </a>
                              </div>
                              <div class="col company-details">
                                 <h2 class="name">
                                 </h2>
                                 <div>{{$brand->location}}</div>
                                 <div>
                                    <div class="email"><a href="mailto:{{$brand->email}}" class="custom-text">{{$brand->email}}</a></div>
                                 </div>
                                 <div>{{$brand->phone}}</div>
                              </div>
                           </div>
                        </header>
                        <main>
                           <div class="row contacts">
                              
                                 <div class="col invoice-to">
                                   <h2 class="pb-3">Thank You for Order</h2>
                                    <div class="address">Billed To</div>
                                    <div class="email"><a href="#" class="custom-text">{{$item->customer_name}}</a></div>
                                    <div class="email"><a href="#" class="custom-text">{{$item->email}}</a></div>
                                    <div class="email"><a href="#" class="custom-text">{{$item1->invoice_no}}</a></div>
                                 </div>
                            
                           </div>
                           <table  cellspacing="0" cellpadding="0">
                              <thead>
                                 <tr>
                                    <th>Order #</th>
                                    <th class="text-left"><b>PACKAGE DESCRIPTION</b></th>
                                    <th class="text-right"><b>TOTAL AMOUNT</b></th>
                                 </tr>
                              </thead>
                              <tbody>
                                 <?php $invoice_no = explode('-', $item1->invoice_no); ?>
                                 <tr>
                                    <td class="no">{{$invoice_no[1]}}</td>
                                    <td class="text-left">
                                       <h3>{{$item->custom_package_name}}</h3>
                                    </td>
                                    <td class="unit">${{$item->price}}</td>
                                 </tr>
                              </tbody>
                              <tfoot>
                                 <tr>
                                    <td colspan="3"><b>Amount Paid</b> <b>${{$item->price}}</b></td>
                                 </tr>
                              </tfoot>
                           </table>
                        </main>
                        <p class="text-white"><strong>Disclaimer:</strong> Payments will be process under the name of Outsourceship & MSB IT Solutions LLC, all the content that is the logo, pictures, portfolio, etc. solely belongs to <?php echo env('APP_NAME'); ?></p>
                        <div class="toolbar hidden-print">
                           <div class="text-left termscondition">
                              <a href="https://sanjoselogodesign.com/privacy-policy" target="_blank">Privacy Policy</a> | <a target="_blank" href="https://sanjoselogodesign.com/terms-condition">Terms &amp; Conditions</a>
                           </div>
                           <div class="text-right">
                              <button id="printInvoice" class="btn-print btn bg-theme"><i class="fa fa-print"></i> Print</button>
                           </div>
                           <hr>
                        </div>
                     </div>
                     <!--DO NOT DELETE THIS div. IT is responsible for showing footer always at the bottom-->
                     <div></div>
                  </div>
               </div>
               <div class="mb-5"></div>
            </div>
            <div class="col-sm-12 col-md-12 col-lg-1">&nbsp;</div>
         </div>
      </div>
   </body>
   <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
   <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js"></script>
   <script type="text/javascript">
      $('#printInvoice').click(function(){
      
              Popup($('.invoice')[0].outerHTML);
      
              function Popup(data) 
      
              {
      
                  window.print();
      
                  return true;
      
              }
      
          });
      
   </script>
</html>
