<!DOCTYPE html>
<html lang="en_us">

<head>
    <meta charset="utf-8">
    <meta name="keywords" content="Sanjose Logo Design - Thank You" />
    <meta name="description" content="Thank You" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Title -->
    <title><?php echo env('APP_NAME'); ?> - Logo Brief</title>
    @include('includes.style')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <style>
        /*logo-brief-form*/

        .logo-brief-ban {
            height: 20vh;
        }

        .pay-field textarea {
            height: 137px !important;
        }

        .pay-field {
            margin-bottom: 10px !important;
        }

        .logo-brief-ban:after {
            display: none;
        }

        .pay-field label>span {
            font-size: 9px;
            margin-left: 7px;
        }

        ul.logosel-lst {
            display: block;
        }

        ul.logosel-lst>li {
            display: inline-block;
            width: 49%;
            margin-right: 14px;
        }

        ul.logosel-lst>li:nth-child(2n) {
            margin-right: 0;
        }

        .logosel-bx {
            text-align: center;
            margin-bottom: 15px;
        }

        .logo-sel-pic {
            padding: 10px;
            border: 3px solid #f26622;
            margin-bottom: 10px;
        }

        .logosel-bx h4 {
            font-size: 15px;
            color: #000;
            letter-spacing: 1px;
            font-weight: 400;
        }

        ul.logosel-fonts {
            display: block;
        }

        ul.logosel-fonts>li {
            display: inline-block;
            vertical-align: top;
            margin-bottom: 10px;
            width: 19.6%;
        }

        .logofont {

            height: 85px;
            text-align: center;
            border: 3px solid #f26622;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        ul.logosel-fonts>li:nth-child(5n) {
            margin-right: 0;
        }

        .logoclr h4 {
            text-align: center;
            color: #000;
            font-size: 14px;
            padding-bottom: 10px;
        }

        .logoclr img {
            margin-bottom: 5px;
        }

        ul.lcu-clr {
            display: block;
        }

        ul.lcu-clr>li {
            display: inline-block;
            width: 48%;
            margin-right: 30px;
            vertical-align: middle;
        }

        ul.lcu-clr>li:last-child {
            margin-right: 0;
        }

        ul.logosel-clr {
            margin-bottom: 40px;

        }

        ul.logosel-clr>li {
            margin-right: 0px;
        }

        .files-upload {
            text-align: center;
            padding: 15px;
            border: 3px solid #273489;
        }

        .files-upload label {
            margin-bottom: 20px;
        }

        .files-upload input#fileToUpload {
            background: transparent;
        }

        .files-upload input::-webkit-file-upload-button {
            cursor: pointer !important;
            height: 42px;
            width: 100%;
        }

        .gt_logofnt {
            background: #f26622;
        }

        .white_select {
            background: #f26622;
        }

        .logoclr-slect {
            box-shadow: 0px 2px 18px 0px #fff;

            background: #f26622;
        }

        .gt_logofnt img {
            filter: brightness(10);
        }

        .pay-field input,
        .pay-field textarea {
            border: 3px solid #f26622;
        }

        .logoclr-slect h4 {
            color: #fff;
        }

        .logo-brief h6 {
            font-size: 32px;
            padding: 20px 0px 20px 0px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .logo-brief h5 {
            font-size: 56px;

            font-weight: bold;

            padding-bottom: 2%;
        }

        .logo-brief h5>span,
        .logo-brief h6>span {
            color: #f26622;
        }

        . {
            margin-top: 45px;
        }

        .uploadfieldcss {
            height: auto;

            padding: 0.337rem 0.175rem;
        }

        .briefbutton {
            background: #f25a06;

            color: #fff;

            border-color: #ff7e00;

            float: right;

            padding: 10px 60px;
        }

        .requiredfield {
            color: red;

            font-size: 14px !important;
        }

        .text-danger {
            color: #ae0011 !important;
            font-style: italic;
            font-weight: 500;
            font-size: 13px;
        }

        ul.logo-color>li {
            display: inline-block;
            vertical-align: top;
            margin-bottom: 10px;
            width: 15.6% !important;
        }

        ul.logosel-clr.logosel-fonts.logo-color {
            display: flex;
            flex-wrap: wrap;
            gap: 22px;
        }

        ul.logosel-clr.logosel-fonts.logo-color>li {
            display: contents;
            vertical-align: top;
            margin-bottom: 10px;
            width: 19.6%;
        }

        .files-upload {
            position: relative;
        }

        .files-upload {
            text-align: center;
            padding: 15px;
            border: 3px solid #273489;
            background: #fff;
            border-radius: 0;
            min-height: 165px;
        }

        .preview-image-container {
            display: inline-block;
            padding: 6px;
            position: relative;
            width: 16.6%;
        }

        img.preview-image {
            object-fit: cover;
            border-radius: 10px;
            width: 100%;
            border: 2px solid #e7e7e7;
            height: 120px;
        }

        .pay-field input,
        .pay-field textarea {
            border: 3px solid #f26622;
            width: 100%;
        }


        .pay-field input {
            height: 50px;
        }

        button.delete-button {
            position: absolute;
            right: 9px;
            font-size: 19px;
            border: 0px;
            background: transparent;
            color: #d50b51;
            font-weight: 500;
            z-index: 999;
        }

        @media (max-width: 425px) {
            ul.logosel-lst>li {
                display: inline-block;
                width: 47%;
                margin-right: 14px;
            }

            .logofont img {
                width: 50%;
            }

            .logo-brief h5,
            .logo-brief h6 {
                font-size: x-large;
                font-weight: 700;
                padding: 0px;
                line-height: normal;
                letter-spacing: 7px;
                text-transform: uppercase;
            }

            ul.lcu-clr>li {
                width: 100%;
            }

            ul.logosel-fonts>li {
                display: inline-flex;
                vertical-align: top;
                margin: 5px 0 0 0px;
                justify-content: space-between;
                width: 49%;
            }
        }

        /* ul.logosel-clr>li {
    margin-right: 84px;
}

ul.logosel-clr {
    margin-bottom: 0px; 
    text-align: left;
} */
        /*logo-brief-from-end*/
    </style>
</head>

<body>
    <!-- page wrapper start -->
    <div class="page-wrapper">
        <!-- preloader start -->
        <!-- preloader end -->
        @include('includes/header')
        <!--page title start-->
        <section class="page-title overflow-hidden text-center light-bg bg-contain animatedBackground" data-bg-img="images/pattern/05.png" style="background-image: url(&quot;images/pattern/05.png&quot;);">

            <div class="container">

                <div class="row align-items-center">

                    <div class="col-md-12">

                        <h1 class="title">Logo Brief</h1>



                    </div>

                </div>

            </div>



        </section>
        <section class="main-service contact-banner-img mt-5 logo-brief">
            <div class="container">
                <div class="payment-h m3-h ">
                    <h5>Fill Your <span>Logo Brief</span></h5>
                </div>
                <div class="ban-con">
                    <form action="/add-logo-brief" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="logobrif-d pad-btmm">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="payment-fm pay-af">
                                        <div class="pay-field">
                                            <label>Contact Person Name<span class="requiredfield">*</span><span>As
                                                    provided initially</span></label>
                                            <input type="text" name="name" value="{{ old('name') }}" id="full_name" />
                                            @if ($errors->has('name'))
                                            <small class="text-danger">{{ $errors->first('name') }}</small>
                                            @endif
                                        </div>
                                        <div class="pay-field">
                                            <label>Email<span class="requiredfield">*</span><span>As provided
                                                    initially</span></label>
                                            <input type="email" name="email" value="{{ old('email') }}" id="person_mail" />
                                            @if ($errors->has('email'))
                                            <small class="text-danger">{{ $errors->first('email') }}</small>
                                            @endif
                                        </div>
                                        <div class="pay-field">
                                            <label>Logo Name<span class="requiredfield">*</span></label>
                                            <input type="text" name="logo_name" value="{{ old('logo_name') }}" id="company_name" />
                                            @if ($errors->has('logo_name'))
                                            <small class="text-danger">{{ $errors->first('logo_name') }}</small>
                                            @endif
                                        </div>
                                        <div class="pay-field">
                                            <label>Company Slogan</label>
                                            <input type="text" name="company_slogan" value="{{ old('company_slogan') }}" />
                                            @if ($errors->has('company_slogan'))
                                            <small class="text-danger">{{ $errors->first('company_slogan') }}</small>
                                            @endif
                                        </div>
                                        <div class="pay-field">
                                            <label>Personal Phone<span class="requiredfield">*</span></label>
                                            <input type="number" name="personal_phone" value="{{ old('personal_phone') }}" />
                                            @if ($errors->has('personal_phone'))
                                            <small class="text-danger">{{ $errors->first('personal_phone') }}</small>
                                            @endif
                                        </div>
                                        <div class="pay-field">
                                            <label>Company Phone</label>
                                            <input type="number" value="{{ old('company_phone') }}" name="company_phone" />
                                            @if ($errors->has('company_phone'))
                                            <small class="text-danger">{{ $errors->first('company_phone') }}</small>
                                            @endif
                                        </div>
                                        <div class="pay-field">
                                            <label>Industry</label>
                                            <input type="text" value="{{ old('industry') }}" name="industry" />
                                            @if ($errors->has('industry'))
                                            <small class="text-danger">{{ $errors->first('industry') }}</small>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="payment-fm">
                                        <div class="pay-field">
                                            <label>Describe your Business<span class="requiredfield">*</span></label>
                                            <textarea class="form-control" name="business_desc">{{ old('business_desc') }}</textarea>
                                            @if ($errors->has('business_desc'))
                                            <small class="text-danger">{{ $errors->first('business_desc') }}</small>
                                            @endif
                                        </div>
                                        <div class="pay-field ">
                                            <label>What you want in your logo<span class="requiredfield">*</span></label>
                                            <textarea class="form-control" name="logo_description">{{ old('logo_description') }}</textarea>
                                            @if ($errors->has('logo_description'))
                                            <small class="text-danger">{{ $errors->first('logo_description') }}</small>
                                            @endif
                                        </div>
                                        <div class="pay-field ">
                                            <label>Competitors Reference 1<span class="requiredfield">*</span></label>
                                            <input type="text" value="{{ old('competitors_ref') }}" name="competitors_ref" />
                                            @if ($errors->has('competitors_ref'))
                                            <small class="text-danger">{{ $errors->first('competitors_ref') }}</small>
                                            @endif
                                        </div>


                                        <div class="pay-field ">
                                            <label>Competitors Reference 2</label>
                                            <input type="text" value="{{ old('competitors_ref_two') }}" name="competitors_ref_two" />
                                            @if ($errors->has('competitors_ref_two'))
                                            <small class="text-danger">{{ $errors->first('competitors_ref_two') }}</small>
                                            @endif
                                        </div>


                                        <div class="pay-field ">
                                            <label>Competitors Reference 3</label>
                                            <input type="text" value="{{ old('competitors_ref_three') }}" name="competitors_ref_three" />
                                            @if ($errors->has('competitors_ref_three'))
                                            <small class="text-danger">{{ $errors->first('competitors_ref_three') }}</small>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="logo-sel m4-h mt-5 pad-btmm">
                            <h6>Choose <span>Logo</span> Type</h6>
                            <ul class="logosel-lst">
                                <li>
                                    <div class="logosel-bx">
                                        <div class="logo-sel-pic" data-logotype="Symbol or Icon">
                                            <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-sel1.png" />
                                        </div>
                                        <h4>Symbol or Icon</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logosel-bx">
                                        <div class="logo-sel-pic" data-logotype="Letter Mark">
                                            <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-sel2.png" />
                                        </div>
                                        <h4>Letter Mark</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logosel-bx">
                                        <div class="logo-sel-pic" data-logotype="Character Based">
                                            <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-sel3.png" />
                                        </div>
                                        <h4>Character Based</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logosel-bx">
                                        <div class="logo-sel-pic" data-logotype="Word Mark">
                                            <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-sel4.png" />
                                        </div>
                                        <h4>Word Mark</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logosel-bx">
                                        <div class="logo-sel-pic white_select" data-logotype="Combination Mark">
                                            <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-sel5.png" />
                                        </div>
                                        <h4>Combination Mark</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logosel-bx">
                                        <div class="logo-sel-pic" data-logotype="Emblem">
                                            <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-sel6.png" />
                                        </div>
                                        <h4>Emblem</h4>
                                    </div>
                                </li>
                            </ul>
                        </div>
                        <input type="hidden" id="logotypeget" name="logo_type" />
                        <div class="logo-sel m4-h pad-btmm ">
                            <h6>Choose <span>logo</span> fonts</h6>
                            <ul class="logosel-fonts">
                                <li>
                                    <div class="logofont" data-logofont="comic">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-f1.png" />
                                    </div>
                                </li>
                                <li>
                                    <div class="logofont" data-logofont="stencil">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-f2.png" />
                                    </div>
                                </li>
                                <li>
                                    <div class="logofont" data-logofont="gothic">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-f3.png" />
                                    </div>
                                </li>
                                <li>
                                    <div class="logofont" data-logofont="script">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-f4.png" />
                                    </div>
                                </li>
                                <li>
                                    <div class="logofont" data-logofont="handwritten">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-f5.png" />
                                    </div>
                                </li>
                                <li>
                                    <div class="logofont" data-logofont="san serif ">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-f6.png" />
                                    </div>
                                </li>
                                <li>
                                    <div class="logofont" data-logofont="serif">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-f7.png" />
                                    </div>
                                </li>
                                <li>
                                    <div class="logofont" data-logofont="retro">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-f8.png" />
                                    </div>
                                </li>
                                <li>
                                    <div class="logofont gt_logofnt" data-logofont="techno">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-f9.png" />
                                    </div>
                                </li>
                                <li>
                                    <div class="logofont" data-logofont="narrow">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-f10.png" />
                                    </div>
                                </li>
                            </ul>
                        </div>
                        <input type="hidden" id="logofonttyp" name="logo_fonts" value="techno" />
                        <div class="logo-sel m4-h pad-btmm ">
                            <h6>Choose <span>Logo</span> Colour</h6>
                            <ul class="logosel-clr logosel-fonts logo-color" style="">
                                <li>
                                    <div class="logoclr" data-logoclr="blue">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-clr1.png" />
                                        <h4>Blue</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logoclr" data-logoclr="yellow">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-clr2.png" />
                                        <h4>Yellow</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logoclr" data-logoclr="red">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-clr3.png" />
                                        <h4>Red</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logoclr" data-logoclr="purple">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-clr4.png" />
                                        <h4>Purple</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logoclr" data-logoclr="green">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-clr5.png" />
                                        <h4>Green</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logoclr" data-logoclr="Maroon">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-clr6.png" />
                                        <h4>Maroon</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logoclr" data-logoclr="Neutrals">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-clr7.png" />
                                        <h4>Neutrals</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logoclr" data-logoclr="Aqua">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-clr8.png" />
                                        <h4>Aqua</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logoclr" data-logoclr="Pink">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-clr9.png" />
                                        <h4>Pink</h4>
                                    </div>
                                </li>
                                <li>
                                    <div class="logoclr" data-logoclr="Designers suggestions">
                                        <img src="<?php echo env('APP_URL'); ?>images/logo-brief/logo-clr10.png" />
                                        <h4>Designers suggestions</h4>
                                    </div>
                                </li>
                            </ul>
                            <ul class="lcu-clr">
                                <li>
                                    <div class="pay-field">
                                        <label>Specify your Own Colour<span>Primary</span></label>
                                        <input type="color" id="primary_color" value="{{ old('primary_color') }}" name="primary_color" />
                                        @if ($errors->has('primary_color'))
                                        <small class="text-danger">{{ $errors->first('primary_color') }}</small>
                                        @endif
                                    </div>
                                </li>
                                <li>
                                    <div class="pay-field">
                                        <label>Secondary</label>
                                        <input type="color" id="secondary_color" value="{{ old('secondary_color') }}" name="secondary_color" />
                                        @if ($errors->has('secondary_color'))
                                        <small class="text-danger">{{ $errors->first('secondary_color') }}</small>
                                        @endif
                                    </div>
                                </li>
                            </ul>
                        </div>
                        <input type="hidden" id="logoclrslect" name="logo_color" />
                        {{-- <div class="logo-sel m4-h pad-btmm">
                            <h6>Upload Your <span>File</span></h6>
                            <div class="form-group files-upload">
                                <label><img src="<?php echo env('APP_URL'); ?>images/logo-brief/upload.png" /></label>
                                <input type="file" name="files" id="fileToUpload"
                                    class="form-control uploadfieldcss" />
                            </div>
                        </div> --}}

                        <div class="form-group files-upload">
                            <div id="imagespreview">
                            </div>

                            <label id="fileToUpload" style="z-index: 1;position: absolute;width: 100%;top: 69px;transform: translate(-50%, -50%);">
                                <img id="uploadicon" src="<?php echo env('APP_URL'); ?>images/logo-brief/upload.png" />
                            </label>
                            <input type="file" multiple name="files[]" id="fileToUploadImage" style="display:none" class="form-control">
                        </div>
                        <button type="submit" name="submit" class="btn p-3" style="background: #062365; color:white" value="main-service">Submit Your Brief</button>

                    </form>
                </div>
            </div>
        </section>
        @include('includes/footer')
    </div>
    <!-- page wrapper end -->
    <!--back-to-top start-->
    <div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-upload"></i></a></div>
    <!--back-to-top end-->
    @include('includes/scripts')

    <script>
        const fileInput = document.getElementById('fileToUploadImage');
        const imagePreview = document.getElementById('imagespreview');

        $('#fileToUpload').click(function() {
            $('#fileToUploadImage').click();
        });

        fileInput.addEventListener('change', function() {
            const files = fileInput.files;
            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                const reader = new FileReader();

                reader.onload = function(event) {
                    const imgContainer = document.createElement('div'); // Create a container for each image
                    imgContainer.classList.add('preview-image-container');

                    const img = document.createElement('img');
                    img.src = event.target.result;
                    img.classList.add('preview-image');

                    const deleteButton = document.createElement('button');
                    deleteButton.innerText = 'x';
                    deleteButton.classList.add('delete-button');

                    deleteButton.addEventListener('click', function() {
                        imgContainer
                            .remove(); // Remove the image container when the delete button is clicked
                    });

                    imgContainer.appendChild(img);
                    imgContainer.appendChild(deleteButton);

                    imagePreview.appendChild(imgContainer);
                }

                reader.readAsDataURL(file);
            }
        });


        $(".logo-sel-pic").click(function() {
            dis = $(this);
            logotypeget = dis.data("logotype");
            sbl = dis.parents("li").siblings().find(".logo-sel-pic");
            dis.addClass("white_select");
            sbl.removeClass("white_select");
            $("#logotypeget").val(logotypeget);
        });

        $(".logofont").click(function() {
            dis = $(this);
            logofonttyp = dis.data("logofont");
            sbl = dis.parents("li").siblings().find(".logofont");
            dis.addClass("gt_logofnt");
            sbl.removeClass("gt_logofnt");
            $("#logofonttyp").val(logofonttyp);
        });

        $(".logoclr").click(function() {
            dis = $(this);
            logoclrslect = dis.data("logoclr");
            sbl = dis.parents("li").siblings().find(".logoclr");
            dis.addClass("logoclr-slect");
            sbl.removeClass("logoclr-slect");
            $("#logoclrslect").val(logoclrslect);
        });
    </script>
</body>

</html>