<!DOCTYPE html>
<html lang="en-US">

<head>
    @foreach ($pagedata as $page)
    @endforeach
    {{-- Seo Dynamic Links --}}
    <meta charset="UTF-8">
    <meta name="viewport"
        content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $page->seo_title }}</title>
    <meta name="description" content="{{ $page->description }}">
    <meta name="robots" content="index,follow">
    <meta name="googlebot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1">
    <meta name="bingbot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1">
    <meta name="keywords" content="{{ $page->seo_keywords }}">
    <link rel="canonical" href="{{ $page->seo_url }}">
    <meta property="og:locale" content="en_US" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="{{ $page->seo_title }}" />
    <meta property="og:description" content="{{ $page->description }}" />
    <meta property="og:url" content="{{ $page->seo_url }}" />
    <meta property="og:site_name" content="<?php echo env('APP_NAME'); ?>" />
    <meta property="og:publish_date" name="publish_date"
        content="{{ date('F j, Y, g:i a', strtotime($page->seo_published_date)) }}">
    <meta property="og:image" content="{{ $page->seo_image }}" />
    <meta property="og:image:width" content="300" />
    <meta property="og:image:height" content="300" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="{{ $page->seo_title }}" />
    <meta name="twitter:description" content="{{ $page->description }}" />
    <meta property="twitter:url" content="{{ $page->seo_url }}" />
    <meta name="twitter:image" content="seo_image" />
    <meta name="twitter:creator" content="@<?php echo env('APP_NAME'); ?>" />
    <meta name="twitter:site" content="@<?php echo env('APP_NAME'); ?>" />
    <meta name="twitter:label1" content="Written by">
    <meta name="twitter:data1" content="<?php echo env('APP_NAME'); ?>">
    <meta name="twitter:label2" content="Est. reading time">
    <meta name="twitter:data2" content="4 minutes">

    @include('includes.style')

    <script type="application/ld+json">
{"@context":"http://schema.org",
"@type":"WebPage",
"url":"https://sanjoselogodesign.com/logo-design",
"name":" Top rated Logo Design Services San Jose",
"description":" San Jose Logo Design Is A Professional Logo Designing Agency Based In California, USA.",
"publisher":{"@type":"Organization","name":"San Jose Logo Design"},
"keywords":"logo design san jose, custom logo design service san jose, logo design resource in san jose, custom logo design company usa, custom logo design company in usa, web application development companies in usa, web design and development company sanjose, web design company california, web design services usa"}
</script>

    <script type="application/ld+json">
{
"@context": "http://schema.org/",
"@type": "Product",
"name": " Top Logo Design Services Provider in California",
"description": "We offer affordable custom logo designs that are ready to impress and gives a clear message for your brand in california, USA",
"brand": {
"@type": "brand",
"name": "San Jose Logo Design"
},
"aggregateRating": {
"@type": "AggregateRating",
"ratingValue": "4.9",
"ratingCount": "197"
}
}
</script>

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "FAQPage",
  "mainEntity": [{
    "@type": "Question",
    "name": "What Is The Process Of Creating A Logo Design?
",
    "acceptedAnswer": {
      "@type": "Answer",
      "text": "The process of creating a logo design typically involves research, sketching and conceptualization, design development, and finalization."
    }
  },{
    "@type": "Question",
    "name": "What Are Some Logo Design Agencies In San Jose?",
    "acceptedAnswer": {
      "@type": "Answer",
      "text": "San Jose Logo Design is the best local designing agency in San Jose. Our experts know how to design a logo as per the requirement of our clients."
    }
  },{
    "@type": "Question",
    "name": "How Do I Hire A Logo Design Agency In San Jose?",
    "acceptedAnswer": {
      "@type": "Answer",
      "text": "To hire experts in San Jose, Visit www.sanjoselogodesign.com or directly call at our number or fill out contact us form."
    }
  },{
    "@type": "Question",
    "name": "What Is The Process For Working With A Logo Design Agency?",
    "acceptedAnswer": {
      "@type": "Answer",
      "text": "The process for working with a logo design agency typically involves initial consultation, contract signing, payment of a deposit, design development, revisions, finalization, and delivery of final files."
    }
  },{
    "@type": "Question",
    "name": "Can I See Examples Of Work Done By A Logo Design Agency?",
    "acceptedAnswer": {
      "@type": "Answer",
      "text": "Yes, most logo design agencies have portfolios of their work available on their website, or they may be able to provide examples upon request."
    }
  }]
}
</script>

</head>

<body>


    <!-- page wrapper start -->

    <div class="page-wrapper">

        <!-- preloader start -->

        <div id="ht-preloader">
            <div class="loader clear-loader">
                <div class="loader-text">Loading</div>
                <div class="loader-dots"> <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
            </div>
        </div>

        <!-- preloader end -->


        @include('includes.header')


        <!--page title start-->
        <section class="page-title overflow-hidden text-center light-bg bg-contain animatedBackground"
            data-bg-img="images/pattern/05.png">

            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <h1 class="title">{{ $page->page_name }}</h1>
                    </div>
                </div>
            </div>

            <div class="page-title-pattern"><img class="img-fluid" src="images/bg/06.png" alt=""></div>

        </section>

        <!--page title end-->


        <!--body content start-->

        <div class="page-content">

            <!--service details start-->

            <!-- <section>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-8 col-md-12">
                            <div>
                                <div class="service-images">
                                    <img class="img-fluid w-100" src="images/case-studies/large/02.jpg" alt="">
                                </div>
                                
                            </div>
                            
                        </div>
                        {{-- Side Navbar --}}
                      @include('includes.sidenav')
                    </div>
                </div>
            </section> -->

            <!--service details end-->

        </div>

        <section class="">
            <div class="container">
                <div class="row">
                    <div class="col-lg-8 col-md-8">
                        <div class="section-title">
                            {!! $page->page_section !!}
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4">
                        <img class="img-fluid" src="images/logo-design-service.png"
                            alt="logo design service in sanjose">
                    </div>
                </div>
        </section>
        <section class="overflow-hidden">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="info-img position-relative">
                            <img class="img-fluid topBottom" src="images/about/logo-2.jpg" alt="">
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 mt-5 mt-lg-0">
                        <div class="section-title mb-4">
                            {!! $page->page_section_two !!}
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--body content end-->
        <section class="overflow-hidden pb-0" data-bg-img="images/pattern/01.png">
            <div class="container text-center">
                <div class="row">
                    <div class="col-lg-8 col-md-12 mx-auto">
                        <div class="section-title">
                            <h2 class="title">We’ve done lot’s of work, Let’s Check some
                                from here</h2>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="portfolio-filter">

                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid p-0">
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="grid columns-3 row g-0 popup-gallery">
                            <div class="grid-sizer"></div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo7.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo7.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo13.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo13.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo14.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo14.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo12.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo12.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo5.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo5.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>


                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo4.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo4.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo8.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo8.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo6.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo6.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo10.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo10.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo3.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo3.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo9.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo9.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo1.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo1.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo11.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo11.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/3.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/3.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/4.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/4.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/5.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/5.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/logo2.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/logo2.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div class="grid-item cat1">
                                <a data-fancybox="gallery" data-src="images/logoCV/6.jpg" data-width="740"
                                    data-height="460">
                                    <div class="portfolio-item">
                                        <img src="images/logoCV/6.jpg" class="img-fluid w-100" />
                                        <div class="portfolio-title"> <span>Services</span>
                                            <h4>Logo</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
    </div>
    </section>

    <section class="light-bg" data-bg-img="images/bg/02.png">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-9 col-md-12">
                    <div class="section-title">
                        <h2 class="title">Affordable Custom Logo Design Packages</h2>
                        <p class="mb-0">As a leading logo design company based in San Jose, California, we can offer
                            custom logo designs at very affordable prices that will leave you impressed and clearly
                            state the purpose of your brand. Contact us today!</p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="tab text-center">

                        <!-- Tab panes -->
                        <div class="tab-content px-0 pb-0" id="nav-tabContent">

                            <div role="tabpanel" class="tab-pane fade show active" id="tab1-1">

                                <div class="row">
                                    @foreach ($data as $item)
                                        <div class="col-lg-4 col-md-12  mb-5">
                                            <div class="price-table">
                                                <div class="round-p-animation"></div>
                                                <div class="price-header">
                                                    <h3 class="price-title">{{ $item->name }}</h3>
                                                </div>
                                                <img class="img-fluid my-4" src="images/price/01.png" alt="">
                                                <div class="price-value">
                                                    <h2>${{ $item->price }}</h2>
                                                </div>
                                                <div class="price-list">
                                                    {!! $item->description !!}
                                                </div>

                                                <span type="button" class="btn btn-theme mt-5 getstarted"
                                                    data-toggle="modal" data-target="#modalform"
                                                    data-price="{{ $item->price }}"
                                                    data-packagename="{{ $item->name }}"
                                                    data-packageid="{{ $item->id }}"> <span>Get Started</span>

                                                </span>

                                            </div>
                                        </div>
                                    @endforeach

                                    @include('includes.popup')
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </section>
    <?php $faqs = DB::table('faqs')
        ->where('page_slug', 'logo-design')
        ->get(); ?>
    @if ($faqs->count() > 0)
        <section class="faqs">
            <div class="container-fluid mt-5 mb-5">
                <div class="row">
                    <div class="col-md-6 offset-md-3">
                        <div class="faq-title text-center pb-3">
                            <h2>FAQ</h2>
                        </div>
                    </div>
                    <div class="col-md-6 offset-md-3">
                        <div class="faq" id="accordion">

                            @foreach ($faqs as $faq)
                                <div class="card mt-3">
                                    <div class="card-header" id="faqHeading-{{ $loop->iteration }}">
                                        <div class="mb-0">
                                            <h3 class="faq-title" data-toggle="collapse"
                                                data-target="#faqCollapse-{{ $loop->iteration }}"
                                                data-aria-expanded="true"
                                                data-aria-controls="faqCollapse-{{ $loop->iteration }}">
                                                <span class="badge">{{ $loop->iteration }}</span>{{ $faq->title }}

                                            </h3>
                                        </div>
                                    </div>
                                    <div id="faqCollapse-{{ $loop->iteration }}" class="collapse"
                                        aria-labelledby="faqHeading-{{ $loop->iteration }}" data-parent="#accordion">
                                        <div class="card-body">
                                            <p>{!! $faq->remarks !!}</p>
                                        </div>
                                    </div>
                                </div>
                            @endforeach




                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    @include('includes/counter')
    @include('includes/clientlogosection')
    @include('includes/testimonialsection')
    <!-- include blog -->
    @include('includes/footer')
    </div>
    <div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-upload"></i></a></div>
    @include('includes/scripts')

</body>

</html>
