<!DOCTYPE html>
<html lang="en-US">


<head>
  @foreach ($pagedata as $page)
   
  @endforeach
  {{-- Seo Dynamic Links --}}
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>{{$page->seo_title}}</title>
  <meta name="description" content="{{$page->description}}">
  <meta name="robots" content="index,follow"> 
  <meta name="googlebot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1"> 
  <meta name="bingbot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1">
  <meta name="keywords" content="{{$page->seo_keywords}}">
  
  
  <link rel="canonical" href="{{$page->seo_url}}">
  <meta property="og:locale" content="en_US" />
  <meta property="og:type" content="website" />
  <meta property="og:title" content="{{$page->seo_title}}" />
  <meta property="og:description" content="{{$page->seo_keywords}}" />
  <meta property="og:url" content="{{$page->seo_url}}" />
  <meta property="og:site_name" content="<?php echo env('APP_NAME')?>" />
  <meta property="og:publish_date" name="publish_date" content="{{ date("F j, Y, g:i a", strtotime($page->seo_published_date)) }}" >
    
  
  <meta property="og:image" content="{{$page->seo_image}}" />
  <meta property="og:image:width" content="300" />
  <meta property="og:image:height" content="300" />
  
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="{{$page->seo_title}}" />
  <meta name="twitter:description" content="{{$page->seo_keywords}}" />
  <meta property="twitter:url" content="{{$page->seo_url}}" />
  <meta name="twitter:image" content="seo_image" />
  <meta name="twitter:creator" content="@<?php echo env('APP_NAME')?>" />
  <meta name="twitter:site" content="@<?php echo env('APP_NAME')?>" />
  <meta name="twitter:label1" content="Written by">
  <meta name="twitter:data1" content="<?php echo env('APP_NAME')?>">
  <meta name="twitter:label2" content="Est. reading time">
  <meta name="twitter:data2" content="4 minutes">

@include('includes.style')

</head>

<body>

<!-- page wrapper start -->

<div class="page-wrapper">

<!-- preloader start -->

<div id="ht-preloader">
  <div class="loader clear-loader">
    <div class="loader-text">Loading</div>
    <div class="loader-dots"> <span></span>
      <span></span>
      <span></span>
      <span></span>
    </div>
  </div>
</div>

<!-- preloader end -->


@include('includes.header')


<!--page title start-->

<section class="page-title overflow-hidden text-center light-bg bg-contain animatedBackground" data-bg-img="images/pattern/05.png">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-md-12">
        <h1 class="title">{{$page->page_name}}</h1>
        
      </div>
    </div>
  </div>
  <div class="page-title-pattern"><img class="img-fluid" src="images/bg/06.png" alt=""></div>
</section>

<!--page title end-->


<!--body content start-->

<div class="page-content">

<!--privacy start-->

<section>
  <div class="container">
    <div class="row">
      <div class="col-lg-12 col-md-12">
        <h2 class="title mb-0">{{$page->page_name}}</h2>
      </div>
    </div>
    <div class="row mt-3">
      <div class="col-lg-12 col-md-12">
        {!!$page->page_section!!}
      </div>
    </div>
  </div>
</section>

<!--privacy end-->

</div>

<!--body content end--> 
  @include('includes/counter');
  @include('includes/clientlogosection');
  @include('includes/testimonialsection');
  @include('includes/blogsection');
  @include('includes/footer');


</div>

<!-- page wrapper end -->


<!--back-to-top start-->

<div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-upload"></i></a></div>

<!--back-to-top end-->

 
@include('includes/scripts');

</body>



</html>