<!DOCTYPE html>

<html lang="en-US">





<head>

    @foreach ($pagedata as $page)
    @endforeach

    {{-- Seo Dynamic Links --}}

    <meta charset="UTF-8">

    <meta name="viewport"
        content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">

    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <title>{{ $page->seo_title }}</title>

    <meta name="description" content="{{ $page->description }}">

    <meta name="robots" content="index,follow">

    <meta name="googlebot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1">

    <meta name="bingbot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1">

    <meta name="keywords" content="{{ $page->seo_keywords }}">





    <link rel="canonical" href="{{ $page->seo_url }}">

    <meta property="og:locale" content="en_US" />

    <meta property="og:type" content="website" />

    <meta property="og:title" content="{{ $page->seo_title }}" />

    <meta property="og:description" content="{{ $page->description }}" />

    <meta property="og:url" content="{{ $page->seo_url }}" />

    <meta property="og:site_name" content="<?php echo env('APP_NAME'); ?>" />

    <meta property="og:publish_date" name="publish_date"
        content="{{ date('F j, Y, g:i a', strtotime($page->seo_published_date)) }}">





    <meta property="og:image" content="{{ $page->seo_image }}" />

    <meta property="og:image:width" content="300" />

    <meta property="og:image:height" content="300" />



    <meta name="twitter:card" content="summary_large_image" />

    <meta name="twitter:title" content="{{ $page->seo_title }}" />

    <meta name="twitter:description" content="{{ $page->description }}" />

    <meta property="twitter:url" content="{{ $page->seo_url }}" />

    <meta name="twitter:image" content="seo_image" />

    <meta name="twitter:creator" content="@<?php echo env('APP_NAME'); ?>" />

    <meta name="twitter:site" content="@<?php echo env('APP_NAME'); ?>" />

    <meta name="twitter:label1" content="Written by">

    <meta name="twitter:data1" content="<?php echo env('APP_NAME'); ?>">

    <meta name="twitter:label2" content="Est. reading time">

    <meta name="twitter:data2" content="4 minutes">

    @include('includes.style')

</head>



<body>



    <!-- page wrapper start -->



    <div class="page-wrapper">



        <!-- preloader start -->



        <div id="ht-preloader">

            <div class="loader clear-loader">

                <div class="loader-text">Loading</div>

                <div class="loader-dots"> <span></span>

                    <span></span>

                    <span></span>

                    <span></span>

                </div>

            </div>

        </div>



        <!-- preloader end -->





        @include('includes/header');





        <!--page title start-->



        <section class="page-title overflow-hidden text-center light-bg bg-contain animatedBackground"
            data-bg-img="images/pattern/05.png">

            <div class="container">

                <div class="row align-items-center">

                    <div class="col-md-12">

                        <h1 class="title">{{ $page->page_name }}</h1>



                    </div>

                </div>

            </div>

            <div class="page-title-pattern"><img class="img-fluid" src="images/bg/06.png" alt=""></div>

        </section>



        <!--page title end-->





        <!--body content start-->



       


        <section>

            <div class="container">

                <div class="row">

                    <div class="col-lg-8 col-md-8">

                        <div class="section-title">

                            {!! $page->page_section !!}

                        </div>

                    </div>

                    <div class="col-lg-4 col-md-4">

                        <img class="img-fluid" src="images/rocketman.svg" alt="logo design service in sanjose">

                    </div>

                </div>

        </section>
        <section class="overflow-hidden">
          <div class="container">
              <div class="row align-items-center">
                  <div class="col-lg-5 col-md-12">
                      <div class="info-img position-relative">
                          <img class="img-fluid topBottom" src="images/about/seo-sec-2.jpg" alt="">
                      </div>
                  </div>
                  <div class="col-lg-7 col-md-12 mt-5 mt-lg-0">
                      <div class="section-title mb-4">
                          {!! $page->page_section_two !!}
                      </div>
                  </div>
              </div>
          </div>
      </section>




        <section class="light-bg" data-bg-img="images/bg/02.png">

            <div class="container">

                <div class="row justify-content-center text-center">

                    <div class="col-lg-9 col-md-12">

                        <div class="section-title">

                            <h2 class="title">Affordable SEO Packages</h2>

                            <p class="mb-0">It's a big step to get any business online, period. SEO can, at the same
                                time, emerge as one of the most vital constituents in that. Let us help you get started
                                with this experience our team has in entire search engine optimization! </p>

                        </div>

                    </div>

                </div>

                <div class="row">

                    <div class="col-md-12">

                        <div class="tab text-center">



                            <!-- Tab panes -->

                            <div class="tab-content px-0 pb-0" id="nav-tabContent">



                                <div role="tabpanel" class="tab-pane fade show active" id="tab1-1">

                                    <div class="row">

                                        @foreach ($data as $item)
                                            <div class="col-lg-4 col-md-12  mb-5">

                                                <div class="price-table">

                                                    <div class="round-p-animation"></div>

                                                    <div class="price-header">

                                                        <h3 class="price-title">{{ $item->name }}</h3>

                                                    </div>

                                                    <img class="img-fluid my-4" src="images/price/01.png"
                                                        alt="">

                                                    <div class="price-value">

                                                        <h2>${{ $item->price }}</h2>

                                                    </div>

                                                    <div class="price-list">

                                                        {!! $item->description !!}

                                                    </div>

                                                    <span type="button" class="btn btn-theme mt-5 getstarted"
                                                        data-toggle="modal" data-target="#modalform"
                                                        data-price="{{ $item->price }}"
                                                        data-packagename="{{ $item->name }}"
                                                        data-packageid="{{ $item->id }}" <span>Get Started</span>

                                                    </a>

                                                </div>

                                            </div>
                                        @endforeach

                                    </div>





                                </div>

                            </div>

                        </div>

                    </div>

                </div>

        </section>

        <?php $faqs = DB::table('faqs')
            ->where('page_slug', 'seo')
            ->get(); ?>
        @if ($faqs->count() > 0)
            <section class="faqs">
                <div class="container-fluid mt-5 mb-5">
                    <div class="row">
                        <div class="col-md-6 offset-md-3">
                            <div class="faq-title text-center pb-3">
                                <h2>FAQ</h2>
                            </div>
                        </div>
                        <div class="col-md-6 offset-md-3">
                            <div class="faq" id="accordion">

                                @foreach ($faqs as $faq)
                                    <div class="card mt-3">
                                        <div class="card-header" id="faqHeading-{{ $loop->iteration }}">
                                            <div class="mb-0">
                                                <h3 class="faq-title" data-toggle="collapse"
                                                    data-target="#faqCollapse-{{ $loop->iteration }}"
                                                    data-aria-expanded="true"
                                                    data-aria-controls="faqCollapse-{{ $loop->iteration }}">
                                                    <span
                                                        class="badge">{{ $loop->iteration }}</span>{{ $faq->title }}

                                                </h3>
                                            </div>
                                        </div>
                                        <div id="faqCollapse-{{ $loop->iteration }}" class="collapse"
                                            aria-labelledby="faqHeading-{{ $loop->iteration }}"
                                            data-parent="#accordion">
                                            <div class="card-body">
                                                <p>{!! $faq->remarks !!}</p>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach




                            </div>
                        </div>
                    </div>
                </div>
            </section>
        @endif

        @include('includes/counter')

        @include('includes/clientlogosection')

        @include('includes/testimonialsection')

        <!-- include blog -->

        @include('includes/footer')





    </div>



    @include('includes.popup')



    <!-- page wrapper end -->





    <!--back-to-top start-->



    <div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-upload"></i></a></div>



    <!--back-to-top end-->



    @include('includes/scripts')



</body>







</html>
