<!DOCTYPE html>
<html lang="en-US">


<head>
  @foreach ($pagedata as $page)
   
  @endforeach
  {{-- Seo Dynamic Links --}}
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>{{$page->seo_title}}</title>
  <meta name="description" content="{{$page->description}}">
  <meta name="robots" content="index,follow"> 
  <meta name="googlebot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1"> 
  <meta name="bingbot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1">
  <meta name="keywords" content="{{$page->seo_keywords}}">
  
  
  <link rel="canonical" href="{{$page->seo_url}}">
  <meta property="og:locale" content="en_US" />
  <meta property="og:type" content="website" />
  <meta property="og:title" content="{{$page->seo_title}}" />
  <meta property="og:description" content="{{$page->seo_keywords}}" />
  <meta property="og:url" content="{{$page->seo_url}}" />
  <meta property="og:site_name" content="<?php echo env('APP_NAME')?>" />
  <meta property="og:publish_date" name="publish_date" content="{{ date("F j, Y, g:i a", strtotime($page->seo_published_date)) }}" >
    
  
  <meta property="og:image" content="{{$page->seo_image}}" />
  <meta property="og:image:width" content="300" />
  <meta property="og:image:height" content="300" />
  
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="{{$page->seo_title}}" />
  <meta name="twitter:description" content="{{$page->seo_keywords}}" />
  <meta property="twitter:url" content="{{$page->seo_url}}" />
  <meta name="twitter:image" content="seo_image" />
  <meta name="twitter:creator" content="@<?php echo env('APP_NAME')?>" />
  <meta name="twitter:site" content="@<?php echo env('APP_NAME')?>" />
  <meta name="twitter:label1" content="Written by">
  <meta name="twitter:data1" content="<?php echo env('APP_NAME')?>">
  <meta name="twitter:label2" content="Est. reading time">
  <meta name="twitter:data2" content="4 minutes">

@include('includes.style')

</head>

<body>

<!-- page wrapper start -->

<div class="page-wrapper">

<!-- preloader start -->

<div id="ht-preloader">
  <div class="loader clear-loader">
    <div class="loader-text">Loading</div>
    <div class="loader-dots"> <span></span>
      <span></span>
      <span></span>
      <span></span>
    </div>
  </div>
</div>

<!-- preloader end -->

@include('includes.header')


<!--page title start-->

<section class="page-title overflow-hidden text-center light-bg bg-contain animatedBackground" data-bg-img="images/pattern/05.png">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-md-12">
        <h1 class="title">{{$page->page_name}}</h1>
        
      </div>
    </div>
  </div>
  <div class="page-title-pattern"><img class="img-fluid" src="images/bg/06.png" alt=""></div>
</section>

<!--page title end-->


<!--body content start-->

<div class="page-content">

<!--service start-->

<section class="overflow-hidden">
  <div class="container">
    <div class="row justify-content-center text-center">
      <div class="col-lg-8 col-md-12">
        <div class="section-title">
          <h6>{{$page->page_name}}</h6>
          <h2 class="title">{{$page->page_heading}}</h2> 
        </div>
      </div>
    </div>
    <div class="row">
      @foreach ($services as $item)
      <div class="col-lg-4 col-md-6 wow fadeInLeft mb-3" data-wow-duration="0.6">
        <div class="featured-item text-center style-2">
          <div class="featured-icon">
            <img class="img-fluid" src="{{$item->logo}}" alt="">
          </div>
          <div class="featured-title">
            <h5>{{$item->name}}</h5>
          </div>
          <div class="featured-desc">
            <p>{{$item->description}}</p>
          </div>
        </div>
      </div>
      @endforeach
    
    </div>
  </div>
</section>

<!--service end-->


<!--how it work start-->

<section class="position-relative bg-contain bg-pos-r pt-0 section_mb" data-bg-img="images/bg/02.png">
  <div class="container">
    <div class="row">
      <div class="col-lg-6 image-column bg-contain bg-pos-l" data-bg-img="images/pattern/07.png">
        <img class="img-fluid" src="images/about/01.png" alt="">
      </div>
      <div class="col-lg-6 col-md-12 ms-auto mt-5 mt-lg-0 ps-lg-5">
        <div class="section-title">
          <h6>Our Services For Entrepreneurs</h6>
          <h2 class="title">Our Digital Services have proven to be one-stop solution for customers.</h2> 
        </div>
        <div class="work-process style-2">
          <!-- <div class="work-process-inner"> <span class="step-num" data-bg-color="#cd113a">01</span> -->
            <!-- <h4>Research Project</h4> -->
            <p class="mb-0 text-black">SanJose Logo Design's digital services are designed to meet the needs of growing businesses. Everything from our prices to the way we deliver our services is tailored to the needs of your business.</p>
          <!-- </div> -->
        </div>
        <div class="work-process style-2 mt-5">
          <!-- <div class="work-process-inner"> <span class="step-num" data-bg-color="#cd113a">02</span> -->
            <!-- <h4>Project Targeting</h4> -->
            <p class="mb-0 text-black">When you have a specific plan, goal, and audience in mind, you are aligning your business for real success, but the most important part of success is using the right tools and services like the ones we offer at SanJose Logo Design.</p>
          <!-- </div> -->
        </div>
        <div class="work-process style-2 mt-5">
          <!-- <div class="work-process-inner"> <span class="step-num" data-bg-color="#cd113a">02</span> -->
            <!-- <h4>Project Targeting</h4> -->
            <p class="mb-0 text-black">If you are looking for the most profitable online marketing services for your business, look no further. <a href="contact.php">Contact us</a> today for a free quote.</p>
          <!-- </div> -->
        </div>
      </div>
    </div>
  </div>
</section>

<!--how it work end-->
@include('includes/counter');
@include('includes/clientlogosection');
@include('includes/testimonialsection');
@include('includes/blogsection');





</div>

<!--body content end--> 


@include('includes/footer');


</div>

<!-- page wrapper end -->


<!--back-to-top start-->

<div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-upload"></i></a></div>

<!--back-to-top end-->

 
@include('includes/scripts');

</body>



</html>