<!DOCTYPE html>
<html lang="en-US">


<head>
    <meta charset="utf-8">
    <meta name="keywords" content="Sanjose Logo Design - Thank You" />
    <meta name="description" content="Thank You" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        .alert-success {
            margin-bottom: 50px !important;
        }
    </style>

    <!-- Title -->
    <title>Sanjose Logo Design - Thank You</title>

    @include('includes.style')

</head>

<body>

    <!-- page wrapper start -->

    <div class="page-wrapper">

        <!-- preloader start -->

        <div id="ht-preloader">
            <div class="loader clear-loader">
                <div class="loader-text">Loading</div>
                <div class="loader-dots"> <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
            </div>
        </div>

        <!-- preloader end -->
        @include('includes/header')


        <!--page title start-->

        <section class="page-title overflow-hidden text-center light-bg bg-contain animatedBackground"
            data-bg-img="images/pattern/05.png">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <h1 class="title">Thank You !</h1>
                        @if (count($errors) > 0)
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-danger">
                                    {{ $error }}
                                </div>
                            @endforeach
                        @endif

                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif

                        @if (session('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="page-title-pattern"><img class="img-fluid" src="images/bg/06.png" alt=""></div>
        </section>

        <!--page title end-->


        <!--body content start-->

        <div class="page-content">

            <!--terms start-->



            <!--terms end-->

        </div>
        @include('includes/counter')
        @include('includes/clientlogosection')
        @include('includes/testimonialsection')
        @include('includes/blogsection')



        <!--body content end-->



        @include('includes/footer')


    </div>

    <!-- page wrapper end -->


    <!--back-to-top start-->

    <div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-upload"></i></a></div>

    <!--back-to-top end-->


    @include('includes/scripts')

</body>



</html>
