<!DOCTYPE html>
<html lang="en_us">

<head>
    <meta charset="utf-8">
    <meta name="keywords" content="Sanjose Logo Design - Thank You" />
    <meta name="description" content="Thank You" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Title -->
    <title><?php echo env('APP_NAME'); ?> - Website Brief</title>
    @include('includes.style')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <style>
        /*website-brief*/

        .tooltip .tooltiptext:after {
            position: absolute;
            content: "\f0d7 ";
            font-family: "Font Awesome 5";
            color: #000000;
            font-size: 20px;
            left: -12px;
            bottom: -12px;
            right: 0;
        }

        .files-upload input#fileToUpload {
            background: transparent;
            opacity: 0;
        }

        .files-upload {
            text-align: center;
            padding: 15px;
            border: 2px solid #f26622;
            background: #fff;
            border-radius: 0;
        }

        .m4-h h6>span {
            color: #f26622;
        }

        .m4-h h6 {
            font-size: 20px;
            color: #000;
            font-weight: 400;
            margin-bottom: 12px;
            text-transform: uppercase;
        }

        .pay-field input,
        .pay-field select,
        .pay-field textarea {
            border: 2px solid #f26622;
            background: transparent;
            width: 100%;
            height: 50px;
            color: #000;
            text-transform: lowercase;
            font-size: 14px;
            font-weight: 500;
            padding: 0 10px;
        }

        .pay-field input,
        .pay-field select,
        .pay-field textarea {
            text-transform: unset;
        }

        .pay-field textarea {
            height: 210px;
            resize: none;
            padding: 20px;
            line-height: normal;
            letter-spacing: 1px;
        }

        .wbb-brief .pay-field label {
            font-size: 20px;
        }

        .pay-field {
            margin-bottom: 30px;
        }

        .pay-field label {
            display: block;
            margin-bottom: 12px;
        }

        .m3-h h5,
        .m3-h h2 {
            font-size: 50px;
            color: #000;
            font-weight: 400;
            margin-bottom: 15px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .m3-h h5>span {
            color: #f26622;
        }

        .logo-sel.m4-h.pad-btmm {
            padding-bottom: 25px;
        }

        .tooltip .tooltiptext:after {
            position: absolute;
            content: "\f0d7 ";
            font-family: "Font Awesome 5";
            color: #000000;
            font-size: 20px;
            left: -12px;
            bottom: -10px;
            right: 0;
            font-weight: 800;
        }

        .doman.switch-field label {
            padding: 12px 24px;
        }

        .we-wrp {
            margin-bottom: 20px;
        }

        .we-wrp .pay-field.we-half {
            margin-bottom: 12px;
        }

        ul.ck-btn .form-group {
            display: block;
            margin-bottom: 15px;
        }

        ul.ck-btn .form-group input {
            padding: 0;
            height: initial;
            width: initial;
            margin-bottom: 0;
            display: none;
            cursor: pointer;
        }

        ul.ck-btn .form-group label {
            position: relative;
            cursor: pointer;
            font-weight: 500;
        }

        ul.ck-btn .form-group label:before {
            content: '';
            -webkit-appearance: none;
            background-color: transparent;
            border: 2px solid #f26622;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05), inset 0px -15px 10px -12px rgba(0, 0, 0, 0.05);
            padding: 10px;
            display: inline-block;
            position: relative;
            vertical-align: bottom;
            cursor: pointer;
            margin-right: 10px;
            border-radius: 5px;
        }

        ul.ck-btn .form-group input:checked+label:after {
            content: '';
            display: block;
            position: absolute;
            top: 7px;
            left: 7px;
            width: 9px;
            height: 9px;
            border: solid #f25a07;
            border-width: 0 10px 10px 0;
            /* transform:rotate(45deg);*/
        }

        ul.rg-ls {
            display: block;
            position: absolute;
            right: -14%;
            width: 100%;
        }

        ul.rg-ls>li {
            display: inline-block;
            margin-right: 18px;
            width: 11%;
        }

        ul.rg-ls>li:last-child {
            margin-right: 0;
        }

        .range-slider {
            margin-bottom: 26px;
        }

        .range-slider {
            width: 100%;
            position: relative;
        }

        .range-slider__range {
            -webkit-appearance: none;
            width: 80%;
            height: 10px;
            border-radius: 5px;
            background: #d7dcdf;
            outline: none;
            padding: 0;
            margin: 0;
        }

        .range-slider__range::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            background: #f26622;
            cursor: pointer;
            -webkit-transition: background 0.15s ease-in-out;
            transition: background 0.15s ease-in-out;
        }

        .range-slider__range::-webkit-slider-thumb:hover {
            background: #f26622;
        }

        .range-slider__range:active::-webkit-slider-thumb {
            background: #ffffff;
        }

        .range-slider__range::-moz-range-thumb {
            width: 20px;
            height: 20px;
            border: 0;
            border-radius: 50%;
            background: #2c3e50;
            cursor: pointer;
            -moz-transition: background 0.15s ease-in-out;
            transition: background 0.15s ease-in-out;
        }

        .range-slider__range::-moz-range-thumb:hover {
            background: #1abc9c;
        }

        .range-slider__range:active::-moz-range-thumb {
            background: #1abc9c;
        }

        .range-slider__range:focus::-webkit-slider-thumb {
            box-shadow: 0 0 0 3px #fff, 0 0 0 6px #f26622;
        }

        .range-slider__value {
            display: inline-block;
            position: relative;
            width: 10%;
            color: #f26622;
            line-height: 20px;
            text-align: center;
            border-radius: 3px;
            background: #ebebeb;
            padding: 13px 10px;
            margin-left: 8px;
            border: 2px solid #f26622;
            margin-right: 30px;
            border-radius: 10px;
        }

        .range-slider__value:after {
            position: absolute;
            top: 8px;
            left: -7px;
            width: 0;
            height: 0;
            border-top: 7px solid transparent;
        }

        ::-moz-range-track {
            background: #d7dcdf;
            border: 0;
        }

        input::-moz-focus-inner,
        input::-moz-focus-outer {
            border: 0;
        }

        .doman.switch-field {
            margin-bottom: 0;
            margin-top: 3px;
        }

        .files-upload img {
            margin-top: 8px;
            position: absolute;
        }

        .files-upload {
            position: relative;
        }

        section.wbb-brief.pad-btm {
            padding: 100px 0 20px;
        }

        .tooltip i {
            font-size: 16px;
            color: #f25a06;
        }

        .tooltip {
            position: relative;
            display: inline-block;
            border-bottom: 1px dotted black;
            opacity: 1;
            margin-left: 5px;
        }

        .tooltip .tooltiptext {
            visibility: hidden;
            width: 220px;
            background-color: #0a245d;
            color: #fff;
            text-align: center;
            border-radius: 6px;
            padding: 10px;
            /* Position the tooltip */
            position: absolute;
            z-index: 1;
            bottom: 132%;
            font-size: 12px;
            left: -37px;
            margin-left: -60px;
            font-family: sans-serif;
            text-transform: capitalize;
            line-height: 19px;
        }

        .tooltip:hover .tooltiptext {
            visibility: visible;
        }

        .wbb-brief .container {}

        .wbb-brief .payment-h {
            margin-bottom: 50px;
        }

        .wbb-brief .pay-field input::placeholder,
        .wbb-brief .pay-field textarea::placeholder {
            color: #949292;
            font-size: 12px;
            letter-spacing: 1px;
        }

        .wbb-brief .pay-field select {
            color: #949292;
        }

        .wbb-brief .pay-field input,
        .wbb-brief .pay-field select,
        .wbb-brief .pay-field textarea {
            letter-spacing: 2px;
            border-radius: 8px;
            background: #fff;
        }

        .pill-container {
            margin-bottom: 35px;
        }

        .pill-container input[type=checkbox] {
            opacity: 0;
            position: fixed;
            width: 0;
        }

        .pill-container {}

        .pill-container .selector:last-child {}

        .pill-container .selector {
            margin-left: 0 !important;
            margin-right: 10px;
            letter-spacing: 1.1px;
            color: #fff;
            align-items: center;
            justify-content: center;
            flex-grow: 1;
            cursor: pointer;
            background: #f26622;
            border: 2px solid #f26622;
            border: none;
            padding: 10px 10px;
            text-transform: uppercase;
            border-radius: 6px;
        }

        .selector:hover {
            background: #f26622;
            color: #fff;
            /* box-shadow:inset 0 0 5px 5px #f26622; */
        }

        .pill-container input[type=checkbox]:checked+label {
            background: #850612;
        }

        .w-h h5 {
            margin-bottom: 12px;
            text-transform: uppercase;
            font-size: 20px;
        }

        ul.yes-btn li {
            width: 100%;
        }

        ul.yes-btn>li .switch-field h3 {
            display: inline-block;
            margin-right: 25px;
            width: 85%;
        }

        .switch-field h3 {
            font-size: 17px;
            font-weight: 500;
            margin-bottom: 10px;
            text-transform: uppercase;
            line-height: 24px;
        }

        .switch-field {
            margin-bottom: 9px;
            /* overflow:hidden;*/
            font-size: 0;
        }

        .switch-field input {
            position: absolute !important;
            clip: rect(0, 0, 0, 0);
            height: 1px;
            width: 1px;
            border: 0;
            overflow: hidden;
        }

        .switch-field label {
            background-color: #ebebeb;
            color: #f26622;
            font-size: 14px;
            line-height: 1;
            text-align: center;
            padding: 8px 16px;
            margin-right: -8px;
            border: 1px solid #f26622;
            box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.3), 0 1px rgba(255, 255, 255, 0.1);
            transition: all 0.1s ease-in-out;
        }

        .switch-field label:hover {
            cursor: pointer;
        }

        .switch-field input:checked+label {
            background-color: #f26622;
            box-shadow: none;
            color: #fff;
        }

        .switch-field label:first-of-type {
            border-radius: 12px 0 0 12px;
        }

        .switch-field label:last-of-type {
            border-radius: 0 12px 12px 0;
        }

        ul.ck-btn {
            column-count: 5;
            padding: 10px 0px;
        }

        .clbx.w-h {
            margin-bottom: 30px;
        }

        ul.ck-btn input[type="checkbox"]:checked+label {
            background-color: transparent;
            color: #000;
        }

        ul.ck-btn label {
            text-transform: uppercase;
            font-size: 15px;
        }

        .wbb-brief .pay-field label {
            font-size: 20px;
        }

        ul.yes-btn {
            margin-bottom: 40px;
        }

        .tooltip {
            z-index: 107;
        }

        ul.ck-btn input[type="checkbox"]:checked+label {
            background-color: transparent;
            color: #f26622;
        }

        ul.ck-btn .form-group input:checked+label:after {
            content: '';
            display: block;
            position: absolute;
            top: 7px;
            left: 7px;
            width: 9px;
            height: 9px;
            border: solid #f26622;
            border-width: 0 10px 10px 0;
            /* transform: rotate(45deg); */
        }

        .m4-h h6 {
            font-size: 20px;
            color: #dc2a26;
            font-weight: 400;
            margin-bottom: 12px;
            text-transform: uppercase;
        }

        .logo-brief h5 {
            font-size: xx-large;
            font-weight: bold;
            padding-bottom: 2%;
        }

        .logo-brief h5>span,
        .logo-brief h6>span {
            color: #f26622;
        }

        @media screen and (max-width:1200px) {
            ul.ck-btn {
                column-count: 4;
            }
        }

        @media screen and (max-width:1024px) {
            ul.ck-btn {
                column-count: 3;
            }

            .main-service span.range-slider__value {
                display: block;
                margin: 0;
                width: 100%;
            }

        }

        @media screen and (max-width:768px) {
            ul.ck-btn {
                column-count: 2;
            }

            .files-upload img {
                position: unset;
            }
        }

        @media screen and (max-width:550px) {
            ul.ck-btn {
                column-count: 1;
            }

            ul.ck-btn li {
                display: block;
            }

            ul.rg-ls {
                right: -4px;

            }

            .range-slider__range {
                width: 100%;
            }

            ul.rg-ls>li {
                width: 7%;
            }

            .briefbutton {
                width: 100%;
            }
        }

        .pay-field input,
        .pay-field select,
        .pay-field textarea {
            border: 2px solid #f26622;
            background: transparent;
            width: 100%;
            height: 50px;
            color: black;
            font-size: 14px;
            font-weight: 500;
            padding: 0 10px;
        }

        .pay-field textarea {
            height: 210px;
            resize: none;
            padding: 20px;
            line-height: normal;
            letter-spacing: 1px;
        }

        ul {
            list-style: none;
        }

        .text-danger {
            color: #dc3545 !important;
            font-style: italic;
            font-weight: 500;
        }

        .fb-customerchat.fb_invisible_flow.fb_iframe_widget span iframe {
            left: 0px !important;
            right: auto !important;
        }

        .fb_dialog_content iframe {
            left: 0px !important;
        }

        .files-upload {
            position: relative;
        }

        .files-upload {
            text-align: center;
            padding: 15px;
            background: #fff;
            border-radius: 0;
            min-height: 165px;
        }

        .preview-image-container {
            display: inline-block;
            padding: 6px;
            position: relative;
            width: 9.6%;
            height: 120px;
        }

        img.preview-image {
            object-fit: cover;
            border-radius: 10px;
            top: 0;
            left: 0;
            width: -webkit-fill-available;
            position: absolute;
            border: 4px solid #fff;
            height: -webkit-fill-available;
        }

        div#imagespreview {
            display: block;
            background: transparent;
        }

        button.delete-button {
            position: absolute;
            right: 6px;
            font-size: 13px;
            border: 0px;
            height: 1.5rem;
            top: 14px;
            border-radius: 100%;
            width: 1.5rem;
            background: #f26622;
            color: #ffffff;
            font-weight: 600;
            z-index: 999;
        }

        /*website-brief*/
    </style>
</head>

<body class="dark-main f-weight active-dark">
    <!-- page wrapper start -->
    <div class="page-wrapper">
        <!-- preloader start -->
        <!-- preloader end -->
        @include('includes/header')
        <!--page title start-->
        <section class="page-title overflow-hidden text-center light-bg bg-contain animatedBackground" data-bg-img="images/pattern/05.png" style="background-image: url(&quot;images/pattern/05.png&quot;);">

            <div class="container">

                <div class="row align-items-center">

                    <div class="col-md-12">

                        <h1 class="title">Website Brief</h1>



                    </div>

                </div>

            </div>



        </section>
        <section class="pt-5 bg-white border-0 logo-brief">
            <div class="container mt-5">
                <div class="pill-container w-h mt-5">
                    <h1><strong>Fill Your <span style="color: #f25a07;">Website Brief</span></strong></h1>
                </div>
                <div class="ban-con">
                    <form action="/add-website-brief" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="we-wrp">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <div class="pay-field we-half">
                                        <label>
                                            Your Name?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext"></span>
                                            </div>
                                        </label>
                                        <input type="text" name="name" id="name" value="{{ old('name') }}" placeholder="Your Name">
                                        @if ($errors->has('name'))
                                        <small class="text-danger">{{ $errors->first('name') }}</small>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="pay-field we-half">
                                        <label>
                                            Your Email Address?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">(A unique name that you have decided for your
                                                    business.) </span>
                                            </div>
                                        </label>
                                        <input type="text" name="email" id="email" value="{{ old('email') }}" placeholder="Your Email Address">
                                        @if ($errors->has('email'))
                                        <small class="text-danger">{{ $errors->first('email') }}</small>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="pay-field we-half">
                                        <label>
                                            What is your Business Name?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">(A unique name that you have decided for your
                                                    business.) </span>
                                            </div>
                                        </label>
                                        <input type="text" name="business_name" id="business_name" value="{{ old('business_name') }}" placeholder="Business Name">

                                        @if ($errors->has('business_name'))
                                        <small class="text-danger">{{ $errors->first('business_name') }}</small>
                                        @endif
                                    </div>
                                </div>
                                <!-- <div class="col-md-6">
                                    <div class="pay-field we-half">
                                        <label>
                                            What is the type of your website?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (There are several types of websites based upon your audience
                                                    requirement and your concept. There is a different type of website
                                                    for product selling, and a different website which is information/
                                                    appointment or subscription based. Select one from the dropdown)
                                                </span>
                                            </div>
                                        </label>
                                        <select id="type_website" name="type_website">
                                            <option value="Informative" {{ old('type_website') == 'Informative' ? 'selected' : '' }}>Informative
                                            </option>
                                            <option value="E-commerce" {{ old('type_website') == 'E-commerce' ? 'selected' : '' }}>E-commerce
                                            </option>
                                            <option value="Marketplace" {{ old('type_website') == 'Marketplace' ? 'selected' : '' }}>Marketplace
                                            </option>
                                            <option value="Web App" {{ old('type_website') == 'Web App' ? 'selected' : '' }}>Web-App
                                            </option>
                                        </select>
                                        @if ($errors->has('type_website'))
                                        <small class="text-danger">{{ $errors->first('type_website') }}</small>
                                        @endif
                                    </div>
                                </div> -->


                                <div class="col-md-6">
                                    <div class="pay-field">
                                        <label>
                                            What is the type of your website?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (What is your business about? Where you got the idea, how big is your business?
                                                    These are some of the questions which you can provide details upon. The more
                                                    information you give the better user experience we bring)
                                                </span>
                                            </div>
                                        </label>
                                        <select name="type_website" id="typeofwebsite">
                                            <option selected disabled>Select type of your website</option>
                                            <option value="1">Informative (with-out payment integration)</option>
                                            <option value="2">Informative (with payment integration to sell services)</option>
                                            <option value="3">E-commerce (Products upload with payment Integration)</option>
                                            <option value="4">Web App (With Custom Dashboard)</option>
                                        </select>
                                        @if ($errors->has('business_description'))
                                        <small class="text-danger">{{ $errors->first('business_description') }}</small>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="we-wrp">
                            <div class="row">
                                <!-- Fields for option 1 -->
                                <div class="col-md-12" id="option1Fields" style="display: none;">
                                    <div class="pay-field">
                                        <label for="numProducts">
                                            How many products would you like to showcase in your website?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">(Provide the number of products you want to showcase on your website)</span>
                                            </div>
                                        </label>
                                        <input type="text" name="numProducts" id="numProducts">
                                    </div>

                                    <div class="pay-field">
                                        <label for="numServices">
                                            How many services would you like to showcase in your website?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">(Provide the number of services you want to showcase on your website)</span>
                                            </div>
                                        </label>
                                        <input type="text" name="numServices" id="numServices">
                                    </div>

                                    <div class="pay-field">
                                        <label for="futureImages">
                                            Would you like to add images or products in your website in the future?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">(Indicate if you plan to add more images or products in the future)</span>
                                            </div>
                                        </label>
                                        <input type="text" name="futureImages" id="futureImages">
                                    </div>
                                </div>

                                <!-- Fields for option 2 -->
                                <div class="col-md-12" id="option2Fields" style="display: none;">
                                    <div class="pay-field">
                                        <label for="numServicesOption2">
                                            How many services would you like to have in your website? Do you have prices ready for the services?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (Provide information about the number of services you want to showcase and whether you have prices ready)
                                                </span>
                                            </div>
                                        </label>
                                        <input type="text" name="numServicesOption2" id="numServicesOption2">
                                    </div>

                                    <div class="pay-field">
                                        <label for="acceptOnlinePayments">
                                            Would you accept online payments? What will be the medium of accepting payments?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (Indicate whether you accept online payments and provide details about the medium of accepting payments)
                                                </span>
                                            </div>
                                        </label>
                                        <input type="text" name="acceptOnlinePayments" id="acceptOnlinePayments">
                                    </div>

                                    <div class="pay-field">
                                        <label for="futureImagesOption2">
                                            Would you like to add images or services in your website in the future?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (Indicate if you plan to add more images or services in the future)
                                                </span>
                                            </div>
                                        </label>
                                        <input type="text" name="futureImagesOption2" id="futureImagesOption2">
                                    </div>
                                </div>

                                <!-- Fields for option 3 -->
                                <div class="col-md-12" id="option3Fields" style="display: none;">
                                    <div class="pay-field">
                                        <label for="platformRequired">
                                            What platform do you require for the website? WordPress, Shopify, Wix, SquareSpace, Custom CMS
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (Specify the platform you want for your website, e.g., WordPress, Shopify, Wix, SquareSpace, Custom CMS)
                                                </span>
                                            </div>
                                        </label>
                                        <input type="text" name="platformRequired" id="platformRequired">
                                    </div>

                                    <div class="pay-field">
                                        <label for="numCategories">
                                            How many categories would you like to have for your products?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (Specify the number of categories you want for your products)
                                                </span>
                                            </div>
                                        </label>
                                        <input type="text" name="numCategories" id="numCategories">
                                    </div>

                                    <div class="pay-field">
                                        <label for="numProductsOption3">
                                            How many products would you like to have in your website?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (Specify the number of products you want for your website)
                                                </span>
                                            </div>
                                        </label>
                                        <input type="text" name="numProductsOption3" id="numProductsOption3">
                                    </div>

                                    <div class="pay-field">
                                        <label for="productSource">
                                            Do you currently have the product, or is there a need to acquire it from a source?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (Indicate whether you currently have the product or need to acquire it from a source)
                                                </span>
                                            </div>
                                        </label>
                                        <input type="text" name="productSource" id="productSource">
                                    </div>

                                    <div class="pay-field">
                                        <label for="acceptOnlinePaymentsOption3">
                                            Would you accept online payments? What will be the medium of accepting payments?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (Indicate whether you accept online payments and provide details about the medium of accepting payments)
                                                </span>
                                            </div>
                                        </label>
                                        <input type="text" name="acceptOnlinePaymentsOption3" id="acceptOnlinePaymentsOption3">
                                    </div>

                                    <div class="pay-field">
                                        <label for="futureImagesOption3">
                                            Would you like to add images or products in your website in the future?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (Indicate if you plan to add more images or products in the future)
                                                </span>
                                            </div>
                                        </label>
                                        <input type="text" name="futureImagesOption3" id="futureImagesOption3">
                                    </div>
                                </div>

                                <div class="col-md-12" id="option4Fields" style="display: none;">
                                    <div class="pay-field">
                                        <label for="platformRequired">
                                            What platform do you require for the website? Laravel, React Js, Custom CMS
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (Specify the platform you want for your website, e.g., Laravel, React,  Custom CMS, SquareSpace)
                                                </span>
                                            </div>
                                        </label>
                                        <input type="text" name="platformRequiredWeb" id="platformRequired">
                                    </div>

                                    <div class="pay-field">
                                        <label for="acceptOnlinePayments">
                                            Would you accept online payments? What will be the medium of accepting payments?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">
                                                    (Indicate whether you accept online payments and provide details about the medium of accepting payments)
                                                </span>
                                            </div>
                                        </label>
                                        <input type="text" name="acceptOnlinePaymentsWebApp" id="acceptOnlinePayments">
                                    </div>
                                
                                </div>
                            </div>
                        </div>

                      
                        <div class="row">
                            <div class="col-md-12">
                                <div class="pay-field">
                                <label>
                                    Description of your business?
                                    <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                        <span class="tooltiptext">
                                            (What is your business about? Where you got the idea, how big is your business?
                                            These are some of the questions which you can provide details upon. The more
                                            information you give the better user experience we bring)
                                        </span>
                                    </div>
                                </label>
                                <textarea name="business_description" id="business_description" placeholder="Describe what is your business overhere">{{ old('business_description') }}</textarea>
                                @if ($errors->has('business_description'))
                                <small class="text-danger">{{ $errors->first('business_description') }}</small>
                                @endif
                            </div>
                            </div>
                        </div>

                 
                    






                        <div class="we-wrp">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="pay-field we-half">
                                        <label>
                                            What is your Business Industry?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">(What industry does your business belong to?
                                                    Healthcare, Marketing, Real-estate, Education, IT, etc..) </span>
                                            </div>
                                        </label>
                                        <input type="text" name="business_industry" value="{{ old('business_industry') }}" id="business_industry" placeholder="Mention your Business Industry">

                                        @if ($errors->has('business_industry'))
                                        <small class="text-danger">{{ $errors->first('business_industry') }}</small>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="pay-field we-half">
                                        <label>
                                            Who is your Target Audience?
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">(Based on your business tell us who you are
                                                    targeting, your target website visitors can be infants, teenagers,
                                                    adults, senior citizens or everyone) </span>
                                            </div>
                                        </label>
                                        <input type="text" name="target_audience" value="{{ old('target_audience') }}" id="target_audience" placeholder="Mention your targeted Audience">

                                        @if ($errors->has('target_audience'))
                                        <small class="text-danger">{{ $errors->first('target_audience') }}</small>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="pill-container w-h mt-5">
                            <h5 class="theme-text">
                                <strong>What type of overall feel you want?</strong>
                                <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                    <span class="tooltiptext">(Tell us how you want your website to feel like, this
                                        will
                                        help us to design a suitable layout for your website visitors)</span>
                                </div>
                            </h5>
                            <input type="checkbox" id="option-a" name="selector[]" value="Corporate" {{ in_array('Corporate', old('selector', [])) ? 'checked' : '' }}>
                            <label class="selector option-a" for="option-a"> Corporate </label>

                            <input type="checkbox" id="option-b" name="selector[]" value="Fun" {{ in_array('Fun', old('selector', [])) ? 'checked' : '' }}>
                            <label class="selector" for="option-b">Fun</label>

                            <input type="checkbox" id="option-c" name="selector[]" value="Trendy" {{ in_array('Trendy', old('selector', [])) ? 'checked' : '' }}>
                            <label class="selector" for="option-c">Trendy</label>

                            <input type="checkbox" id="option-d" name="selector[]" value="Friendly" {{ in_array('Friendly', old('selector', [])) ? 'checked' : '' }}>
                            <label class="selector" for="option-d">Friendly</label>

                            <input type="checkbox" id="option-e" name="selector[]" value="HI-tec" {{ in_array('HI-tec', old('selector', [])) ? 'checked' : '' }}>
                            <label class="selector" for="option-e">HI-tec</label>

                            <input type="checkbox" id="option-f" name="selector[]" value="Minimal" {{ in_array('Minimal', old('selector', [])) ? 'checked' : '' }}>
                            <label class="selector" for="option-f">Minimal</label>

                            <input type="checkbox" id="option-g" name="selector[]" value="Dark" {{ in_array('Dark', old('selector', [])) ? 'checked' : '' }}>
                            <label class="selector" for="option-g">Dark</label>

                            <input type="checkbox" id="option-h" name="selector[]" value="Light" {{ in_array('Light', old('selector', [])) ? 'checked' : '' }}>
                            <label class="selector" for="option-h">Light</label>
                        </div>
                        <div class="we-wrp">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="pay-field we-half">
                                        <label>
                                            Kindly provide competitors or refrence websites
                                            <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <span class="tooltiptext">(Give us an idea about how your competitors
                                                    are doing, you can provide us with the link/ URL for the reference
                                                    websites too.) </span>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="pay-field we-half">
                                        <input type="text" name="competitor1" value="{{ old('competitor1') }}" id="competitor1" placeholder="mention competitor/ref web">
                                        @if ($errors->has('competitor1'))
                                        <small class="text-danger">{{ $errors->first('competitor1') }}</small>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="pay-field we-half">
                                        <input type="text" name="competitor2" value="{{ old('competitor2') }}" id="competitor2" placeholder="mention competitor/ref web">
                                        @if ($errors->has('competitor2'))
                                        <small class="text-danger">{{ $errors->first('competitor2') }}</small>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="pay-field we-half">
                                        <input type="text" name="competitor3" value="{{ old('competitor3') }}" id="competitor3" placeholder="mention competitor/ref web">
                                        @if ($errors->has('competitor3'))
                                        <small class="text-danger">{{ $errors->first('competitor3') }}</small>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="pay-field">
                            <label>
                                Do you have a Domain Address?
                                <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                    <span class="tooltiptext">(A domain name is a unique (www) address used for
                                        websites, such as www.google.com) </span>
                                </div>
                            </label>
                        </div>
                        <div class="domian-wrp">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="doman switch-field">
                                        <input type="radio" id="radio-111" name="domain_address" value="yes">
                                        <label for="radio-111">Yes</label>
                                        <input type="radio" id="radio-122" name="domain_address" value="no" checked="">
                                        <label for="radio-122">No</label>
                                    </div>
                                </div>
                                <div class="col-md-10">
                                    <div class="pay-field">
                                        <input type="text" name="domain_name" value="{{ old('domain_name') }}" placeholder="Enter your Domain">
                                        @if ($errors->has('domain_name'))
                                        <small class="text-danger">{{ $errors->first('domain_name') }}</small>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="r pay-field">
                            <label>
                                how many number of pages you want
                                <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                    <span class="tooltiptext">(You can choose the number of pages your website
                                        requires, Please make a selection based on the purchased package) </span>
                                </div>
                            </label>
                        </div>
                        <div class="domian-wrp">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="rwant">
                                        <div class="range-slider">
                                            <span class="range-slider__value">{{ old('number_of_pages') ?? 1 }}</span>
                                            <input class="range-slider__range" type="range" name="number_of_pages" value="{{ old('number_of_pages') ?? 1 }}" min="1" max="25" style="background: linear-gradient(90deg, rgb(127 42 129) 72%, rgb(215, 220, 223) 72.1%) !important;">

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
                <div class="pay-field">
                    <label>
                        What pages would you like in your website, Please name them here ?
                        <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                            <span class="tooltiptext">(Every website have different pages, Home, About Us, Gallery,
                                Contact Us, etc) </span>
                        </div>
                    </label>
                    <textarea name="pages_name" placeholder="i.e: Home, About US, Contact US">{{ old('pages_name') }}</textarea>
                    @if ($errors->has('pages_name'))
                    <small class="text-danger">{{ $errors->first('pages_name') }}</small>
                    @endif
                </div>
                <ul class="yes-btn">
                    <li class="first">
                        <div class="switch-field">
                            <h3 style="font-size: 15px;font-weight: 500;"><strong>Do you have a website Logo?</strong>
                                <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                    <span class="tooltiptext">(Any existing logo which is already in use by your
                                        company can be provided to us) </span>
                                </div>
                            </h3>
                            <input type="radio" id="radio-11" name="already_logo" value="Logo: yes" {{ old('already_logo') == 'Logo: yes' ? 'checked' : '' }}>
                            <label for="radio-11">Yes</label>

                            <input type="radio" id="radio-12" name="already_logo" value="Logo: no" {{ old('already_logo', 'Logo: no') == 'Logo: no' ? 'checked' : '' }}>
                            <label for="radio-12">No</label>
                            @error('already_logo')
                            <div class="error">{{ $message }}</div>
                            @enderror

                        </div>
                    </li>
                    <li>
                        <div class="switch-field">
                            <h3 style="font-size: 15px;font-weight: 500;"><strong>
                                    would you like us to revamp your Logo?</strong>
                                <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                    <span class="tooltiptext">(Revamping, furbishing and polishing your existing logo
                                        can be done to match your website layout but with additional charges) </span>
                                </div>
                            </h3>
                            <input type="radio" id="radio-13" name="revamp_logo" value="Revamp: yes" {{ old('revamp_logo') == 'Revamp: yes' ? 'checked' : '' }}>
                            <label for="radio-13">Yes</label>

                            <input type="radio" id="radio-14" name="revamp_logo" value="Revamp: no" {{ old('revamp_logo', 'Revamp: no') == 'Revamp: no' ? 'checked' : '' }}>
                            <label for="radio-14">No</label>

                            @error('revamp_logo')
                            <div class="error">{{ $message }}</div>
                            @enderror
                        </div>
                    </li>
                    <li>
                        <div class="switch-field">
                            <h3 style="font-size: 15px;font-weight: 500;"><strong>
                                    Do you need a website Hosting server?</strong>
                                <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                                    <span class="tooltiptext">(A web hosting server is an Internet Storage Server with
                                        complete Web Server functioning and resources) </span>
                                </div>
                            </h3>
                            <input type="radio" id="radio-15" name="hosting_server" value="Website Hosting: yes" {{ old('hosting_server') == 'Website Hosting: yes' ? 'checked' : '' }}>
                            <label for="radio-15">Yes</label>

                            <input type="radio" id="radio-16" name="hosting_server" value="Website Hosting: no" {{ old('hosting_server', 'Website Hosting: no') == 'Website Hosting: no' ? 'checked' : '' }}>
                            <label for="radio-16">No</label>

                            @error('hosting_server')
                            <div class="error">{{ $message }}</div>
                            @enderror
                        </div>
                    </li>
                    <li>
                        <div class="switch-field">
                            <h3 style="font-size: 15px;font-weight: 500;"><strong>Do you need smartphone responsive
                                    website?<strong></h3>
                            <input type="radio" id="radio-17" name="responsive_website" value="Mobile Responsive: yes" {{ old('responsive_website') == 'Mobile Responsive: yes' ? 'checked' : '' }}>
                            <label for="radio-17">Yes</label>

                            <input type="radio" id="radio-18" name="responsive_website" value="Mobile Responsive: no" {{ old('responsive_website', 'Mobile Responsive: no') == 'Mobile Responsive: no' ? 'checked' : '' }}>
                            <label for="radio-18">No</label>

                            @error('responsive_website')
                            <div class="error">{{ $message }}</div>
                            @enderror
                        </div>
                    </li>
                </ul>
                <div class="clbx w-h mt-5">
                    <h5 class="theme-text">
                        <strong>Addon Features:</strong>
                        <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                            <span class="tooltiptext">(Add-on or extra features to enhance liveliness of your website,
                                to attract and engage audience and to make it secure) </span>
                        </div>
                    </h5>
                    <ul class="ck-btn">
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="chat" name="websitefeatures[]" value="Chat integration" {{ in_array('Chat integration', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="chat">Chat integration</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="Custom_Dashboard" name="websitefeatures[]" value="Custom Dashboard" {{ in_array('Custom Dashboard', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="Custom_Dashboard">Custom Dashboard</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="Database" name="websitefeatures[]" value="Database" {{ in_array('Database', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="Database">Database</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="Hover_effects" name="websitefeatures[]" value="Hover effects" {{ in_array('Hover effects', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="Hover_effects">Hover effects</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="security_Encryption" name="websitefeatures[]" value="Security Encryption" {{ in_array('Security Encryption', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="security_Encryption">Security Encryption</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="Sign_upin" name="websitefeatures[]" value="Sign up/Sign in" {{ in_array('Sign up/Sign in', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="Sign_upin">Sign up/Sign in</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="Newsletter" name="websitefeatures[]" value="Newsletter" {{ in_array('Newsletter', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="Newsletter">Newsletter</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="Website_Content" name="websitefeatures[]" value="Website Content" {{ in_array('Website Content', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="Website_Content">Website Content</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="SSl_Certification" name="websitefeatures[]" value="SSl Certification" {{ in_array('SSl Certification', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="SSl_Certification">SSl Certification</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="Custom_forms" name="websitefeatures[]" value="Custom forms" {{ in_array('Custom forms', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="Custom_forms">Custom forms</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="Social_mediaFeed" name="websitefeatures[]" value="Social media Feed" {{ in_array('Social media Feed', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="Social_mediaFeed">Social media Feed</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="SEO_Optimization" name="websitefeatures[]" value="SEO Optimization" {{ in_array('SEO Optimization', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="SEO_Optimization">SEO Optimization</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="Ada_compliance" name="websitefeatures[]" value="Ada compliance" {{ in_array('Ada compliance', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="Ada_compliance">Ada compliance</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="Blogs" name="websitefeatures[]" value="Blogs" {{ in_array('Blogs', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="Blogs">Blogs</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="thirdparty" name="websitefeatures[]" value="3rd Party API" {{ in_array('3rd Party API', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="thirdparty">3rd Party API</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="Digital_marketing" name="websitefeatures[]" value="Digital marketing" {{ in_array('Digital marketing', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="Digital_marketing">Digital marketing</label>
                            </div>
                        </li>
                        <li>
                            <div class="form-group">
                                <input type="checkbox" id="Videos_Animations" name="websitefeatures[]" value="Videos & Animations" {{ in_array('Videos & Animations', old('websitefeatures', [])) ? 'checked' : '' }}>
                                <label for="Videos_Animations">Videos & Animations</label>
                            </div>
                        </li>
                    </ul>

                    @error('websitefeatures')
                    <div class="error">{{ $message }}</div>
                    @enderror
                </div>
                <div class="logo-sel m4-h pad-btmm">
                    <h6 class="theme-text">
                        <strong>Upload Your Reference File <small>(you can add multiple files)</small></strong>
                        <div class="tooltip"><i class="fa fa-info-circle" aria-hidden="true"></i>
                            <span class="tooltiptext">(Any draft content, or design files that you want us to go
                                through can be uploaded here.) </span>
                        </div>
                    </h6>
                    <div class="form-group files-upload">
                        <div id="imagespreview">
                        </div>

                        <label id="fileToUpload" style="z-index: 1;position: absolute;width: 100%;top: 33px;transform: translate(-50%, -50%);">
                            <img id="uploadicon" src="<?php echo env('APP_URL'); ?>images/logo-brief/upload.png" />
                        </label>
                        <input type="file" multiple name="fileToUpload[]" id="fileToUploadImage" style="display:none" class="form-control">
                    </div>
                </div>
                <div class="pay-field py-btn">
                    <button type="submit" name="submit" class="btn p-3" style="background: #f26622; color:white" value="main-service">Submit Your Brief</button>
                </div>
                </form>
            </div>
    </div>
    </section>
        @include('includes/footer')
    </div>
    <!-- page wrapper end -->
    <!--back-to-top start-->
    <div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-upload"></i></a></div>
    <!--back-to-top end-->
    @include('includes/scripts')
    <script>
$(document).ready(function() {
            $('#typeofwebsite').change(function() {
                // Hide all option-specific fields
                $('#option1Fields, #option2Fields, #option3Fields').hide();

                // Show the fields corresponding to the selected option
                var selectedOption = $(this).val();
                $('#option' + selectedOption + 'Fields').show();
            });
        });


        const fileInput = document.getElementById('fileToUploadImage');
        const imagePreview = document.getElementById('imagespreview');

        $('#fileToUpload').click(function() {
            $('#fileToUploadImage').click();
        });

        fileInput.addEventListener('change', function() {
            const files = fileInput.files;
            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                const reader = new FileReader();

                reader.onload = function(event) {
                    const imgContainer = document.createElement('div'); // Create a container for each image
                    imgContainer.classList.add('preview-image-container');

                    const img = document.createElement('img');
                    img.src = event.target.result;
                    img.classList.add('preview-image');

                    const deleteButton = document.createElement('button');
                    deleteButton.innerText = 'x';
                    deleteButton.classList.add('delete-button');

                    deleteButton.addEventListener('click', function() {
                        imgContainer
                            .remove(); // Remove the image container when the delete button is clicked
                    });

                    imgContainer.appendChild(img);
                    imgContainer.appendChild(deleteButton);

                    imagePreview.appendChild(imgContainer);
                }

                reader.readAsDataURL(file);
            }
        });
    </script>
</body>

</html>