<!DOCTYPE html>
<html lang="en-US">

<head>
    @foreach ($pagedata as $page)
    @endforeach
    {{-- Seo Dynamic Links --}}
    <meta charset="UTF-8">
    <meta name="viewport"
        content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $page->seo_title }}</title>
    <meta name="description" content="{{ $page->description }}">
    <meta name="robots" content="index,follow">
    <meta name="googlebot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1">
    <meta name="bingbot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1">
    <meta name="keywords" content="{{ $page->seo_keywords }}">
    <link rel="canonical" href="{{ $page->seo_url }}">
    <meta property="og:locale" content="en_US" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="{{ $page->seo_title }}" />
    <meta property="og:description" content="{{ $page->description }}" />
    <meta property="og:url" content="{{ $page->seo_url }}" />
    <meta property="og:site_name" content="<?php echo env('APP_NAME'); ?>" />
    <meta property="og:publish_date" name="publish_date"
        content="{{ date('F j, Y, g:i a', strtotime($page->seo_published_date)) }}">
    <meta property="og:image" content="{{ $page->seo_image }}" />
    <meta property="og:image:width" content="300" />
    <meta property="og:image:height" content="300" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="{{ $page->seo_title }}" />
    <meta name="twitter:description" content="{{ $page->description }}" />
    <meta property="twitter:url" content="{{ $page->seo_url }}" />
    <meta name="twitter:image" content="seo_image" />
    <meta name="twitter:creator" content="@<?php echo env('APP_NAME'); ?>" />
    <meta name="twitter:site" content="@<?php echo env('APP_NAME'); ?>" />
    <meta name="twitter:label1" content="Written by">
    <meta name="twitter:data1" content="<?php echo env('APP_NAME'); ?>">
    <meta name="twitter:label2" content="Est. reading time">
    <meta name="twitter:data2" content="4 minutes">
    <link rel="stylesheet" type="text/css" href="{{ asset('css/style.css') }}">
    @include('includes.style')
    
    <style>
        .fullscreen-banner h1 {
            font-size: 50px;
            line-height: 56px;
        }
        
        
        .logogenertagorm {
            padding: 38px 30px;
            border-radius: 12px;
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.2);
            display: flex;
            align-items: center;
            gap: 10px;
            width: 100%;
            background-image: url(/images/banner_bg.png);
            background-position: center;
            background-size: cover;
            background-color: #00000059;
            background-blend-mode: color;
        }
    
        .logogenertagorm input {
          flex: 0 0 75%;
          padding: 12px 14px;
          border: none;
          outline: none;
          border-radius: 8px;
          font-size: 16px;
          background: rgba(255, 255, 255, 0.8);
          color: #000;
        }
        
        .logogenertagorm input::placeholder {
            color: #000;
        }
        
        .logogenertagorm button {
          flex: 0 0 25%;
        }
    </style>


</head>

<body>

    <!-- page wrapper start -->

    <div class="page-wrapper">

        <!-- preloader start -->

        <div id="ht-preloader">
            <div class="loader clear-loader">
                <div class="loader-text">Loading</div>
                <div class="loader-dots"> <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
            </div>
        </div>

        <!-- preloader end -->


        @include('includes.header')
        <!--hero section start-->

        <section class="fullscreen-banner p-0 banner overflow-hidden" data-bg-img="images/pattern/01.png">
            <div class="insideText">Sanjose Logo Design</div>
            <div class="align-center">
                <div class="container">
                    <div class="row align-items-center justify-content-center text-center">
                    <!--    <div class="col-lg-5 col-md-12 order-lg-1 position-relative">-->
                    <!--        <div class="mouse-parallax">-->
                    <!--            <div class="bnr-img1 animated fadeInRight delay-4 duration-4">-->
                    <!--                <img class="img-fluid rotateme" src="images/banner/01.png" alt="">-->
                    <!--            </div>-->
                    <!--            <img class="img-fluid bnr-img2 animated zoomIn delay-5-->
                    <!--duration-4"-->
                    <!--                src="images/banner/02.png" alt="">-->
                    <!--        </div>-->
                    <!--    </div>-->

                        <div class="col-lg-10 mt-5 mt-lg-0">

                            {!! $page->page_section !!}
                            
                            <form class="logogenertagorm" action="/logo-form" method="GET">
                                <input type="text" name="name" placeholder="Enter your Business Name" required>
                                <button type="submit" class="btn btn-theme col-md-5">Get Started</button>
                            </form>


                            
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="overflow-hidden">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="info-img position-relative">
                            <video class="video-fluid" autoplay muted loop>
                                <source src="images/video-1.mp4" type="video/mp4">
                            </video>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 mt-5 mt-lg-0">
                        <div class="section-title mb-4">
                            <h2 class="title">Expert Brand Strategy & Creative Agency San Jose</h2>
                            <p class="mb-0 text-black">Our <strong>creative agency in San Jose</strong> also offers
                                comprehensive <strong>brand development services</strong>. We understand the importance
                                of a strong brand presence, and our expert team works closely with you to develop a
                                brand strategy that aligns with your business goals. Whether you need a new logo,
                                website design, or overall <strong>brand strategy in San Jose</strong>, we are here to
                                help.</p>
                            <p class="mb-0 text-black mt-3">Speaking of websites, our <strong>web agency in San
                                    Jose</strong> excels in creating visually appealing and user-friendly websites. We
                                understand that a well-designed website is crucial for capturing the attention of your
                                target audience and driving conversions. Our team combines creativity and technical
                                expertise to deliver exceptional website design and development solutions tailored to
                                your specific needs.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--hero section end-->


        <!--body content start-->

        <div class="page-content">

            <!--service start-->

            <section class="light-bg position-relative text-center">
                <div class="pattern-3">
                    <img class="img-fluid rotateme" src="images/pattern/03.png" alt="">
                </div>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-8 col-md-12 mx-auto">
                            <div class="section-title">
                                <h6>Service</h6>
                                <h2 class="title">We're Providing Best Digital Design Services!</h2>
                            </div>
                        </div>
                    </div>
                    @include('includes.services')
                </div>
            </section>

            <!--service end-->

            <!--about start-->

            <section class="position-relative">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-5 image-column bg-contain bg-pos-l" data-bg-img="images/pattern/07.png">
                            <div class="round-animation">
                                <img class="img-fluid" src="images/about/01.png" alt="">
                            </div>
                        </div>
                        <div class="col-lg-7 col-md-12 ms-auto mt-5 mt-lg-0">
                            <div class="section-title mb-4">
                                <h6>About Us</h6>
                                <h2 class="title text-capitalize">Top Brand Development & SEO Company San Jose </h2>
                            </div>
                            <ul class="list-unstyled list-icon-3">
                                <li class="mb-2">As a leading branding and digital marketing agency in San Jose, we
                                    offer a wide range of services to help your business thrive. Our team of
                                    professionals specializes in social media marketing, brand marketing, and digital
                                    advertising. We develop customized strategies to enhance your online presence and
                                    effectively engage with your target audience.</li>
                                <li class="mb-2 mt-3">Partner with our top creative marketing agency in San Jose, and
                                    you'll have the support of a professional logo design agency that understands the
                                    intricacies of the digital landscape. Our dedicated team is committed to delivering
                                    outstanding results, and we take pride in being a trusted design company in San
                                    Jose. We combine our expertise, creativity, and brand strategy to provide you with a
                                    comprehensive solution that drives your business forward.</li>
                                <li class="mb-2 mt-3"><strong>Conclusion</strong><br>
                                    Contact San Jose Logo Design today to embark on a journey of digital transformation.
                                    As the best logo design company in the USA, we are passionate about elevating brands
                                    and helping businesses succeed. Whether you need a logo, website design, or digital
                                    marketing services, our team is ready to assist you. Let us be the driving force
                                    behind your success in the ever-evolving digital landscape.
                                </li>

                            </ul>
                            <div class="white-bg box-shadow radius px-4 py-4 mt-5">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="counter"> <i class="flaticon-development"></i>
                                            <span class="count-number" data-to="2304" data-speed="10000">2304</span>
                                            <h5>Success</h5>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 xs-mt-3">
                                        <div class="counter"> <i class="flaticon-user"></i>
                                            <span class="count-number" data-to="3498" data-speed="10000">3498</span>
                                            <h5>Happy Clients</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!--about end-->




            <!--content start-->

            <section class="overflow-hidden">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="info-img position-relative">
                                <video class="video-fluid" autoplay muted loop>
                                    <source src="images/video-2.mp4" type="video/mp4">
                                </video>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12 mt-5 mt-lg-0">
                            <div class="section-title mb-4">
                                <h2 class="title">Our
                                    Comprehensive Process</h2>
                                <p class="mb-0 text-black">Our creative team thinks out of the box and comes up with
                                    innovative ideas that boost our creativity for considering a picture or painting in
                                    different ways. And integrity is the main reason behind the quality design by our
                                    designers. The management takes online issues effectively, and tasks have been
                                    accomplished quickly. Teamwork makes us experts in multitasking, revising, and
                                    delivering each project on time, so customer satisfaction is guaranteed at every
                                    process stage.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!--content end-->








            <!--project start-->

            <section class="overflow-hidden p-0" data-bg-img="images/pattern/01.png">
                <div class="container text-center">
                    <div class="row">
                        <div class="col-lg-8 col-md-12 mx-auto">
                            <div class="section-title">
                                <h6>Project</h6>
                                <h2 class="title">We’ve done lot’s of work, Let’s Check some
                                    from here</h2>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 col-md-12">
                            <div class="portfolio-filter">
                                <button data-filter="" class="is-checked .cat1">All</button>
                                <button data-filter=".cat1">Logo</button>
                                <button data-filter=".cat2">Website</button>
                                <button data-filter=".cat3">Mobile App</button>
                                <button data-filter=".cat4">Print</button>
                                <button data-filter=".cat5">Animation</button>
                                <button data-filter=".cat6">Digital Marketing</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="container-fluid p-0">
                    <div class="row">
                        <div class="col-lg-12 col-md-12">
                            <div class="grid columns-3 row g-0 popup-gallery">
                                <div class="grid-sizer"></div>

                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/n1.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/n1.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/n2.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/n2.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/n3.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/n3.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>


                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/n4.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/n4.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/n5.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/n5.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/n6.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/n6.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/n7.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/n7.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/logo4.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/logo4.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>


                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/logo2.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/logo2.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/logo3.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/logo3.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/4.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/4.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/5.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/5.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/6.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/6.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>



                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/logo8.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/logo8.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat1">
                                    <a data-fancybox="gallery" data-src="images/logoCV/logo9.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/logoCV/logo9.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Logo</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat2">
                                    <a data-fancybox="gallery" data-src="images/webCV/1.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/webCV/1.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Website</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat2">
                                    <a data-fancybox="gallery" data-src="images/webCV/2.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/webCV/2.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Website</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat2">
                                    <a data-fancybox="gallery" data-src="images/webCV/3.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/webCV/3.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Website</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat2">
                                    <a data-fancybox="gallery" data-src="images/webCV/4.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/webCV/4.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Website</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat2">
                                    <a data-fancybox="gallery" data-src="images/webCV/5.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/webCV/5.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Website</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat2">
                                    <a data-fancybox="gallery" data-src="images/webCV/6.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/webCV/6.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Website</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat4">
                                    <a data-fancybox="gallery" data-src="images/printCV/1.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/printCV/1.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Print</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat4">
                                    <a data-fancybox="gallery" data-src="images/printCV/2.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/printCV/2.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Print</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat4">
                                    <a data-fancybox="gallery" data-src="images/printCV/3.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/printCV/3.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Print</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat4">
                                    <a data-fancybox="gallery" data-src="images/printCV/4.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/printCV/4.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Print</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat4">
                                    <a data-fancybox="gallery" data-src="images/printCV/5.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/printCV/5.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Print</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat4">
                                    <a data-fancybox="gallery" data-src="images/printCV/6.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/printCV/6.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Print</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat3">
                                    <a data-fancybox="gallery" data-src="images/mobileCV/1.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/mobileCV/1.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Mobile Apps</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat3">
                                    <a data-fancybox="gallery" data-src="images/mobileCV/2.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/mobileCV/2.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Mobile Apps</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat3">
                                    <a data-fancybox="gallery" data-src="images/mobileCV/3.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/mobileCV/3.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Mobile Apps</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat3">
                                    <a data-fancybox="gallery" data-src="images/mobileCV/4.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/mobileCV/4.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Mobile Apps</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat3">
                                    <a data-fancybox="gallery" data-src="images/mobileCV/5.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/mobileCV/5.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Mobile Apps</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat3">
                                    <a data-fancybox="gallery" data-src="images/mobileCV/6.jpg" data-width="740"
                                        data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/mobileCV/6.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Mobile Apps</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat5">
                                    <a data-fancybox="video-gallery" data-src="images/animation/video1.mp4"
                                        data-width="640" data-height="360">
                                        <div class="portfolio-item">
                                            <img src="images/animation/video1.png" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Animation</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat5">
                                    <a data-fancybox="video-gallery" data-src="images/animation/video2.mp4"
                                        data-width="640" data-height="360">
                                        <div class="portfolio-item">
                                            <img src="images/animation/video2.png" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Animation</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat5">
                                    <a data-fancybox="video-gallery" data-src="images/animation/video3.mp4"
                                        data-width="640" data-height="360">
                                        <div class="portfolio-item">
                                            <img src="images/animation/video3.png" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Animation</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat5">
                                    <a data-fancybox="video-gallery" data-src="images/animation/video4.mp4"
                                        data-width="640" data-height="360">
                                        <div class="portfolio-item">
                                            <img src="images/animation/video4.png" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Animation</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat5">
                                    <a data-fancybox="video-gallery" data-src="images/animation/video5.mp4"
                                        data-width="640" data-height="360">
                                        <div class="portfolio-item">
                                            <img src="images/animation/video5.png" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Animation</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat5">
                                    <a data-fancybox="video-gallery" data-src="images/animation/video6.mp4"
                                        data-width="640" data-height="360">
                                        <div class="portfolio-item">
                                            <img src="images/animation/video6.png" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Animation</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat6">
                                    <a data-fancybox="gallery" data-src="images/digital-marketingCV/1.jpg"
                                        data-width="740" data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/digital-marketingCV/1.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Digital Marketing</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat6">
                                    <a data-fancybox="gallery" data-src="images/digital-marketingCV/2.jpg"
                                        data-width="740" data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/digital-marketingCV/2.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Digital Marketing</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat6">
                                    <a data-fancybox="gallery" data-src="images/digital-marketingCV/3.jpg"
                                        data-width="740" data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/digital-marketingCV/3.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Digital Marketing</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat6">
                                    <a data-fancybox="gallery" data-src="images/digital-marketingCV/4.jpg"
                                        data-width="740" data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/digital-marketingCV/4.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Digital Marketing</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat6">
                                    <a data-fancybox="gallery" data-src="images/digital-marketingCV/5.jpg"
                                        data-width="740" data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/digital-marketingCV/5.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Digital Marketing</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <div class="grid-item cat6">
                                    <a data-fancybox="gallery" data-src="images/digital-marketingCV/6.jpg"
                                        data-width="740" data-height="460">
                                        <div class="portfolio-item">
                                            <img src="images/digital-marketingCV/6.jpg" class="img-fluid w-100" />
                                            <div class="portfolio-title"> <span>Services</span>
                                                <h4>Digital Marketing</h4>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </div>
        </section>

        <!--project end-->
        @include('includes.clientlogosection')
        @include('includes.testimonialsection')
        @include('includes.blogsection')


    </div>

    <!--body content end-->

    @include('includes.footer')
    </div>

    @include('includes.popup')
    <!-- page wrapper end -->
    <!--back-to-top start-->
    <div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-upload"></i></a></div>
    <!--back-to-top end-->
    @include('includes.scripts')




</body>

</html>
