<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PagesController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/','PagesController@welcome');
Route::get('/thankyou', function () {
    return view('thankyou');
});

Route::get('/logo-form', function () {
    return view('logo-form');
});

Route::get('/ip', function () {
  
    $exitCode = Artisan::call('cache:clear');
    return $exitCode;
    // $ip = $_SERVER['REMOTE_ADDR'];
    // $LocationArray = json_decode( file_get_contents('http://ip-get-geolocation.com/api/json/'.$ip), true);
    // $country = $LocationArray['countryCode'];
  
    // if ($country == 'PK') {
    //     $pagedata = DB::select("SELECT * FROM pages WHERE page_slug='maintenance'");
    //     return view('maintenance')->with(['pagedata' => $pagedata]);
    // }else{
    //     return view('/');
    // }
   
      
});


//Brief Forms 
Route::get('/website-brief','BriefController@web');
Route::get('/logo-brief','BriefController@logo');

Route::post('/add-website-brief','BriefController@add_website_brief');
Route::post('/add-logo-brief','BriefController@add_logo_brief');

Route::get('/website-brief-email/{id}','BriefController@brief_email_website');
Route::get('/logo-brief-email/{id}','BriefController@brief_email_logo');


//Header

// Route::get('/animation','PagesController@animation');
// Route::get('/mobile-apps','PagesController@mobileapps');
// Route::get('/digital-marketing','PagesController@digitalmarketing');
// Route::get('/seo','PagesController@seo');

//Footer
// Route::get('/about-us','PagesController@about');
// Route::get('/service','PagesController@service');
// Route::get('/blog','PagesController@blog');
// Route::get('/contact','PagesController@contact');
// Route::get('/privacy-policy','PagesController@privacy');
// Route::get('/terms-and-conditions','PagesController@terms');
Route::get('/payment-secure','PagesController@securepayment');

//contact-us Email
Route::post('/contact-us','PagesController@emailcontact');

//Billing Details
Route::get('payment-info','PackagesController@billing');
Route::post('/payment/{slug}','PagesController@billing');

Route::post('/create-payment-intent', [PagesController::class, 'createPaymentIntent']);
Route::post('/handle-3d-secure', [PagesController::class, 'handle3DSecure']);

Route::post('/package-select','PagesController@packageselect');
Route::post('/missed-leads','PagesController@saveMissedLead');


Route::get('/stripe', 'StripeController@handleGet');
Route::post('/stripe', 'StripeController@handlePost')->name('stripe.payment');

//stripe
Route::get('/checkout/{id}','CheckoutController@afterpayment')->name('checkout.payment-secure');

Route::get('/complete-payment/{slug}','PagesController@securepay');
Route::get('/simple-lead/{slug}','CheckoutController@simpleLead');
Route::get('/create-user-account/{slug}','CheckoutController@createuser');
Route::get('/genrate-inovice/{slug}','CheckoutController@invoice');
Route::get('/genrate/{slug}','CheckoutController@chec');

// Blogs
Route::get('/blog/{slug}','PagesController@blogdetails');

Route::get('/{slug}','PagesController@Pages');

