<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Logo Creator | San Jose Logo Design</title>
    <link rel="stylesheet" href="/css/logostyles.css?v=1.1">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-nice-select/1.1.0/css/nice-select.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
</head>

<body>

    <section class="logo-step-form logo-start-form">
        <div class="container">

            <div class="content-area">
                <div class="animated-logos">
                    <div class="img">
                        <img src="/images/logoform/logo1.png" alt="">
                    </div>
                </div>

                <form action="/thankyou" methos="GET">
                    <div class="form-wrapper">
                    <!-- Step 1: Logo Name -->
                    <div class="step" id="step1">
                        <div class="step-header">
                            <h2>Perfect! Let's confirm your business name</h2>
                            <p>You can modify it if needed</p>
                        </div>
                        <div class="input-group">
                            <label for="logoNameStep">Business Name</label>
                            <input type="text" id="logoNameStep" placeholder="Enter your business name">
                            <span class="input-focus"></span>
                        </div>
                        <div class="step-completion" id="completion1">
                            <i class="fas fa-check-circle"></i>
                            <span>Business name confirmed!</span>
                        </div>
                    </div>

                    <!-- Step 2: Slogan -->
                    <div class="step" id="step2">
                        <div class="step-header">
                            <h2>Add a catchy slogan</h2>
                            <p>This is optional but can make your logo more memorable</p>
                        </div>
                        <div class="input-group">
                            <label for="slogan">Slogan (Optional)</label>
                            <input type="text" id="slogan" placeholder="Enter your slogan or tagline">
                            <span class="input-focus"></span>
                        </div>
                        <div class="step-completion" id="completion2">
                            <i class="fas fa-check-circle"></i>
                            <span>Slogan saved!</span>
                        </div>
                    </div>

                    <!-- Step 3: Industry -->
                    <div class="step" id="step3">
                        <div class="step-header">
                            <h2>What's your industry?</h2>
                            <p>This helps us suggest the perfect design style</p>
                        </div>
                        <div class="input-group">
                            <label for="industry">Industry (Optional)</label>
                            <select id="industry" class="niceselect">
                                <option value="">Select your industry</option>
                                <option value="technology">Technology</option>
                                <option value="healthcare">Healthcare</option>
                                <option value="finance">Finance</option>
                                <option value="education">Education</option>
                                <option value="food">Food & Beverage</option>
                                <option value="real-estate">Real Estate</option>
                                <option value="consulting">Consulting</option>
                                <option value="sports">Sports & Fitness</option>
                                <option value="travel">Travel & Tourism</option>
                                <option value="other">Other</option>
                            </select>
                            <span class="input-focus"></span>
                        </div>
                        <div class="step-completion" id="completion3">
                            <i class="fas fa-check-circle"></i>
                            <span>Industry selected!</span>
                        </div>
                    </div>

                    <!-- Step 4: Keywords -->
                    <div class="step" id="step4">
                        <div class="step-header">
                            <h2>Describe your brand</h2>
                            <p>Add keywords that represent your business style</p>
                        </div>
                        <div class="input-group">
                            <label for="keywords">Keywords</label>
                            <input type="text" id="keywords" placeholder="e.g. modern, professional, creative, bold"
                                required>
                            <span class="input-focus"></span>
                        </div>
                        <div class="step-completion" id="completion4">
                            <i class="fas fa-check-circle"></i>
                            <span>Keywords added!</span>
                        </div>
                    </div>

                    <!-- Step 5: Email & Phone (Combined Final Step) -->
                    <div class="step" id="step5">
                        <div class="step-header">
                            <h2>Almost done! Let's get your contact info</h2>
                            <p>We'll send your logo files to your email</p>
                        </div>
                        <div class="input-group">
                            <label for="email">Email Address *</label>
                            <input type="email" id="email" placeholder="Enter your email address" required>
                            <span class="input-focus"></span>
                        </div>
                        <div class="input-group">
                            <label for="phone">Phone Number (Optional)</label>
                            <input type="tel" id="phone" placeholder="Enter your phone number">
                            <span class="input-focus"></span>
                        </div>
                        <div class="step-completion" id="completion5">
                            <i class="fas fa-check-circle"></i>
                            <span>Contact info saved!</span>
                        </div>
                        <div class="final-step-actions">
                            <button class="btn-primary" type="button" onclick="submitForm()">
                                <i class="fas fa-magic"></i>
                                Create My Logo
                            </button>
                        </div>
                    </div>
                </div>
                </form>

                <!-- Navigation -->
                <div class="navigation">
                    <button class="nav-btn prev-btn" id="prevBtn" type="button" onclick="previousStep()">
                        <i class="fas fa-arrow-left"></i>
                        Previous
                    </button>
                    <button class="nav-btn next-btn" id="nextBtn" type="button" onclick="nextStep()">
                        Next
                        <i class="fas fa-arrow-right"></i>
                    </button>
                </div>
            </div>
            <?php echo $__env->make('includes.logo-gallery', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </section>

    <?php echo $__env->make('includes.logo-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>

</html><?php /**PATH /home/transmissiondepo/public_html/sanjoselogodesign.com/resources/views/logo-form.blade.php ENDPATH**/ ?>