<!DOCTYPE html>
<html lang="en-US">

<head>
    <meta charset="utf-8">
    <meta name="keywords" content="Sanjose Logo Design - Payment Secure" />
    <meta name="description" content="Payment Secure" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Title -->
    <title>Sanjose Logo Design - Payment Secure</title>
    <script src="https://js.stripe.com/v3/"></script>
  
    <?php echo $__env->make('includes.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style type="text/css">
        .container {
            margin-top: 40px;
        }

        .panel-heading {
            display: inline;
            font-weight: bold;
        }

        .flex-table {
            display: table;
        }

        .display-tr {
            display: table-row;
        }

        .display-td {
            display: table-cell;
            vertical-align: middle;
            width: 55%;
        }

        .btn-theme {
            border: 0px;
            height: 50px;
            border-radius: 5px;

        }
        div#card-errors {
            text-align: left;
            margin-top: 10px;
            font-size: 15px;
            color: #ed3840;
            font-style: italic;
        }
        .form-check-input:checked {
            background-color: #ff7810;
            border-color: #ff7810;
        }
    </style>
</head>

<body>


    <!-- page wrapper start -->

    <div class="page-wrapper">

        <!-- preloader start -->

        <div id="ht-preloader">
            <div class="loader clear-loader">
                <div class="loader-text">Loading</div>
                <div class="loader-dots"> <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
            </div>
        </div>
        <!-- preloader end -->
        <?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!--page title start-->

        <section class="page-title overflow-hidden text-center light-bg bg-contain animatedBackground"
            data-bg-img="images/pattern/05.png">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <h1 class="title">Pay & Proceed</h1>

                    </div>
                </div>
            </div>

            <div class="page-title-pattern"><img class="img-fluid" src="images/bg/06.png" alt=""></div>
            <section class="contact-1" data-bg-img="images/pattern/02.png">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <div class="contact-main">
                                <div class="flex">
                                    <form action="/payment" id="contact-form" class="row g-4 needs-validation "
                                        method="post" novalidate>
                                        <div class="messages"></div>

                                        <div class="offset-md-2 col-md-10 offset-md-2">
                                            <!-- <h6 class="text-start">Name</h6> -->
                                            <input id="customer-name" type="text" name="name"
                                                class="form-control  fs-6 shadow" placeholder="Name"
                                                value="<?php echo e($data->customer_name); ?>" readonly>
                                            <div class="invalid-feedback"></div>
                                        </div>
                                        <div class="offset-md-2 col-md-10 offset-md-2">
                                            <!-- <h6 class="text-start">E-Mail</h6> -->
                                            <input id="customer-email" type="email" name="email"
                                                value="<?php echo e($data->email); ?>" class="form-control fs-6 shadow"
                                                placeholder="E-Mail" readonly>
                                            <div class="invalid-feedback"></div>
                                        </div>
                                        <div class="offset-md-2 col-md-10 offset-md-2">
                                            <!-- <h6 class="text-start">Phone</h6> -->
                                            <input id="phone" type="tel" name="phone"
                                                value="<?php echo e($data->phone_no); ?>" class="form-control fs-6 shadow"
                                                placeholder="Phone" readonly>
                                            <div class="invalid-feedback"></div>
                                        </div>

                                        <div class="offset-md-2 col-md-10 offset-md-2">
                                            <!-- <h6 class="text-start">Package</h6> -->
                                            <input id="package" type="tel" name="phone"
                                                value="<?php echo e($data->custom_package_name); ?>"
                                                class="form-control fs-6 shadow" placeholder="Package" readonly>
                                            <div class="invalid-feedback"></div>
                                        </div>

                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-6" style="margin-top:9px;">
                            <div class="contact-main">
                                <div class="flex mt-3">
                                    
                                    <form id="payment-form" novalidate>
                                        
                                        <div class="form-group">
                                            <input class="form-control fs-6 shadow border-0 rounded " type="number"
                                                name="amount" id="" value="<?php echo e($data->price); ?>" readonly>
                                        </div>
                                        <div class="form-group ">
                                            <input class="form-control fs-6 shadow border-0 rounded  " type="text"
                                                name="name" id="cardHolderName" placeholder="Name on Card" required>
                                        </div>

                                        <div class="form-group" style="margin-top: 1.6rem !important; ">
                                            <div class="card-body bg-white rounded  border-0 fs-6 shadow" style="height:50px !important">
                                                <div id="card-element">
                                                    <!-- A Stripe Element will be inserted here. -->
                                                </div>
                                                <!-- Used to display form errors. -->
                                               
                                                <input type="hidden" name="plan" value="" />
                                            </div>
                                             <div id="card-errors" role="alert"></div>
                                        </div>
                                        <input type="hidden" name="name" value="<?php echo e($data->customer_name); ?>">
                                        <input type="hidden" name="email" value="<?php echo e($data->email); ?>">
                                        <input type="hidden" name="phone" value="<?php echo e($data->phone_no); ?>">
                                        <input type="hidden" name="package"
                                            value="<?php echo e($data->custom_package_name); ?>">
                                        <input type="hidden" name="price" value="<?php echo e($data->price); ?>">
                                        <input type="hidden" name="password" value="<?php echo e($data->password); ?>">
                                        <input type="hidden" id="leadId" name="leadId" value="<?php echo e($data->id); ?>">
                                        
                                        <input type="hidden" name="package_id" value=" <?php echo e($data->package_id); ?>">
                                        
                                        <div class="form-group pt-3" style="float: left;height: 50px">
                                            <input class="form-check-input" type="checkbox" id="termprivacy"
                                                value="" required="">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                I agree with the <a href="/privacy-policy">Privacy Policy</a> &amp; <a
                                                    href="/terms-condition"> Terms and Condition.</a>
                                            </label>
                                            <h6 class=" col-md-12 error_pop text-danger pt-1"
                                                style=" text-align: initial;font-weight: 600;font-size: 0.8rem;"></h6>
                                        </div>

                                       
                                        <div class="btnpay ">

                                            <button id="submit" class="mt-3 btn-theme col-md-12 text-white"
                                                type="submit" style="background:rgb(255,120,16)"> Proceed </button>
                                        </div>

                                        <div class="pay-field" style="float: right;">
                                            <img src="<?php echo e(env('APP_URL')); ?>images/securepaymentusa.png" alt=""
                                                class="img-fluid">
                                        </div>
                                    </form>


                                </div>
                            </div>
                        </div>
                        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
                        
                        <script>
                            const stripe = Stripe('<?php echo e(env('STRIPE_KEY')); ?>');
                            const elements = stripe.elements();
                            const cardElement = elements.create('card');

                            cardElement.mount('#card-element');

                            const form = document.getElementById('payment-form');
                            const submitButton = document.getElementById('submit');

                            form.addEventListener('submit', async (event) => {
                                event.preventDefault();

                                const {
                                    token,
                                    error
                                } = await stripe.createToken(cardElement);

                                if (error) {
                                    const errorElement = document.getElementById('card-errors');
                                    errorElement.textContent = error.message; // Display the error message to the user.
                                        
                                } else {
                                    // Send the token to your server for payment processing
                                    const response = await fetch('/create-payment-intent', {
                                        method: 'POST',
                                        headers: {
                                            'Content-Type': 'application/json',
                                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute(
                                                'content'),
                                        },
                                        body: JSON.stringify({
                                            token: token.id,
                                            name: $('#customer-name').val(),
                                            email: $('#customer-email').val(),
                                            leadId: $('#leadId').val(),
                                        }),
                                    });


                                    const {
                                        clientSecret
                                    } = await response.json();

                                    const {
                                        paymentIntent,
                                        error: intentError
                                    } = await stripe.confirmCardPayment(clientSecret, {
                                        payment_method: {
                                            card: cardElement,
                                        },
                                    });
                                    console.log(paymentIntent.status);
                                    if (intentError) {
                                    } else if (paymentIntent.status === 'requires_action') {
                                        stripe.handleCardAction(clientSecret).then(function(result) {
                                            if (result.error) {
                                                if (result.error.type === 'redirect') {
                                                    window.location.href = result.error.redirect.url;
                                                } else {
                                                     const errorElement = document.getElementById('card-errors');
                                                        errorElement.textContent = result.error.message; 
                                                }
                                            } else {
                                                window.location.href = '/payment-success'; // Replace with your success pag
                                            }

                                        });
                                    } else if (paymentIntent.status === 'succeeded') {
                                        window.location = '/checkout/<?php echo e($data->id); ?>';
                                    }
                                }
                            });
                        </script>
                    </div>
                </div>
    </div>

    </div>
    </div>
    </section>
    </section>

   


    <?php echo $__env->make('includes/testimonialsection', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <?php echo $__env->make('includes/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>

    <div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-upload"></i></a></div>

 


    <?php echo $__env->make('includes/scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>



</html>
<?php /**PATH /home/transmissiondepo/public_html/sanjoselogodesign.com/resources/views/payment-secure.blade.php ENDPATH**/ ?>