<!DOCTYPE html>
<html lang="en-US">


<head>
   <?php $blog =  DB::table('blogs')->where('slug', $blogSlug)->first(); ?>
 
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($blog->seo_title ?? $blog->blog_name); ?></title>
    <meta name="description" content="<?php echo e($blog->seo_description); ?>">
    <meta name="robots" content="index,follow">
    <meta name="googlebot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1">
    <meta name="bingbot" content="index,follow,max-snippet:-1,max-image-preview:large,max-video-preview:-1">
    <meta name="keywords" content="<?php echo e($blog->seo_keywords); ?>">
    <link rel="canonical" href="<?php echo e(env('BASE_URL') . $_SERVER['REQUEST_URI']); ?>">
    <meta property="og:locale" content="en_US" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="<?php echo e($blog->seo_title ?? $blog->blog_name); ?>" />
    <meta property="og:description" content="<?php echo e($blog->seo_description); ?>" />
    <meta property="og:url" content="<?php echo e(env('BASE_URL') . $_SERVER['REQUEST_URI']); ?>" />
    <meta property="og:site_name" content="<?php echo env('SEO_APP_NAME'); ?>" />
    <meta property="og:publish_date" name="publish_date" content="<?php echo e($blog->published_date); ?>">
    <meta property="og:image" content="<?php echo env('SYMMLINK') . 'blog_images/' . $blog->blog_cover; ?>" />
    <meta property="og:image:width" content="300" />
    <meta property="og:image:height" content="300" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="<?php echo e($blog->seo_title ?? $blog->blog_name); ?>" />
    <meta name="twitter:description" content="<?php echo e($blog->seo_description); ?>" />
    <meta property="twitter:url" content="<?php echo env('SYMMLINK') . 'blog_images/' . $blog->blog_cover; ?>" />
    <meta name="twitter:image" content="<?php echo env('SYMMLINK') . 'blog_images/' . $blog->blog_cover; ?>" />
    <meta name="twitter:creator" content="@<?php echo env('SEO_APP_NAME'); ?>" />
    <meta name="twitter:site" content="@<?php echo env('SEO_APP_NAME'); ?>" />
    <meta name="twitter:label1" content="Written by">
    <meta name="twitter:data1" content="<?php echo env('SEO_APP_NAME'); ?>">
    <meta name="twitter:label2" content="Est. reading time">
    <meta name="twitter:data2" content="4 minutes">

    <?php echo $__env->make('includes.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    
    <style>
        ul,ol {
            padding-left: 26px;
        }
        .post-desc a {
            color: #4f4e4e;
            text-decoration: underline;
        }
        .post .post-desc p {
            margin: 0;
            margin-bottom: 16px;
        }
        
        .post .post-desc h3 {
            font-size: 20px!important;
            font-weight: 600;
        }
    </style>

</head>

<body>

    <!-- page wrapper start -->

    <div class="page-wrapper">

        <!-- preloader start -->

        <div id="ht-preloader">
            <div class="loader clear-loader">
                <div class="loader-text">Loading</div>
                <div class="loader-dots"> <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
            </div>
        </div>

        <!-- preloader end -->


        <?php echo $__env->make('includes/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!--page title start-->

        <section class="page-title overflow-hidden text-center light-bg bg-contain animatedBackground"
            data-bg-img="https://sanjoselogodesign.com/images/pattern/05.png">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <h1 class="title"><?php echo e($blog->blog_name); ?></h1>

                    </div>
                </div>
            </div>
            <div class="page-title-pattern"><img class="img-fluid" src="https://sanjoselogodesign.com/images/bg/06.png" alt=""></div>
        </section>

        <!--page title end-->


        <!--body content start-->

        <div class="page-content">

            <!--blog start-->

            <section>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="left-side">
                                <div class="post">
                                    <div class="post-image">
                                        <img class="img-fluid" src="<?php echo e('https://crm.sanjoselogodesign.com/storage/app/public/blog_images/'.$blog->blog_cover); ?>" alt="">
                                    </div>
                                    <div class="post-desc">
                                        <div class='blogmetadet d-flex mb-3' style="gap: 10px;">
                                            <div class="metasing">
                                                <i class="fa-solid fa-circle-user"></i> By <?php echo e($blog->posted_by); ?>

                                            </div>
                                            <div class="metasing">
                                                <i class="fa-regular fa-calendar"></i> <?php echo e(date('j F, Y	', strtotime($blog->published_date))); ?>

                                            </div>
                                        </div>
                                           
                                        <div class="post-title">
                                            <h2><?php echo e($blog->blog_name); ?></h2>
                                        </div>
                                           <?php echo $blog->blog_html; ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-12 sidebar mt-5 mt-lg-0 d-none">
                            
                            <div class="widget theme-bg text-white">
                                <div class="owl-carousel no-pb" data-items="1" data-dots="false" data-autoplay="true">
                                    <div class="item">
                                        <div class="testimonial style-2">
                                            <div class="testimonial-content">
                                                <div class="testimonial-quote"><i class="flaticon-quotation"></i>
                                                </div>
                                                <p>We’re delighted to be working with SanJose Logo Design. As we build and scale
                                                    our business, our
                                                    strategic partners must bring innovative and customer-focused
                                                    marketing strategies.
                                                    Hair by Sleek did extensive research to find a digital agency
                                                    partner that could fulfill
                                                    these criteria, and SanJose surpassed on all fronts.</p>
                                                <div class="testimonial-caption">
                                                    <h5>Jessica lemauk</h5>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="item">
                                        <div class="testimonial style-2">
                                            <div class="testimonial-content">
                                                <div class="testimonial-quote"><i class="flaticon-quotation"></i>
                                                </div>
                                                <p>Working in the media marketing agency, I always recommend SanJose
                                                    Logo Design to my clients
                                                    for a better success rate of the entire marketing strategy and they
                                                    never fail to deliver.
                                                    Looking forward to work with them in the future.</p>
                                                <div class="testimonial-caption">
                                                    <h5>Dinku adale</h5>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="item">
                                        <div class="testimonial style-2">
                                            <div class="testimonial-content">
                                                <div class="testimonial-quote"><i class="flaticon-quotation"></i>
                                                </div>
                                                <p>The SanJose Logo Design team is smart, efficient and fast. Highly responsive and
                                                    technically astute, they
                                                    have a rare sense of urgency and usually answer requests the same
                                                    day. I'm impressed by the
                                                    depth and knowledge of their staff.</p>
                                                <div class="testimonial-caption">
                                                    <h5>Kevin Mcmahon</h5>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="item">
                                        <div class="testimonial style-2">
                                            <div class="testimonial-content">
                                                <div class="testimonial-quote"><i class="flaticon-quotation"></i>
                                                </div>
                                                <p>Their designing team helped me with my startup from the beginning and
                                                    gave full support and
                                                    maintenance until I reached my desired goals with my branding
                                                    expectations. I can never thank
                                                    them enough for their impeccable services.</p>
                                                <div class="testimonial-caption">
                                                    <h5>Sergio Neuwendo</h5>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="widget recent-post">
                                 <?php $recentBlogs = DB::table('blogs')->where('slug','!=',$blogSlug)->take(3)->latest()->get(); ?>
                                <h5 class="widget-title">Recent Post</h5>
                                  <?php $__currentLoopData = $recentBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <article>
                                    <div class="row">
                                        <div class="col-sm">
                                             <a href="#"><img src="<?php echo e('https://crm.sanjoselogodesign.com/storage/app/public/blog_images/'.$recent->blog_cover); ?>" alt="girl" class="img-fluid" /></a>
                                        </div>
                                        <div class="col-sm-9 mt-3 mt-sm-0"> <a href="/blog/<?php echo e($recent->slug); ?>"><?php echo e($recent->blog_name); ?></a>
                                            <div class="post-date"><?php echo e(date('j F, Y	', strtotime($recent->published_date))); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </article>
                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                             
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!--blog end-->

        </div>

        <?php echo $__env->make('includes/counter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;
    <?php echo $__env->make('includes/clientlogosection', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;
    <?php echo $__env->make('includes/testimonialsection', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;
    <?php echo $__env->make('includes/blogsection', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;
    <?php echo $__env->make('includes/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;


    </div>

    <!-- page wrapper end -->


    <!--back-to-top start-->

    <div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-upload"></i></a></div>

    <!--back-to-top end-->


    <?php echo $__env->make('includes/scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;

</body>



</html><?php /**PATH /home/transmissiondepo/public_html/sanjoselogodesign.com/resources/views/blog-details.blade.php ENDPATH**/ ?>